/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import kala.collection.Map;
import kala.collection.base.MapBase;
import kala.collection.factory.MapFactory;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMapEditor;
import kala.collection.mutable.MutableMapLike;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public interface MutableMap<K, V>
extends Map<K, V>,
MutableMapLike<K, V> {
    @NotNull
    public static <K, V> MapFactory<K, V, ?, MutableMap<K, V>> factory() {
        return MutableHashMap.factory();
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, MutableMap<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(MutableMap.factory(), keyMapper, valueMapper);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> create() {
        return MutableHashMap.create();
    }

    @NotNull
    public static <K, V> MutableMap<K, V> of() {
        return MutableHashMap.of();
    }

    @NotNull
    public static <K, V> MutableMap<K, V> of(K k1, V v1) {
        return MutableHashMap.of(k1, v1);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return MutableHashMap.of(k1, v1, k2, v2);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return MutableHashMap.of(k1, v1, k2, v2, k3, v3);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return MutableHashMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return MutableHashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries() {
        return MutableHashMap.ofEntries();
    }

    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        return MutableHashMap.ofEntries(entry1);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        return MutableHashMap.ofEntries(entry1, entry2);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        return MutableHashMap.ofEntries(entry1, entry2, entry3);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        return MutableHashMap.ofEntries(entry1, entry2, entry3, entry4);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        return MutableHashMap.ofEntries(entry1, entry2, entry3, entry4, entry5);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> MutableMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        return MutableHashMap.from(entries);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> from(@NotNull java.util.Map<? extends K, ? extends V> values) {
        return MutableHashMap.from(values);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> from(@NotNull MapBase<? extends K, ? extends V> values) {
        return MutableHashMap.from(values);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        return MutableHashMap.from(values);
    }

    @NotNull
    public static <K, V> MutableMap<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        return MutableHashMap.from(values);
    }

    public static <K, V> MutableMap<K, V> wrapJava(@NotNull java.util.Map<K, V> map) {
        Objects.requireNonNull(map);
        if (map instanceof AsJavaConvert.MutableMapAsJava) {
            return (MutableMap)((AsJavaConvert.MutableMapAsJava)map).source;
        }
        return new FromJavaConvert.MutableMapFromJava<K, V>(map);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableMap";
    }

    @Override
    @NotNull
    default public <NK, NV> MapFactory<NK, NV, ?, ? extends MutableMap<NK, NV>> mapFactory() {
        return MutableMap.factory();
    }

    @NotNull
    default public MutableMapEditor<K, V, ? extends MutableMap<K, V>> edit() {
        return new MutableMapEditor(this);
    }

    @Override
    default public @NotNull java.util.Map<K, V> asJava() {
        return new AsJavaConvert.MutableMapAsJava(this);
    }
}

