/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kala.collection.Map;
import kala.collection.MapLike;
import kala.collection.base.MapBase;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableMapLike<K, V>
extends MapLike<K, V> {
    @Override
    @NotNull
    default public String className() {
        return "MutableMapLike";
    }

    default public V getOrPut(K key, @NotNull Supplier<? extends V> defaultValue) {
        Option res = this.getOption(key);
        if (res.isDefined()) {
            return (V)res.get();
        }
        V v = defaultValue.get();
        this.set(key, v);
        return v;
    }

    @NotNull
    public Option<V> put(K var1, V var2);

    @NotNull
    default public Option<V> put(@NotNull Tuple2<? extends K, ? extends V> kv) {
        return this.put(kv.getKey(), kv.getValue());
    }

    default public void set(K key, V value) {
        this.put(key, value);
    }

    default public void set(@NotNull Tuple2<? extends K, ? extends V> kv) {
        this.set(kv.getKey(), kv.getValue());
    }

    @NotNull
    default public Option<V> putIfAbsent(K key, V value) {
        Option<V> v = this.getOption(key);
        if (v.isEmpty()) {
            v = this.put(key, value);
        }
        return v;
    }

    default public void putAll(@NotNull java.util.Map<? extends K, ? extends V> m) {
        if (m instanceof AsJavaConvert.MapAsJava) {
            this.putAll((Map)((Object)m));
            return;
        }
        m.forEach(this::set);
    }

    default public void putAll(@NotNull MapBase<? extends K, ? extends V> m) {
        if (m == this) {
            return;
        }
        m.forEach(this::set);
    }

    @NotNull
    public Option<V> remove(K var1);

    @Contract(mutates="this")
    public void clear();

    @NotNull
    default public Option<V> replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.put(key, value);
        }
        return Option.none();
    }

    default public boolean replace(K key, V oldValue, V newValue) {
        if (this.contains(key, oldValue)) {
            this.set(key, newValue);
            return true;
        }
        return false;
    }

    public void replaceAll(@NotNull BiFunction<? super K, ? super V, ? extends V> var1);

    @NotNull
    default public MutableSet<Tuple2<K, V>> asMutableSet() {
        return new MutableSet<Tuple2<K, V>>(){

            @Override
            public final boolean add(@NotNull Tuple2<K, V> value) {
                return !MutableMapLike.this.put(value._1, value._2).isEmpty();
            }

            @Override
            public final boolean remove(Object value) {
                if (!(value instanceof Tuple2)) {
                    return false;
                }
                Tuple2 tuple = (Tuple2)value;
                if (MutableMapLike.this.contains(tuple)) {
                    MutableMapLike.this.remove(tuple._1);
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                MutableMapLike.this.clear();
            }

            @NotNull
            public Iterator<Tuple2<K, V>> iterator() {
                return MutableMapLike.this.iterator();
            }
        };
    }
}

