/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Consumer;
import kala.comparator.Comparators;
import kala.internal.ComparableUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RedBlackTree<A, N extends TreeNode<A, N>>
implements Serializable {
    private static final long serialVersionUID = 3036340578028981301L;
    static final boolean RED = true;
    static final boolean BLACK = false;
    @Nullable
    final Comparator<? super A> comparator;
    transient N root;
    transient int size;

    RedBlackTree(Comparator<? super A> comparator) {
        this.comparator = comparator == null ? Comparators.naturalOrder() : comparator;
    }

    @Nullable
    final N getNode(Object key) {
        try {
            Comparator<A> comparator = this.comparator;
            Object n = this.root;
            if (comparator == null) {
                while (n != null) {
                    int c = ComparableUtils.compare((Object)key, ((TreeNode)n).key);
                    if (c < 0) {
                        n = ((TreeNode)n).left;
                        continue;
                    }
                    if (c > 0) {
                        n = ((TreeNode)n).right;
                        continue;
                    }
                    return n;
                }
            } else {
                while (n != null) {
                    int c = comparator.compare(key, ((TreeNode)n).key);
                    if (c < 0) {
                        n = ((TreeNode)n).left;
                        continue;
                    }
                    if (c > 0) {
                        n = ((TreeNode)n).right;
                        continue;
                    }
                    return n;
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    final N firstNode() {
        Object node = this.root;
        if (node == null) {
            return null;
        }
        while (((TreeNode)node).left != null) {
            node = ((TreeNode)node).left;
        }
        return node;
    }

    @Nullable
    final N lastNode() {
        Object node = this.root;
        if (node == null) {
            return null;
        }
        while (((TreeNode)node).right != null) {
            node = ((TreeNode)node).right;
        }
        return node;
    }

    static boolean colorOf(TreeNode<?, ?> p) {
        return p == null ? false : p.color;
    }

    static <T extends TreeNode<?, T>> T parentOrNull(T p) {
        return p == null ? null : (T)p.parent;
    }

    static void setColor(TreeNode<?, ?> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    static <T extends TreeNode<?, T>> T leftOrNull(@Nullable T p) {
        return p == null ? null : (T)p.left;
    }

    static <T extends TreeNode<?, T>> T rightOrNull(@Nullable T p) {
        return p == null ? null : (T)p.right;
    }

    static <T extends TreeNode<?, T>> T minNode(@NotNull T node) {
        Object left;
        while ((left = node.left) != null) {
            node = left;
        }
        return node;
    }

    static <T extends TreeNode<?, T>> T maxNode(@NotNull T node) {
        Object right;
        while ((right = node.right) != null) {
            node = right;
        }
        return node;
    }

    static <T extends TreeNode<?, T>> T successor(@NotNull T node) {
        if (node.right != null) {
            return RedBlackTree.minNode(node.right);
        }
        Object n = node.parent;
        T ch = node;
        while (n != null && ch == ((TreeNode)n).right) {
            ch = n;
            n = ((TreeNode)n).parent;
        }
        return n;
    }

    static <T extends TreeNode<?, T>> T predecessor(@NotNull T node) {
        if (node.left != null) {
            return RedBlackTree.maxNode(node.left);
        }
        Object p = node.parent;
        T ch = node;
        while (p != null && ch == ((TreeNode)p).left) {
            ch = p;
            p = ((TreeNode)p).parent;
        }
        return p;
    }

    final void rotateLeft(N node) {
        if (node == null) {
            return;
        }
        Object r = ((TreeNode)node).right;
        ((TreeNode)node).right = ((TreeNode)r).left;
        if (((TreeNode)r).left != null) {
            ((TreeNode)((TreeNode)r).left).parent = node;
        }
        ((TreeNode)r).parent = ((TreeNode)node).parent;
        if (((TreeNode)node).parent == null) {
            this.root = r;
        } else if (((TreeNode)((TreeNode)node).parent).left == node) {
            ((TreeNode)((TreeNode)node).parent).left = r;
        } else {
            ((TreeNode)((TreeNode)node).parent).right = r;
        }
        ((TreeNode)r).left = node;
        ((TreeNode)node).parent = r;
    }

    final void rotateRight(N node) {
        if (node == null) {
            return;
        }
        Object l = ((TreeNode)node).left;
        ((TreeNode)node).left = ((TreeNode)l).right;
        if (((TreeNode)l).right != null) {
            ((TreeNode)((TreeNode)l).right).parent = node;
        }
        ((TreeNode)l).parent = ((TreeNode)node).parent;
        if (((TreeNode)node).parent == null) {
            this.root = l;
        } else if (((TreeNode)((TreeNode)node).parent).right == node) {
            ((TreeNode)((TreeNode)node).parent).right = l;
        } else {
            ((TreeNode)((TreeNode)node).parent).left = l;
        }
        ((TreeNode)l).right = node;
        ((TreeNode)node).parent = l;
    }

    final void fixAfterInsert(N x) {
        ((TreeNode)x).color = true;
        while (x != null && x != this.root && ((TreeNode)((TreeNode)x).parent).color) {
            N y;
            if (RedBlackTree.parentOrNull(x) == RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)))) {
                y = RedBlackTree.rightOrNull(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)));
                if (RedBlackTree.colorOf(y)) {
                    RedBlackTree.setColor(RedBlackTree.parentOrNull(x), false);
                    RedBlackTree.setColor(y, false);
                    RedBlackTree.setColor(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)), true);
                    x = RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x));
                    continue;
                }
                if (x == RedBlackTree.rightOrNull(RedBlackTree.parentOrNull(x))) {
                    x = RedBlackTree.parentOrNull(x);
                    this.rotateLeft(x);
                }
                RedBlackTree.setColor(RedBlackTree.parentOrNull(x), false);
                RedBlackTree.setColor(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)), true);
                this.rotateRight(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)));
                continue;
            }
            y = RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)));
            if (RedBlackTree.colorOf(y)) {
                RedBlackTree.setColor(RedBlackTree.parentOrNull(x), false);
                RedBlackTree.setColor(y, false);
                RedBlackTree.setColor(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)), true);
                x = RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x));
                continue;
            }
            if (x == RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(x))) {
                x = RedBlackTree.parentOrNull(x);
                this.rotateRight(x);
            }
            RedBlackTree.setColor(RedBlackTree.parentOrNull(x), false);
            RedBlackTree.setColor(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)), true);
            this.rotateLeft(RedBlackTree.parentOrNull(RedBlackTree.parentOrNull(x)));
        }
        ((TreeNode)this.root).color = false;
    }

    final void fixAfterDelete(N x) {
        while (x != this.root && !RedBlackTree.colorOf(x)) {
            N sib;
            if (x == RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(x))) {
                sib = RedBlackTree.rightOrNull(RedBlackTree.parentOrNull(x));
                if (RedBlackTree.colorOf(sib)) {
                    RedBlackTree.setColor(sib, false);
                    RedBlackTree.setColor(RedBlackTree.parentOrNull(x), true);
                    this.rotateLeft(RedBlackTree.parentOrNull(x));
                    sib = RedBlackTree.rightOrNull(RedBlackTree.parentOrNull(x));
                }
                if (!RedBlackTree.colorOf(RedBlackTree.leftOrNull(sib)) && !RedBlackTree.colorOf(RedBlackTree.rightOrNull(sib))) {
                    RedBlackTree.setColor(sib, true);
                    x = RedBlackTree.parentOrNull(x);
                    continue;
                }
                if (!RedBlackTree.colorOf(RedBlackTree.rightOrNull(sib))) {
                    RedBlackTree.setColor(RedBlackTree.leftOrNull(sib), false);
                    RedBlackTree.setColor(sib, true);
                    this.rotateRight(sib);
                    sib = RedBlackTree.rightOrNull(RedBlackTree.parentOrNull(x));
                }
                RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOrNull(x)));
                RedBlackTree.setColor(RedBlackTree.parentOrNull(x), false);
                RedBlackTree.setColor(RedBlackTree.rightOrNull(sib), false);
                this.rotateLeft(RedBlackTree.parentOrNull(x));
                x = this.root;
                continue;
            }
            sib = RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(x));
            if (RedBlackTree.colorOf(sib)) {
                RedBlackTree.setColor(sib, false);
                RedBlackTree.setColor(RedBlackTree.parentOrNull(x), true);
                this.rotateRight(RedBlackTree.parentOrNull(x));
                sib = RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(x));
            }
            if (!RedBlackTree.colorOf(RedBlackTree.rightOrNull(sib)) && !RedBlackTree.colorOf(RedBlackTree.leftOrNull(sib))) {
                RedBlackTree.setColor(sib, true);
                x = RedBlackTree.parentOrNull(x);
                continue;
            }
            if (!RedBlackTree.colorOf(RedBlackTree.leftOrNull(sib))) {
                RedBlackTree.setColor(RedBlackTree.rightOrNull(sib), false);
                RedBlackTree.setColor(sib, true);
                this.rotateLeft(sib);
                sib = RedBlackTree.leftOrNull(RedBlackTree.parentOrNull(x));
            }
            RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOrNull(x)));
            RedBlackTree.setColor(RedBlackTree.parentOrNull(x), false);
            RedBlackTree.setColor(RedBlackTree.leftOrNull(sib), false);
            this.rotateRight(RedBlackTree.parentOrNull(x));
            x = this.root;
        }
        RedBlackTree.setColor(x, false);
    }

    final void remove0(N node) {
        Object replacement;
        if (((TreeNode)node).left != null && ((TreeNode)node).right != null) {
            N s = RedBlackTree.successor(node);
            ((TreeNode)node).key = ((TreeNode)s).key;
            node = s;
        }
        Object t = replacement = ((TreeNode)node).left != null ? ((TreeNode)node).left : ((TreeNode)node).right;
        if (replacement != null) {
            ((TreeNode)replacement).parent = ((TreeNode)node).parent;
            if (((TreeNode)node).parent == null) {
                this.root = replacement;
            } else if (node == ((TreeNode)((TreeNode)node).parent).left) {
                ((TreeNode)((TreeNode)node).parent).left = replacement;
            } else {
                ((TreeNode)((TreeNode)node).parent).right = replacement;
            }
            ((TreeNode)node).parent = null;
            ((TreeNode)node).right = null;
            ((TreeNode)node).left = null;
            if (!((TreeNode)node).color) {
                this.fixAfterDelete(replacement);
            }
        } else if (((TreeNode)node).parent == null) {
            this.root = null;
        } else {
            if (!((TreeNode)node).color) {
                this.fixAfterDelete(node);
            }
            if (((TreeNode)node).parent != null) {
                if (node == ((TreeNode)((TreeNode)node).parent).left) {
                    ((TreeNode)((TreeNode)node).parent).left = null;
                } else if (node == ((TreeNode)((TreeNode)node).parent).right) {
                    ((TreeNode)((TreeNode)node).parent).right = null;
                }
                ((TreeNode)node).parent = null;
            }
        }
    }

    final void forEachKey0(@NotNull Consumer<? super A> consumer) {
        Object node = this.root;
        while (node != null) {
            Object n;
            consumer.accept(((TreeNode)node).key);
            if (((TreeNode)node).right != null) {
                n = ((TreeNode)node).right;
                while (((TreeNode)n).left != null) {
                    n = ((TreeNode)n).left;
                }
            } else {
                n = ((TreeNode)node).parent;
                Object c = node;
                while (n != null && c == ((TreeNode)n).right) {
                    c = n;
                    n = ((TreeNode)n).parent;
                }
            }
            node = n;
        }
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    static class TreeNode<A, T extends TreeNode<A, T>> {
        A key;
        T left;
        T right;
        T parent;
        boolean color = false;

        TreeNode(A key, T parent) {
            this.key = key;
            this.parent = parent;
        }
    }
}

