/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.AnyCollectionLike;
import kala.collection.CollectionView;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.base.Traversable;
import kala.collection.factory.MapFactory;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableLinkedSeq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVector;
import kala.collection.mutable.MutableArray;
import kala.tuple.Tuple2;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CollectionLike<E>
extends Traversable<E>,
AnyCollectionLike<E> {
    @Override
    @NotNull
    default public String className() {
        return "CollectionLike";
    }

    @Override
    @NotNull
    public CollectionView<E> view();

    @NotNull
    public CollectionLike<E> filter(@NotNull Predicate<? super E> var1);

    @NotNull
    public CollectionLike<E> filterNot(@NotNull Predicate<? super E> var1);

    @NotNull
    public @NotNull CollectionLike<@NotNull E> filterNotNull();

    @NotNull
    public <U> @NotNull CollectionLike<@NotNull U> filterIsInstance(@NotNull Class<? extends U> var1);

    @NotNull
    public <U> CollectionLike<U> map(@NotNull Function<? super E, ? extends U> var1);

    @NotNull
    public <U> CollectionLike<U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> var1);

    @NotNull
    public <U> CollectionLike<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> var1);

    @Contract(pure=true)
    @NotNull
    public <U> CollectionLike<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> var1);

    @NotNull
    public <U> @NotNull CollectionLike<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> var1);

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(@NotNull MutableArray<? super E> dest) {
        return this.copyToArray(0, dest.getArray(), 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(@NotNull MutableArray<? super E> dest, int destPos) {
        return this.copyToArray(0, dest.getArray(), destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(@NotNull MutableArray<? super E> dest, int destPos, int limit) {
        return this.copyToArray(0, dest.getArray(), destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, @NotNull MutableArray<? super E> dest) {
        return this.copyToArray(srcPos, dest.getArray(), 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, @NotNull MutableArray<? super E> dest, int destPos) {
        return this.copyToArray(srcPos, dest.getArray(), destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, @NotNull MutableArray<? super E> dest, int destPos, int limit) {
        return this.copyToArray(srcPos, dest.getArray(), destPos, limit);
    }

    @NotNull
    default public Seq<E> toSeq() {
        return this.toImmutableSeq();
    }

    @NotNull
    default public ImmutableSeq<E> toImmutableSeq() {
        return this.toImmutableVector();
    }

    @NotNull
    default public ImmutableArray<E> toImmutableArray() {
        return ImmutableArray.Unsafe.wrap(this.toArray());
    }

    @NotNull
    default public ImmutableLinkedSeq<E> toImmutableLinkedSeq() {
        return ImmutableLinkedSeq.from(this);
    }

    @NotNull
    default public ImmutableVector<E> toImmutableVector() {
        return ImmutableVector.from(this);
    }

    @NotNull
    default public <K, V> ImmutableMap<K, V> toImmutableMap() {
        int ks = this.knownSize();
        if (ks == 0) {
            return ImmutableMap.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return ImmutableMap.empty();
        }
        MapFactory factory = ImmutableMap.factory();
        Object builder = factory.newBuilder();
        if (ks > 0) {
            factory.sizeHint(builder, ks);
        }
        while (it.hasNext()) {
            Map.Entry v = (Map.Entry)it.next();
            factory.addToBuilder(builder, v.getKey(), v.getValue());
        }
        return (ImmutableMap)factory.build(builder);
    }

    @NotNull
    default public <K, V> Map<K, V> associate(@NotNull Function<? super E, ? extends Map.Entry<? extends K, ? extends V>> transform) {
        int ks = this.knownSize();
        if (ks == 0) {
            return Map.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return Map.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        if (ks > 0) {
            factory.sizeHint(builder, ks);
        }
        while (it.hasNext()) {
            Map.Entry<K, V> v = transform.apply(it.next());
            factory.addToBuilder(builder, v.getKey(), v.getValue());
        }
        return (Map)factory.build(builder);
    }

    @NotNull
    default public <K> Map<K, E> associateBy(@NotNull Function<? super E, ? extends K> keySelector) {
        int ks = this.knownSize();
        if (ks == 0) {
            return Map.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return Map.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        if (ks > 0) {
            factory.sizeHint(builder, ks);
        }
        while (it.hasNext()) {
            Object e = it.next();
            factory.addToBuilder(builder, keySelector.apply(e), e);
        }
        return (Map)factory.build(builder);
    }

    @NotNull
    default public <K, V> Map<K, V> associateBy(@NotNull Function<? super E, ? extends K> keySelector, @NotNull Function<? super E, ? extends V> valueTransform) {
        int ks = this.knownSize();
        if (ks == 0) {
            return Map.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return Map.empty();
        }
        MapFactory factory = Map.factory();
        Object builder = factory.newBuilder();
        if (ks > 0) {
            factory.sizeHint(builder, ks);
        }
        while (it.hasNext()) {
            Object e = it.next();
            factory.addToBuilder(builder, keySelector.apply(e), valueTransform.apply(e));
        }
        return (Map)factory.build(builder);
    }
}

