/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.Conditions;
import kala.collection.AnySeqLike;
import kala.collection.CollectionLike;
import kala.collection.SeqIterator;
import kala.collection.SeqView;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.internal.SeqIterators;
import kala.collection.internal.view.SeqViews;
import kala.collection.mutable.MutableArrayList;
import kala.control.Option;
import kala.function.CheckedIndexedConsumer;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedBiFunction;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import kala.tuple.Tuple2;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface SeqLike<E>
extends CollectionLike<E>,
AnySeqLike<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> SeqLike<E> narrow(SeqLike<? extends E> view) {
        return view;
    }

    @Override
    @NotNull
    default public String className() {
        return "SeqLike";
    }

    @NotNull
    default public Iterator<E> iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return Iterators.empty();
            }
        }
        Iterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.next();
        }
        return it;
    }

    @NotNull
    default public SeqIterator<E> seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public SeqIterator<E> seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new SeqIterators.DefaultSeqIterator(this, index);
    }

    @Override
    @NotNull
    public SeqView<E> view();

    @NotNull
    default public SeqView<E> sliceView(int beginIndex, int endIndex) {
        return this.view().slice(beginIndex, endIndex);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public E elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public E get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        Iterator<E> it = this.iterator(index);
        if (!it.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        return it.next();
    }

    @Contract(pure=true)
    @Nullable
    default public E getOrNull(int index) {
        return this.isDefinedAt(index) ? (E)this.get(index) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public Option<E> getOption(int index) {
        return this.isDefinedAt(index) ? Option.some(this.get(index)) : Option.none();
    }

    @NotNull
    default public Iterator<E> reverseIterator() {
        MutableArrayList buffer;
        int ks = this.knownSize();
        if (ks == 0) {
            return Iterators.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableArrayList mutableArrayList = buffer = ks > 0 ? new MutableArrayList(ks) : new MutableArrayList();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        Iterator res = GenericArrays.reverseIterator((Object[])buffer.toArray());
        return res;
    }

    @NotNull
    default public Option<E> find(@NotNull Predicate<? super E> predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public Option<E> findFirst(@NotNull Predicate<? super E> predicate) {
        return Iterators.firstOption((Iterator)this.iterator(), predicate);
    }

    @NotNull
    default public Option<E> findLast(@NotNull Predicate<? super E> predicate) {
        return Iterators.firstOption(this.reverseIterator(), predicate);
    }

    default public E first() {
        return this.iterator().next();
    }

    @Nullable
    default public E firstOrNull() {
        return this.isNotEmpty() ? (E)this.first() : null;
    }

    @NotNull
    default public Option<E> firstOption() {
        return this.isNotEmpty() ? Option.some(this.first()) : Option.none();
    }

    default public E last() {
        return this.reverseIterator().next();
    }

    @Nullable
    default public E lastOrNull() {
        return this.isNotEmpty() ? (E)this.last() : null;
    }

    @NotNull
    default public Option<E> lastOption() {
        return this.isNotEmpty() ? Option.some(this.last()) : Option.none();
    }

    default public E first(@NotNull Predicate<? super E> predicate) {
        return (E)this.findFirst(predicate).get();
    }

    @Nullable
    default public E firstOrNull(@NotNull Predicate<? super E> predicate) {
        return (E)this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public Option<E> firstOption(@NotNull Predicate<? super E> predicate) {
        return this.findFirst(predicate);
    }

    default public E last(@NotNull Predicate<? super E> predicate) {
        return (E)this.findLast(predicate).get();
    }

    @Nullable
    default public E lastOrNull(@NotNull Predicate<? super E> predicate) {
        return (E)this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public Option<E> lastOption(@NotNull Predicate<? super E> predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(Object value) {
        int idx = 0;
        if (value == null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (null == e) {
                    return idx;
                }
                ++idx;
            }
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (value.equals(e)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(Object value, int from) {
        int idx = 0;
        if (value == null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (idx >= from && null == e) {
                    return idx;
                }
                ++idx;
            }
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (idx >= from && value.equals(e)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull Predicate<? super E> predicate) {
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull Predicate<? super E> predicate, int from) {
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (idx >= from && predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(Object value) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        if (value == null) {
            while (it.hasNext()) {
                if (null == it.next()) {
                    return idx;
                }
                --idx;
            }
        } else {
            while (it.hasNext()) {
                if (value.equals(it.next())) {
                    return idx;
                }
                --idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(Object value, int end) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        if (value == null) {
            while (it.hasNext()) {
                if (idx <= end && null == it.next()) {
                    return idx;
                }
                --idx;
            }
        } else {
            while (it.hasNext()) {
                if (idx <= end && value.equals(it.next())) {
                    return idx;
                }
                --idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.next())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull Predicate<? super E> predicate, int end) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.next())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> drop(int var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> dropWhile(@NotNull Predicate<? super E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> take(int var1);

    @NotNull
    public SeqLike<E> takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> takeWhile(@NotNull Predicate<? super E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> updated(int var1, E var2);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> concat(@NotNull SeqLike<? extends E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> concat(@NotNull List<? extends E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> prepended(E var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> prependedAll(E @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> prependedAll(@NotNull Iterable<? extends E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> appended(E var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> appendedAll(@NotNull Iterable<? extends E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> appendedAll(E @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> sorted();

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> sorted(Comparator<? super E> var1);

    @Contract(pure=true)
    @NotNull
    public SeqLike<E> reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public SeqLike<E> filter(@NotNull Predicate<? super E> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public SeqLike<E> filterNot(@NotNull Predicate<? super E> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull SeqLike<@NotNull E> filterNotNull();

    @Override
    @Contract(pure=true)
    @NotNull
    public <U> @NotNull SeqLike<@NotNull U> filterIsInstance(@NotNull Class<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> map(@NotNull Function<? super E, ? extends U> var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public <U> @NotNull SeqLike<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> var1);

    @Contract(pure=true)
    @NotNull
    public <U> @NotNull SeqLike<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> var1);

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapIndexedTo(@NotNull G destination, @NotNull IndexedFunction<? super E, ? extends U> mapper) {
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            destination.plusAssign(mapper.apply(idx++, e));
        }
        return destination;
    }

    @NotNull
    default public <U> @NotNull SeqView<@NotNull Tuple2<E, U>> zipView(@NotNull SeqLike<? extends U> other) {
        return new SeqViews.Zip(this, other);
    }

    default public E foldIndexed(E zero, @NotNull IndexedBiFunction<? super E, ? super E, ? extends E> op) {
        return this.foldLeftIndexed(zero, op);
    }

    default public <U> U foldLeftIndexed(U zero, @NotNull IndexedBiFunction<? super U, ? super E, ? extends U> op) {
        return (U)Iterators.foldLeftIndexed((Iterator)this.iterator(), zero, op);
    }

    default public <U> U foldRightIndexed(U zero, @NotNull IndexedBiFunction<? super E, ? super U, ? extends U> op) {
        return (U)Iterators.foldRightIndexed((Iterator)this.iterator(), zero, op);
    }

    default public E reduceRight(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        Iterator<E> it = this.reverseIterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = it.next();
        while (it.hasNext()) {
            e = op.apply(it.next(), e);
        }
        return e;
    }

    default public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            action.accept(idx++, e);
        }
    }

    default public <Ex extends Throwable> void forEachIndexedChecked(@NotNull CheckedIndexedConsumer<? super E, ? extends Ex> action) throws Ex {
        this.forEachIndexed((IndexedConsumer<? super E>)action);
    }

    default public void forEachIndexedUnchecked(@NotNull CheckedIndexedConsumer<? super E, ?> action) {
        this.forEachIndexed((IndexedConsumer<? super E>)action);
    }
}

