/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.collection.Collection;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableCollection;
import kala.collection.immutable.ImmutableAnyCollection;
import kala.collection.immutable.ImmutableSeq;
import kala.function.Predicates;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ImmutableCollection<E>
extends Collection<E>,
ImmutableAnyCollection<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableCollection<E> narrow(ImmutableCollection<? extends E> collection) {
        return collection;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableCollection<E>> factory() {
        return CollectionFactory.narrow(ImmutableSeq.factory());
    }

    @NotNull
    public static <E> ImmutableCollection<E> of() {
        return ImmutableSeq.of();
    }

    @NotNull
    public static <E> ImmutableCollection<E> of(E value1) {
        return ImmutableSeq.of(value1);
    }

    @NotNull
    public static <E> ImmutableCollection<E> of(E value1, E value2) {
        return ImmutableSeq.of(value1, value2);
    }

    @NotNull
    public static <E> ImmutableCollection<E> of(E value1, E value2, E value3) {
        return ImmutableSeq.of(value1, value2, value3);
    }

    @NotNull
    public static <E> ImmutableCollection<E> of(E value1, E value2, E value3, E value4) {
        return ImmutableSeq.of(value1, value2, value3, value4);
    }

    @NotNull
    public static <E> ImmutableCollection<E> of(E value1, E value2, E value3, E value4, E value5) {
        return ImmutableSeq.of(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> ImmutableCollection<E> of(E ... values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> ImmutableCollection<E> from(E @NotNull [] values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> ImmutableCollection<E> from(@NotNull Iterable<? extends E> values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> ImmutableCollection<E> from(@NotNull Iterator<? extends E> it) {
        return ImmutableSeq.from(it);
    }

    @NotNull
    public static <E> ImmutableCollection<E> from(@NotNull Stream<? extends E> stream) {
        return ImmutableSeq.from(stream);
    }

    @NotNull
    public static <E> ImmutableCollection<E> fill(int n, E value) {
        return ImmutableSeq.fill(n, value);
    }

    @NotNull
    public static <E> ImmutableCollection<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        return ImmutableSeq.fill(n, supplier);
    }

    @NotNull
    public static <E> ImmutableCollection<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        return ImmutableSeq.fill(n, init);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableCollection";
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends ImmutableCollection<U>> iterableFactory() {
        return ImmutableCollection.factory();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableCollection<E> filter(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filter(this, predicate, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableCollection<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filterNot(this, predicate, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public @NotNull ImmutableCollection<@NotNull E> filterNotNull() {
        return this.filter(Predicates.isNotNull());
    }

    @Override
    @NotNull
    default public <U> ImmutableCollection<U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(clazz::isInstance);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        return AbstractImmutableCollection.map(this, mapper, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> @NotNull ImmutableCollection<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        return AbstractImmutableCollection.mapNotNull(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> ImmutableCollection<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        return AbstractImmutableCollection.mapMulti(this, mapper, this.iterableFactory());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        return AbstractImmutableCollection.flatMap(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> @NotNull ImmutableCollection<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> other) {
        return AbstractImmutableCollection.zip(this, other, this.iterableFactory());
    }
}

