/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.AbstractSeqIterator;
import kala.collection.SeqIterator;
import kala.collection.SeqLike;
import kala.collection.base.AbstractIterator;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableListIterator;
import kala.collection.mutable.MutableSeq;
import kala.collection.mutable.MutableSeqIterator;
import org.jetbrains.annotations.NotNull;

public final class SeqIterators {
    public static final SeqIterator<?> EMPTY = new EmptySeqIterator();
    public static final MutableSeqIterator<?> EMPTY_MUTABLE = new EmptyMutableSeqIterator();

    private SeqIterators() {
    }

    private static class EmptySeqIterator<E>
    extends AbstractIterator<E>
    implements SeqIterator<E> {
        private EmptySeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableSeqIterator<E>
    extends EmptySeqIterator<E>
    implements MutableSeqIterator<E> {
        private EmptyMutableSeqIterator() {
        }

        @Override
        public void set(E e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenSeqIterator<E>
    implements SeqIterator<E> {
        @NotNull
        private final SeqIterator<E> source;

        public FrozenSeqIterator(@NotNull SeqIterator<E> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public E next() {
            return this.source.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public E previous() {
            return this.source.previous();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenSeqIterator[" + this.source + ']';
        }
    }

    public static class DefaultMutableListIterator<E, S extends MutableList<E>>
    extends DefaultMutableSeqIterator<E, S>
    implements MutableListIterator<E> {
        public DefaultMutableListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(E e) {
            try {
                int i = this.cursor;
                ((MutableList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableSeqIterator<E, S extends MutableSeq<E>>
    extends DefaultSeqIterator<E, S>
    implements MutableSeqIterator<E> {
        public DefaultMutableSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultSeqIterator<E, S extends SeqLike<E>>
    extends AbstractSeqIterator<E> {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                Object next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public E previous() {
            try {
                int i = this.cursor - 1;
                Object previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

