/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.tree;

import java.util.Comparator;
import kala.internal.ComparableUtils;

public class AVLTree<K, N extends Node<K, N>> {
    protected int size;
    protected N root;
    protected final Comparator<? super K> comparator;

    protected AVLTree(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    protected int leftHeight(N node) {
        return ((Node)node).left != null ? ((Node)((Node)node).left).height : 0;
    }

    protected int rightHeight(N node) {
        return ((Node)node).right != null ? ((Node)((Node)node).right).height : 0;
    }

    protected N firstNode() {
        N node = this.root;
        if (node == null) {
            return null;
        }
        while (((Node)node).left != null) {
            node = ((Node)node).left;
        }
        return node;
    }

    protected N lastNode() {
        N node = this.root;
        if (node == null) {
            return null;
        }
        while (((Node)node).right != null) {
            node = ((Node)node).right;
        }
        return node;
    }

    protected N nextNode(N node) {
        if (node == null) {
            return null;
        }
        if (((Node)node).right != null) {
            node = ((Node)node).right;
            while (((Node)node).left != null) {
                node = ((Node)node).left;
            }
        } else {
            N n;
            do {
                n = node;
            } while ((node = ((Node)node).parent) != null && ((Node)node).left != n);
        }
        return node;
    }

    protected N prevNode(N node) {
        if (node == null) {
            return null;
        }
        if (((Node)node).left != null) {
            node = ((Node)node).left;
            while (((Node)node).right != null) {
                node = ((Node)node).right;
            }
        } else {
            N n;
            do {
                n = node;
            } while ((node = ((Node)node).parent) != null && ((Node)node).right != n);
        }
        return node;
    }

    private void nodeChildReplace(N oldNode, N newNode, N parent) {
        if (parent != null) {
            if (((Node)parent).left == oldNode) {
                ((Node)parent).left = newNode;
            } else {
                ((Node)parent).right = newNode;
            }
        } else {
            this.root = newNode;
        }
    }

    protected N findNode(K key) {
        N node = this.root;
        if (this.comparator == null) {
            while (node != null) {
                int c = ComparableUtils.compare(key, ((Node)node).key);
                if (c == 0) {
                    return node;
                }
                if (c < 0) {
                    node = ((Node)node).left;
                    continue;
                }
                node = ((Node)node).right;
            }
        } else {
            while (node != null) {
                int c = this.comparator.compare(key, ((Node)node).key);
                if (c == 0) {
                    return node;
                }
                if (c < 0) {
                    node = ((Node)node).left;
                    continue;
                }
                node = ((Node)node).right;
            }
        }
        return null;
    }

    protected void linkNode(N node, N parent) {
    }

    public static class Node<K, N extends Node<K, N>> {
        K key;
        int height;
        N left;
        N right;
        N parent;
    }
}

