/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.tree;

import java.util.Objects;
import java.util.function.Consumer;
import kala.function.IndexedConsumer;
import kala.internal.ComparableUtils;
import kala.value.primitive.IntRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TwoThreeTree<E> {
    private Node<E> root;
    private int len = 0;

    private int compare(E e0, E e1) {
        return ComparableUtils.compare(e0, e1);
    }

    public int size() {
        return this.len;
    }

    @Nullable
    private Node<E> search(E value) {
        Node<E> node = this.root;
        while (node != null) {
            int c = this.compare(value, node.value1);
            if (c == 0) {
                return node;
            }
            if (c < 0) {
                node = node.left;
                continue;
            }
            if (node.isTwoNode()) {
                node = node.right;
                continue;
            }
            c = this.compare(value, node.value2);
            if (c == 0) {
                return node;
            }
            if (c < 0) {
                node = node.middle;
                continue;
            }
            node = node.right;
        }
        return null;
    }

    public boolean contains(Object value) {
        if (value == null) {
            return false;
        }
        Object e = value;
        return this.search(e) != null;
    }

    public boolean add(@NotNull E value) {
        int tag;
        Objects.requireNonNull(value);
        if (this.root == null) {
            this.root = new Node<E>(value);
            this.len = 1;
            return true;
        }
        Node<E> node = this.root;
        while (true) {
            int c;
            if ((c = this.compare(value, node.value1)) == 0) {
                return false;
            }
            if (c < 0) {
                if (node.isLeaf()) {
                    tag = 0;
                    break;
                }
                node = node.left;
                continue;
            }
            if (node.isTwoNode()) {
                if (node.isLeaf()) {
                    tag = 1;
                    break;
                }
                node = node.right;
                continue;
            }
            c = this.compare(value, node.value2);
            if (c == 0) {
                return false;
            }
            if (c < 0) {
                if (node.isLeaf()) {
                    tag = 1;
                    break;
                }
                node = node.middle;
                continue;
            }
            if (node.isLeaf()) {
                tag = 2;
                break;
            }
            node = node.right;
        }
        if (node.isTwoNode()) {
            if (tag == 0) {
                node.value2 = node.value1;
                node.value1 = value;
            } else {
                node.value2 = value;
            }
        } else {
            Object v2;
            Object v1;
            E v0;
            if (tag == 0) {
                v0 = value;
                v1 = node.value1;
                v2 = node.value2;
            } else if (tag == 1) {
                v0 = node.value1;
                v1 = value;
                v2 = node.value2;
            } else {
                v0 = node.value1;
                v1 = node.value2;
                v2 = value;
            }
            Node newNode = new Node(v2);
            Object pv = v1;
            node.value1 = v0;
            node.value2 = null;
            while (true) {
                Node nn;
                Object pp;
                if (node.parent == null) {
                    Node newRoot = new Node(pv);
                    newRoot.left = node;
                    newRoot.right = newNode;
                    node.parent = newRoot;
                    newNode.parent = newRoot;
                    this.root = newRoot;
                    break;
                }
                if (node.parent.isTwoNode()) {
                    if (this.compare(pv, node.parent.value1) < 0) {
                        node.parent.value2 = node.parent.value1;
                        node.parent.value1 = pv;
                    } else {
                        node.parent.value2 = pv;
                    }
                    if (node.parent.left == node) {
                        node.parent.middle = newNode;
                    } else {
                        node.parent.middle = node;
                        node.parent.right = newNode;
                    }
                    newNode.parent = node.parent;
                    break;
                }
                if (this.compare(pv, node.parent.value1) < 0) {
                    pp = node.parent.value1;
                    node.parent.value1 = pv;
                    nn = new Node(node.parent.value2);
                } else if (this.compare(pv, node.parent.value2) < 0) {
                    pp = pv;
                    nn = new Node(node.parent.value2);
                } else {
                    pp = node.parent.value2;
                    nn = new Node(pv);
                }
                node.parent.value2 = null;
                if (node.parent.left == node) {
                    nn.left = node.parent.middle;
                    node.parent.middle.parent = nn;
                    nn.right = node.parent.right;
                    node.parent.right.parent = nn;
                    node.parent.right = newNode;
                    newNode.parent = node.parent;
                } else if (node.parent.middle == node) {
                    nn.left = newNode;
                    newNode.parent = nn;
                    nn.right = node.parent.right;
                    node.parent.right.parent = nn;
                    node.parent.right = node.parent.middle;
                } else {
                    Node tmp = node.parent.right = node.parent.middle;
                    nn.left = node;
                    node.parent = nn;
                    nn.right = newNode;
                    newNode.parent = nn;
                    node = tmp;
                }
                node.parent.middle = null;
                node = node.parent;
                pv = pp;
                newNode = nn;
            }
        }
        ++this.len;
        return true;
    }

    public Object[] toArray() {
        Object[] res = new Object[this.len];
        IntRef i = new IntRef();
        this.forEach(v -> {
            res[i.value++] = v;
        });
        return res;
    }

    public void forEach(@NotNull Consumer<? super E> action) {
        TwoThreeTree.forEach(this.root, action);
    }

    private static <E> void forEach(Node<E> node, Consumer<? super E> action) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            action.accept(node.value1);
            if (node.isThreeNode()) {
                action.accept(node.value2);
            }
            return;
        }
        TwoThreeTree.forEach(node.left, action);
        action.accept(node.value1);
        if (node.isThreeNode()) {
            TwoThreeTree.forEach(node.middle, action);
            action.accept(node.value2);
        }
        TwoThreeTree.forEach(node.right, action);
    }

    public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
        TwoThreeTree.forEachIndexed(this.root, action, 0);
    }

    private static <E> int forEachIndexed(Node<E> node, IndexedConsumer<? super E> action, int currentIndex) {
        if (node == null) {
            return 0;
        }
        if (node.isLeaf()) {
            if (node.isTwoNode()) {
                action.accept(currentIndex, node.value1);
                return 1;
            }
            action.accept(currentIndex, node.value1);
            action.accept(currentIndex + 1, node.value2);
            return 2;
        }
        int n = 0;
        n += TwoThreeTree.forEachIndexed(node.left, action, currentIndex + n);
        action.accept(currentIndex + n++, node.value1);
        if (node.isThreeNode()) {
            n += TwoThreeTree.forEachIndexed(node.middle, action, currentIndex + n);
            action.accept(currentIndex + n++, node.value2);
        }
        return n += TwoThreeTree.forEachIndexed(node.right, action, currentIndex);
    }

    public void print() {
        System.out.println("root=" + this.root);
        this.forEach(System.out::println);
    }

    private static class Node<E> {
        E value1;
        E value2;
        Node<E> left;
        Node<E> middle;
        Node<E> right;
        Node<E> parent;

        Node() {
        }

        Node(E value1) {
            this.value1 = value1;
        }

        boolean isLeaf() {
            return this.left == null;
        }

        boolean isTwoNode() {
            return this.value2 == null;
        }

        boolean isThreeNode() {
            return this.value2 != null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Node[");
            if (this.isTwoNode()) {
                builder.append("value1=").append(this.value1);
            } else {
                builder.append("value1=").append(this.value1).append(", value2=").append(this.value2);
            }
            if (!this.isLeaf()) {
                builder.append(", ");
                if (this.isTwoNode()) {
                    builder.append("left=").append(this.left).append(", right=").append(this.right);
                } else {
                    builder.append("left=").append(this.left).append(", middle").append(this.middle).append(", right=").append(this.right);
                }
            }
            builder.append(']');
            return builder.toString();
        }
    }
}

