/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.IndexedSeq;
import kala.collection.base.Iterators;
import kala.collection.base.ObjectArrays;
import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.AbstractMutableList;
import kala.collection.mutable.AbstractMutableListFactory;
import kala.collection.mutable.MutableDeque;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableArrayDeque<E>
extends AbstractMutableList<E>
implements MutableDeque<E>,
IndexedSeq<E>,
Serializable {
    private static final long serialVersionUID = -4166302067142375121L;
    private static final Factory<?> FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 16;
    Object[] elements;
    int begin = -1;
    int end = 0;

    private MutableArrayDeque(Object[] elements, int begin, int end) {
        this.elements = elements;
        this.begin = begin;
        this.end = end;
    }

    public MutableArrayDeque() {
        this.elements = ObjectArrays.EMPTY;
    }

    public MutableArrayDeque(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? ObjectArrays.EMPTY : new Object[initialCapacity];
    }

    private static int inc(int i, int capacity) {
        return i + 1 >= capacity ? 0 : i + 1;
    }

    private static int inc(int i, int distance, int capacity) {
        if ((i += distance) - capacity >= 0) {
            i -= capacity;
        }
        return i;
    }

    private static int dec(int i, int capacity) {
        return i - 1 < 0 ? capacity - 1 : i - 1;
    }

    private static int sub(int i, int distance, int capacity) {
        if ((i -= distance) < 0) {
            i += capacity;
        }
        return i;
    }

    private void grow() {
        this.grow(this.elements.length + 1);
    }

    private void grow(int minCapacity) {
        Object[] newElements;
        int oldCapacity = this.elements.length;
        int size = this.size();
        int newCapacity = this.newCapacity(oldCapacity, minCapacity);
        if (size == 0) {
            newElements = new Object[newCapacity];
        } else if (this.begin < this.end) {
            newElements = Arrays.copyOf(this.elements, newCapacity);
        } else {
            newElements = new Object[newCapacity];
            System.arraycopy(this.elements, this.begin, newElements, 0, this.elements.length - this.begin);
            System.arraycopy(this.elements, 0, newElements, this.elements.length - this.begin, this.end);
            this.begin = 0;
            this.end = size;
        }
        this.elements = newElements;
    }

    private int newCapacity(int oldCapacity, int minCapacity) {
        return oldCapacity == 0 ? Integer.max(16, minCapacity) : Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableArrayDeque<E>> factory() {
        return FACTORY;
    }

    public static <E> MutableArrayDeque<E> create() {
        return new MutableArrayDeque<E>();
    }

    public static <E> MutableArrayDeque<E> create(int initialCapacity) {
        return new MutableArrayDeque<E>(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of() {
        return new MutableArrayDeque<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of(E value1) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        return new MutableArrayDeque<E>(arr, 0, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of(E value1, E value2) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableArrayDeque<E>(arr, 0, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of(E value1, E value2, E value3) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableArrayDeque<E>(arr, 0, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of(E value1, E value2, E value3, E value4) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableArrayDeque<E>(arr, 0, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of(E value1, E value2, E value3, E value4, E value5) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableArrayDeque<E>(arr, 0, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> of(E ... values) {
        return MutableArrayDeque.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayDeque<E> from(E @NotNull [] values) {
        int length = values.length;
        if (length == 0) {
            return new MutableArrayDeque<E>();
        }
        Object[] newValues = Arrays.copyOf(values, length, Object[].class);
        return new MutableArrayDeque<E>(newValues, 0, length);
    }

    @NotNull
    public static <E> MutableArrayDeque<E> from(@NotNull Iterable<? extends E> values) {
        MutableArrayDeque<E> buffer = new MutableArrayDeque<E>();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static <E> MutableArrayDeque<E> from(@NotNull Iterator<? extends E> it) {
        MutableArrayDeque<E> buffer = new MutableArrayDeque<E>();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer;
    }

    @NotNull
    public static <E> MutableArrayDeque<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableArrayDeque.factory());
    }

    @NotNull
    public static <E> MutableArrayDeque<E> fill(int n, E value) {
        if (n <= 0) {
            return new MutableArrayDeque<E>();
        }
        Object[] arr = new Object[Integer.max(16, n)];
        if (value != null) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableArrayDeque<E>(arr, 0, n);
    }

    @NotNull
    public static <E> MutableArrayDeque<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return new MutableArrayDeque<E>();
        }
        Object[] arr = new Object[Integer.max(16, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.get();
        }
        return new MutableArrayDeque<E>(arr, 0, n);
    }

    @NotNull
    public static <E> MutableArrayDeque<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return new MutableArrayDeque<E>();
        }
        Object[] arr = new Object[Integer.max(16, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = init.apply(i);
        }
        return new MutableArrayDeque<E>(arr, 0, n);
    }

    @Override
    @NotNull
    public String className() {
        return "MutableArrayDeque";
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        if (this.isEmpty()) {
            return Iterators.empty();
        }
        if (this.begin < this.end) {
            return ObjectArrays.iterator((Object[])this.elements, (int)this.begin, (int)this.end);
        }
        return Iterators.concat((Iterator)ObjectArrays.iterator((Object[])this.elements, (int)this.begin, (int)this.elements.length), (Iterator)ObjectArrays.iterator((Object[])this.elements, (int)0, (int)this.end));
    }

    @Override
    public boolean isEmpty() {
        return this.begin == -1;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.begin < this.end) {
            return this.end - this.begin;
        }
        return this.elements.length - this.begin + this.end;
    }

    @Override
    public E get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (this.begin < this.end) {
            Conditions.checkElementIndex((int)index, (int)(this.end - this.begin));
            return (E)this.elements[this.begin + index];
        }
        Conditions.checkElementIndex((int)index, (int)(this.elements.length - this.begin + this.end));
        return (E)this.elements[MutableArrayDeque.inc(this.begin, index, this.elements.length)];
    }

    @Override
    public void set(int index, E newValue) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.begin < this.end) {
            Conditions.checkElementIndex((int)index, (int)(this.end - this.begin));
            this.elements[this.begin + index] = newValue;
        } else {
            int size = this.elements.length - this.begin + this.end;
            Conditions.checkElementIndex((int)index, (int)size);
            this.elements[MutableArrayDeque.inc((int)this.begin, (int)index, (int)this.elements.length)] = newValue;
        }
    }

    @Override
    public void insert(int index, E value) {
        int oldSize = this.size();
        Conditions.checkPositionIndex((int)index, (int)oldSize);
        if (oldSize == this.elements.length) {
            this.grow();
        }
        if (oldSize == 0) {
            this.elements[0] = value;
            this.begin = 0;
            this.end = 1;
        } else if (this.begin < this.end) {
            int targetIndex = this.begin + index;
            if (this.end < this.elements.length) {
                System.arraycopy(this.elements, targetIndex, this.elements, targetIndex + 1, this.end - targetIndex);
                ++this.end;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin - 1, targetIndex - this.begin + 1);
                --this.begin;
            }
            this.elements[targetIndex] = value;
        } else {
            int targetIndex = MutableArrayDeque.inc(this.begin, index, this.elements.length);
            if (targetIndex <= this.end) {
                System.arraycopy(this.elements, targetIndex, this.elements, targetIndex + 1, this.end - targetIndex);
                this.elements[targetIndex] = value;
                ++this.end;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin - 1, targetIndex - this.begin);
                this.elements[targetIndex - 1] = value;
                --this.begin;
            }
        }
    }

    @Override
    public void insertAll(int index, E @NotNull [] values) {
        int oldSize = this.size();
        Conditions.checkPositionIndex((int)index, (int)oldSize);
        int valuesLength = values.length;
        if (valuesLength == 0) {
            return;
        }
        int newSize = oldSize + valuesLength;
        if (newSize < 0) {
            throw new OutOfMemoryError();
        }
        if (newSize > this.elements.length) {
            this.grow(newSize);
        }
        if (oldSize == 0) {
            System.arraycopy(values, 0, this.elements, 0, valuesLength);
            this.begin = 0;
            this.end = valuesLength;
        } else if (this.begin < this.end) {
            if (newSize <= this.elements.length - this.begin) {
                System.arraycopy(this.elements, this.begin + index, this.elements, this.begin + index + valuesLength, valuesLength);
                System.arraycopy(values, 0, this.elements, this.begin + index, valuesLength);
                this.end = this.begin + newSize;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, 0, index);
                System.arraycopy(this.elements, this.begin + index, this.elements, this.begin + index + valuesLength, oldSize - index);
                System.arraycopy(values, 0, this.elements, index, valuesLength);
                this.begin = 0;
                this.end = newSize;
            }
        } else {
            int targetIndex = MutableArrayDeque.inc(this.begin, index, this.elements.length);
            if (targetIndex <= this.end) {
                System.arraycopy(this.elements, targetIndex, this.elements, targetIndex + valuesLength, this.end - targetIndex);
                System.arraycopy(values, 0, this.elements, targetIndex, valuesLength);
                this.end += valuesLength;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin - valuesLength, targetIndex - this.begin);
                System.arraycopy(values, 0, this.elements, targetIndex - valuesLength, valuesLength);
                this.begin -= valuesLength;
            }
        }
    }

    @Override
    public E removeAt(int index) {
        Object res;
        int oldSize = this.size();
        Conditions.checkElementIndex((int)index, (int)oldSize);
        if (oldSize == 1) {
            res = this.elements[this.begin];
            this.elements[this.begin] = null;
            this.begin = -1;
            this.end = 0;
        } else if (this.begin < this.end) {
            int targetIndex = this.begin + index;
            res = this.elements[targetIndex];
            System.arraycopy(this.elements, targetIndex + 1, this.elements, targetIndex, this.end - targetIndex - 1);
            --this.end;
        } else {
            int targetIndex = MutableArrayDeque.inc(this.begin, index, this.elements.length);
            res = this.elements[targetIndex];
            if (targetIndex < this.end) {
                System.arraycopy(this.elements, targetIndex + 1, this.elements, targetIndex, this.end - targetIndex - 1);
                --this.end;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin + 1, targetIndex - this.begin);
                this.begin = MutableArrayDeque.inc(this.begin, this.elements.length);
            }
        }
        return (E)res;
    }

    @Override
    public void prepend(E value) {
        int oldSize = this.size();
        if (oldSize == this.elements.length) {
            this.grow();
        }
        this.begin = oldSize == 0 ? this.elements.length - 1 : MutableArrayDeque.dec(this.begin, this.elements.length);
        this.elements[this.begin] = value;
    }

    @Override
    public void prependAll(E @NotNull [] values) {
        int valuesLength = values.length;
        int oldSize = this.size();
        int newSize = oldSize + valuesLength;
        if (newSize < 0) {
            throw new OutOfMemoryError();
        }
        if (newSize > this.elements.length) {
            this.grow(newSize);
        }
        if (oldSize == 0) {
            System.arraycopy(values, 0, this.elements, 0, valuesLength);
            this.begin = 0;
            this.end = valuesLength;
        } else if (this.begin < this.end) {
            if (valuesLength <= this.begin) {
                System.arraycopy(values, 0, this.elements, this.begin - valuesLength, valuesLength);
                this.begin -= valuesLength;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, valuesLength, oldSize);
                System.arraycopy(values, 0, this.elements, 0, valuesLength);
                this.begin = 0;
                this.end = newSize;
            }
        } else {
            System.arraycopy(values, 0, this.elements, this.begin - valuesLength, valuesLength);
            this.begin -= valuesLength;
        }
    }

    @Override
    public void append(E value) {
        int oldSize = this.size();
        if (oldSize == this.elements.length) {
            this.grow();
        }
        this.elements[this.end] = value;
        this.end = MutableArrayDeque.inc(this.end, this.elements.length);
        if (oldSize == 0) {
            this.begin = 0;
        }
    }

    @Override
    public void appendAll(E @NotNull [] values) {
        int valuesLength = values.length;
        int oldSize = this.size();
        if (valuesLength == 0) {
            return;
        }
        int newSize = oldSize + valuesLength;
        if (newSize < 0) {
            throw new OutOfMemoryError();
        }
        if (newSize > this.elements.length) {
            this.grow(newSize);
        }
        if (oldSize == 0) {
            System.arraycopy(values, 0, this.elements, 0, valuesLength);
            this.begin = 0;
            this.end = valuesLength;
        } else if (this.begin < this.end) {
            if (newSize <= this.elements.length - this.begin) {
                System.arraycopy(values, 0, this.elements, this.end, valuesLength);
                this.end += valuesLength;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, 0, oldSize);
                System.arraycopy(values, 0, this.elements, oldSize, valuesLength);
                this.begin = 0;
                this.end = newSize;
            }
        } else {
            System.arraycopy(values, 0, this.elements, this.end, valuesLength);
            this.end += valuesLength;
        }
    }

    @Override
    public E removeFirst() {
        int oldSize = this.size();
        if (oldSize == 0) {
            throw new NoSuchElementException();
        }
        Object res = this.elements[this.begin];
        this.elements[this.begin] = null;
        if (oldSize == 1) {
            this.begin = -1;
            this.end = 0;
        } else {
            this.begin = MutableArrayDeque.inc(this.begin, this.elements.length);
        }
        return (E)res;
    }

    @Override
    @NotNull
    public E removeLast() {
        int oldSize = this.size();
        if (oldSize == 0) {
            throw new NoSuchElementException();
        }
        int lastIdx = MutableArrayDeque.dec(this.end, this.elements.length);
        Object res = this.elements[lastIdx];
        this.elements[lastIdx] = null;
        if (oldSize == 1) {
            this.begin = -1;
            this.end = 0;
        } else {
            this.end = lastIdx;
        }
        return (E)res;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        if (this.begin < this.end) {
            Arrays.fill(this.elements, this.begin, this.end, null);
        } else {
            Arrays.fill(this.elements, 0, this.end, null);
            Arrays.fill(this.elements, this.begin, this.elements.length, null);
        }
        this.begin = -1;
        this.end = 0;
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[this.begin];
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[MutableArrayDeque.dec(this.end, this.elements.length)];
    }

    private static final class Factory<E>
    extends AbstractMutableListFactory<E, MutableArrayDeque<E>> {
        private Factory() {
        }

        public MutableArrayDeque<E> newBuilder() {
            return new MutableArrayDeque();
        }
    }
}

