/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.AnyCollection;
import kala.collection.CollectionLike;
import kala.collection.CollectionView;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableCollection;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.view.CollectionViews;
import kala.function.CheckedFunction;
import kala.function.CheckedPredicate;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface Collection<E>
extends CollectionLike<E>,
AnyCollection<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> Collection<E> narrow(Collection<? extends E> collection) {
        return collection;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> CollectionFactory<E, ?, Collection<E>> factory() {
        return CollectionFactory.narrow(ImmutableCollection.factory());
    }

    @Override
    @NotNull
    default public String className() {
        return "Collection";
    }

    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends Collection<U>> iterableFactory() {
        return Collection.factory();
    }

    @Override
    @NotNull
    default public CollectionView<E> view() {
        return this.isEmpty() ? CollectionView.empty() : new CollectionViews.Of(this);
    }

    default public @NotNull @UnmodifiableView java.util.Collection<E> asJava() {
        return new AsJavaConvert.CollectionAsJava(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableCollection<E> filter(@NotNull Predicate<? super E> predicate) {
        return this.view().filter(predicate).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <Ex extends Throwable> ImmutableCollection<E> filterChecked(@NotNull CheckedPredicate<? super E, ? extends Ex> predicate) throws Ex {
        return this.filter((Predicate)predicate);
    }

    @Contract(pure=true)
    @NotNull
    default public ImmutableCollection<E> filterUnchecked(@NotNull CheckedPredicate<? super E, ?> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableCollection<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return this.view().filterNot(predicate).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <Ex extends Throwable> ImmutableCollection<E> filterNotChecked(@NotNull CheckedPredicate<? super E, ? extends Ex> predicate) throws Ex {
        return this.filterNot((Predicate)predicate);
    }

    @Contract(pure=true)
    @NotNull
    default public ImmutableCollection<E> filterNotUnchecked(@NotNull CheckedPredicate<? super E, ?> predicate) {
        return this.filterNot((Predicate)predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public @NotNull ImmutableCollection<@NotNull E> filterNotNull() {
        return this.view().filterNotNull().toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.view().filterIsInstance(clazz).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        return this.view().map(mapper).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <U, Ex extends Throwable> ImmutableCollection<U> mapChecked(@NotNull CheckedFunction<? super E, ? extends U, ? extends Ex> mapper) throws Ex {
        return this.map((Function)mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> mapUnchecked(@NotNull CheckedFunction<? super E, ? extends U, ?> mapper) {
        return this.map((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        return this.view().mapNotNull(mapper).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <U, Ex extends Throwable> ImmutableCollection<U> mapNotNullChecked(@NotNull CheckedFunction<? super E, ? extends U, ? extends Ex> mapper) throws Ex {
        return this.mapNotNull((Function)mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> mapNotNullUnchecked(@NotNull CheckedFunction<? super E, ? extends U, ?> mapper) {
        return this.mapNotNull((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        return this.view().mapMulti(mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        return this.view().flatMap(mapper).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <U, Ex extends Throwable> ImmutableCollection<U> flatMapChecked(@NotNull CheckedFunction<? super E, ? extends Iterable<? extends U>, ? extends Ex> mapper) throws Ex {
        return this.flatMap((Function)mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableCollection<U> flatMapUnchecked(@NotNull CheckedFunction<? super E, ? extends Iterable<? extends U>, ?> mapper) {
        return this.flatMap((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> @NotNull ImmutableCollection<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> other) {
        return this.view().zip(other).toImmutableSeq();
    }
}

