/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.AnyCollectionView;
import kala.collection.CollectionLike;
import kala.collection.internal.view.CollectionViews;
import kala.function.Predicates;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public interface CollectionView<E>
extends CollectionLike<E>,
AnyCollectionView<E> {
    @NotNull
    public static <E> CollectionView<E> empty() {
        return CollectionViews.Empty.INSTANCE;
    }

    @Override
    @NotNull
    default public String className() {
        return "CollectionView";
    }

    @Override
    @NotNull
    default public CollectionView<E> view() {
        return this;
    }

    @Override
    @NotNull
    default public CollectionView<E> filter(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new CollectionViews.Filter<E>(this, predicate);
    }

    @Override
    @NotNull
    default public CollectionView<E> filterNot(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new CollectionViews.FilterNot<E>(this, predicate);
    }

    @Override
    @NotNull
    default public @NotNull CollectionView<@NotNull E> filterNotNull() {
        return new CollectionViews.FilterNotNull(this);
    }

    @Override
    @NotNull
    default public <U> @NotNull CollectionView<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(Predicates.instanceOf(clazz));
    }

    @Override
    @NotNull
    default public <U> CollectionView<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new CollectionViews.Mapped<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> CollectionView<U> mapNotNull(@NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new CollectionViews.MapNotNull<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> CollectionView<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        Objects.requireNonNull(mapper);
        return new CollectionViews.MapMulti(this, mapper);
    }

    @Override
    @NotNull
    default public <U> CollectionView<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return new CollectionViews.FlatMapped(this, mapper);
    }

    @Override
    @NotNull
    default public <U> @NotNull CollectionView<@NotNull Tuple2<E, U>> zip(@NotNull Iterable<? extends U> other) {
        Objects.requireNonNull(other);
        return new CollectionViews.Zip(this, other);
    }
}

