/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kala.collection.AnySet;
import kala.collection.Collection;
import kala.collection.SetLike;
import kala.collection.SetView;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSet;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.internal.view.SetViews;
import org.jetbrains.annotations.NotNull;

public interface Set<E>
extends Collection<E>,
SetLike<E>,
AnySet<E> {
    public static <E> CollectionFactory<E, ?, Set<E>> factory() {
        return CollectionFactory.narrow(ImmutableSet.factory());
    }

    @NotNull
    public static <E> Set<E> wrapJava(@NotNull java.util.Set<E> source) {
        return new FromJavaConvert.SetFromJava<E>(source);
    }

    @NotNull
    public static <E> Set<E> empty() {
        return ImmutableSet.empty();
    }

    @NotNull
    public static <E> Set<E> of() {
        return ImmutableSet.of();
    }

    @NotNull
    public static <E> Set<E> of(E value1) {
        return ImmutableSet.of(value1);
    }

    @NotNull
    public static <E> Set<E> of(E value1, E value2) {
        return ImmutableSet.of(value1, value2);
    }

    @NotNull
    public static <E> Set<E> of(E value1, E value2, E value3) {
        return ImmutableSet.of(value1, value2, value3);
    }

    @NotNull
    public static <E> Set<E> of(E value1, E value2, E value3, E value4) {
        return ImmutableSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static <E> Set<E> of(E value1, E value2, E value3, E value4, E value5) {
        return ImmutableSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static <E> Set<E> of(E ... values) {
        return ImmutableSet.of(values);
    }

    @NotNull
    public static <E> Set<E> from(E @NotNull [] values) {
        return ImmutableSet.from(values);
    }

    @NotNull
    public static <E> Set<E> from(@NotNull Iterable<? extends E> values) {
        return ImmutableSet.from(values);
    }

    @NotNull
    public static <E> Set<E> from(@NotNull Iterator<? extends E> it) {
        return ImmutableSet.from(it);
    }

    @NotNull
    public static <E> Set<E> from(@NotNull Stream<? extends E> stream) {
        return ImmutableSet.from(stream);
    }

    public static int hashCode(@NotNull Set<?> set) {
        int h = 1045751549;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            h += e.hashCode();
        }
        return h;
    }

    public static boolean equals(@NotNull Set<?> set1, @NotNull AnySet<?> set2) {
        if (!set1.canEqual(set2) || !set2.canEqual(set1)) {
            return false;
        }
        return set1.size() == set2.size() && set1.containsAll((Iterable)set2.asGeneric());
    }

    default public boolean contains(Object value) {
        return Iterators.contains((Iterator)this.iterator(), (Object)value);
    }

    @Override
    @NotNull
    default public String className() {
        return "Set";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends Set<U>> iterableFactory() {
        return Set.factory();
    }

    @Override
    @NotNull
    default public SetView<E> view() {
        return new SetViews.Of(this);
    }

    @Override
    default public @NotNull java.util.Set<E> asJava() {
        return new AsJavaConvert.SetAsJava(this);
    }

    @Override
    @NotNull
    default public ImmutableSet<E> filter(@NotNull Predicate<? super E> predicate) {
        return ImmutableSet.from(this.view().filter((Predicate)predicate));
    }

    @Override
    @NotNull
    default public ImmutableSet<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return ImmutableSet.from(this.view().filterNot((Predicate)predicate));
    }
}

