/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.hash;

import kala.collection.internal.hash.ChampNode;

public abstract class ChampIteratorBase<N extends ChampNode<N>> {
    public static final int HashCodeLength = 32;
    public static final int BitPartitionSize = 5;
    public static final int BitPartitionMask = 31;
    public static final int MaxDepth = (int)Math.ceil(6.4);
    public static final int BranchingFactor = 32;
    protected int currentValueCursor;
    protected int currentValueLength;
    protected N currentValueNode;
    private int currentStackLevel = -1;
    private int[] nodeCursorsAndLengths;
    private N[] nodes;

    public ChampIteratorBase(N rootNode) {
        if (((ChampNode)rootNode).hasNodes()) {
            this.pushNode(rootNode);
        }
        if (((ChampNode)rootNode).hasPayload()) {
            this.setupPayloadNode(rootNode);
        }
    }

    private void initNodes() {
        if (this.nodeCursorsAndLengths == null) {
            this.nodeCursorsAndLengths = new int[MaxDepth * 2];
            this.nodes = new ChampNode[MaxDepth];
        }
    }

    private void setupPayloadNode(N node) {
        this.currentValueNode = node;
        this.currentValueCursor = 0;
        this.currentValueLength = ((ChampNode)node).payloadArity();
    }

    private void pushNode(N node) {
        this.initNodes();
        ++this.currentStackLevel;
        int cursorIndex = this.currentStackLevel * 2;
        int lengthIndex = this.currentStackLevel * 2 + 1;
        this.nodes[this.currentStackLevel] = node;
        this.nodeCursorsAndLengths[cursorIndex] = 0;
        this.nodeCursorsAndLengths[lengthIndex] = ((ChampNode)node).nodeArity();
    }

    private void popNode() {
        --this.currentStackLevel;
    }

    private boolean searchNextValueNode() {
        while (this.currentStackLevel >= 0) {
            int cursorIndex = this.currentStackLevel * 2;
            int nodeCursor = this.nodeCursorsAndLengths[cursorIndex];
            int lengthIndex = this.currentStackLevel * 2 + 1;
            int nodeLength = this.nodeCursorsAndLengths[lengthIndex];
            if (nodeCursor < nodeLength) {
                int n = cursorIndex;
                this.nodeCursorsAndLengths[n] = this.nodeCursorsAndLengths[n] + 1;
                Object nextNode = ((ChampNode)this.nodes[this.currentStackLevel]).getNode(nodeCursor);
                if (((ChampNode)nextNode).hasNodes()) {
                    this.pushNode(nextNode);
                }
                if (!((ChampNode)nextNode).hasPayload()) continue;
                this.setupPayloadNode(nextNode);
                return true;
            }
            this.popNode();
        }
        return false;
    }

    public final boolean hasNext() {
        return this.currentValueCursor < this.currentValueLength || this.searchNextValueNode();
    }
}

