/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.view;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.IndexedSeqLike;
import kala.collection.Seq;
import kala.collection.SeqIterator;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Iterators;
import kala.collection.internal.view.CollectionViews;
import kala.collection.mutable.MutableArrayList;
import kala.comparator.Comparators;
import kala.control.Option;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import kala.function.Predicates;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class SeqViews {

    public static class Zip<E, U>
    extends AbstractSeqView<Tuple2<E, U>> {
        @NotNull
        private final SeqLike<? extends E> source;
        @NotNull
        private final SeqLike<? extends U> other;

        public Zip(@NotNull SeqLike<? extends E> source, @NotNull SeqLike<? extends U> other) {
            this.source = source;
            this.other = other;
        }

        @NotNull
        public final Iterator<Tuple2<E, U>> iterator() {
            return Iterators.zip((Iterator)this.source.iterator(), (Iterator)this.other.iterator());
        }

        public final boolean isEmpty() {
            return this.source.isEmpty() || this.other.isEmpty();
        }

        public final int size() {
            int ss = this.source.size();
            return ss == 0 ? 0 : Integer.min(ss, this.other.size());
        }

        public int knownSize() {
            int ks1 = this.source.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            if (ks1 == 0) {
                return 0;
            }
            int ks2 = this.other.knownSize();
            return Integer.min(ks1, ks2);
        }

        @Override
        @NotNull
        public final Tuple2<E, U> get(int index) {
            return Tuple.of(this.source.get(index), this.other.get(index));
        }

        @Override
        @Nullable
        public Tuple2<E, U> getOrNull(int index) {
            return (Tuple2)this.getOption(index).getOrNull();
        }

        @Override
        @NotNull
        public final Option<Tuple2<E, U>> getOption(int index) {
            Option<? extends E> o1 = this.source.getOption(index);
            if (o1.isEmpty()) {
                return Option.none();
            }
            Option<? extends U> o2 = this.other.getOption(index);
            if (o2.isEmpty()) {
                return Option.none();
            }
            return Option.some((Object)Tuple.of((Object)o1.get(), (Object)o2.get()));
        }

        @Override
        @NotNull
        public final SeqView<Tuple2<E, U>> reversed() {
            return this.source.view().reversed().zipView(this.other.view().reversed());
        }
    }

    public static final class Sorted<E>
    extends AbstractSeqView<E> {
        private final SeqView<E> source;
        private Comparator<? super E> comparator;
        private Object[] sorted;

        public Sorted(@NotNull SeqView<E> source, @NotNull Comparator<? super E> comparator) {
            this.source = source;
            this.comparator = comparator;
        }

        private void initSorted() {
            if (this.sorted == null) {
                Object[] arr = this.source.toArray();
                Arrays.sort(arr, this.comparator);
                this.sorted = arr;
                this.comparator = null;
            }
        }

        @NotNull
        public final Iterator<E> iterator() {
            this.initSorted();
            return GenericArrays.iterator((Object[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return (E)this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @Nullable
        public final E getOrNull(int index) {
            if (index < 0) {
                return null;
            }
            this.initSorted();
            Object[] sorted = this.sorted;
            if (index >= sorted.length) {
                return null;
            }
            return (E)sorted[index];
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            if (index < 0) {
                return Option.none();
            }
            this.initSorted();
            Object[] sorted = this.sorted;
            return index >= sorted.length ? Option.none() : Option.some((Object)sorted[index]);
        }

        @Override
        @NotNull
        public final SeqView<E> sorted(Comparator<? super E> comparator) {
            if (comparator == Comparators.naturalOrder()) {
                comparator = null;
            }
            if (comparator == this.comparator) {
                return this;
            }
            if (comparator == null && this.comparator == Comparators.reverseOrder() || comparator == Comparators.reverseOrder() && this.comparator == null) {
                return this.reversed();
            }
            return new Sorted<E>(this.source, comparator);
        }
    }

    public static final class MapIndexedMulti<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<T> source;
        @NotNull
        private final IndexedBiConsumer<? super T, ? super Consumer<? super E>> mapper;

        public MapIndexedMulti(@NotNull SeqView<T> source, @NotNull IndexedBiConsumer<? super T, ? super Consumer<? super E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.mapIndexedMulti((Iterator)this.source.iterator(), this.mapper);
        }
    }

    public static final class MapMulti<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<T> source;
        @NotNull
        private final BiConsumer<? super T, ? super Consumer<? super E>> mapper;

        public MapMulti(@NotNull SeqView<T> source, @NotNull BiConsumer<? super T, ? super Consumer<? super E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.mapMulti((Iterator)this.source.iterator(), this.mapper);
        }
    }

    public static class MapIndexedNotNull<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<T> source;
        @NotNull
        private final IndexedFunction<? super T, ? extends E> mapper;

        public MapIndexedNotNull(@NotNull SeqView<T> source, @NotNull IndexedFunction<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.mapIndexedNotNull((Iterator)this.source.iterator(), this.mapper);
        }
    }

    public static class MapNotNull<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<T> source;
        @NotNull
        private final Function<? super T, ? extends E> mapper;

        public MapNotNull(@NotNull SeqView<T> source, @NotNull Function<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.mapNotNull((Iterator)this.source.iterator(), this.mapper);
        }
    }

    public static class MapIndexed<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<T> source;
        @NotNull
        private final IndexedFunction<? super T, ? extends E> mapper;

        public MapIndexed(@NotNull SeqView<T> source, @NotNull IndexedFunction<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.mapIndexed((Iterator)this.source.iterator(), this.mapper);
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final E get(int index) {
            return (E)this.mapper.apply(index, this.source.get(index));
        }

        @Override
        @Nullable
        public E getOrNull(int index) {
            return (E)this.getOption(index).getOrNull();
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            return this.source.getOption(index).map(a -> this.mapper.apply(index, a));
        }
    }

    public static class Mapped<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<T> source;
        @NotNull
        private final Function<? super T, ? extends E> mapper;

        public Mapped(@NotNull SeqView<T> source, @NotNull Function<? super T, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.map((Iterator)this.source.iterator(), this.mapper);
        }

        @NotNull
        public final Stream<E> stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public final Stream<E> parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final E get(int index) {
            return this.mapper.apply(this.source.get(index));
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            return this.source.getOption(index).map(this.mapper);
        }
    }

    public static final class FlatMapped<E, T>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<? extends T> source;
        @NotNull
        private final Function<? super T, ? extends Iterable<? extends E>> mapper;

        public FlatMapped(@NotNull SeqView<? extends T> source, @NotNull Function<? super T, ? extends Iterable<? extends E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.concat((Iterable)((Object)this.source.map((T it) -> this.mapper.apply(it).iterator())));
        }
    }

    public static final class FilterNotNull<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;

        public FilterNotNull(@NotNull SeqView<E> source) {
            this.source = source;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.filterNotNull((Iterator)this.source.iterator());
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().filter(Predicates.isNotNull());
        }

        @NotNull
        public Stream<E> parallelStream() {
            return this.source.parallelStream().filter(Predicates.isNotNull());
        }
    }

    public static final class FilterNot<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;
        @NotNull
        private final Predicate<? super E> predicate;

        public FilterNot(@NotNull SeqView<E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.filterNot((Iterator)this.source.iterator(), this.predicate);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public Stream<E> parallelStream() {
            return this.source.parallelStream().filter(this.predicate.negate());
        }
    }

    public static final class Filter<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;
        @NotNull
        private final Predicate<? super E> predicate;

        public Filter(@NotNull SeqView<E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public Iterator<E> iterator() {
            return Iterators.filter((Iterator)this.source.iterator(), this.predicate);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return this.source.parallelStream().filter(this.predicate);
        }
    }

    public static class Reversed<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;

        public Reversed(@NotNull SeqView<E> source) {
            this.source = source;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final E get(int index) {
            return (E)this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final SeqView<E> reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final Iterator<E> reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;
        protected final E value;

        public Appended(@NotNull SeqView<E> source, E value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.appended((Iterator)this.source.iterator(), this.value);
        }
    }

    public static class Prepended<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;
        private final E value;

        public Prepended(@NotNull SeqView<E> source, E value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.prepended((Iterator)this.source.iterator(), this.value);
        }

        @Override
        public final E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return (E)(index == 0 ? this.value : this.source.get(index - 1));
        }

        @Override
        @Nullable
        public E getOrNull(int index) {
            if (index < 0) {
                return null;
            }
            return (E)(index == 0 ? this.value : this.source.getOrNull(index + 1));
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            if (index < 0) {
                return Option.none();
            }
            return index == 0 ? Option.some(this.value) : this.source.getOption(index + 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqLike<? extends E> seq1;
        @NotNull
        protected final SeqLike<? extends E> seq2;

        public Concat(@NotNull SeqLike<? extends E> seq1, @NotNull SeqLike<? extends E> seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.concat((Iterator)this.seq1.iterator(), (Iterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;
        @NotNull
        private final Predicate<? super E> predicate;

        public TakeWhile(@NotNull SeqView<E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.takeWhile((Iterator)this.source.iterator(), this.predicate);
        }

        @NotNull
        public Stream<E> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return StreamSupport.stream(this.spliterator(), true);
        }
    }

    public static class TakeLast<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull SeqView<E> source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final E get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
            return (E)this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final Iterator<E> iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return Iterators.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return Iterators.drop((Iterator)this.source.iterator(), (int)Integer.max(k - this.n, 0));
            }
            return new AbstractIterator<E>(){
                Iterator<E> it;
                int len;
                int pos;
                MutableArrayList<E> buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableArrayList(Integer.min(n, 256));
                    this.len = 0;
                    while (this.it.hasNext()) {
                        Object next = this.it.next();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final E next() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    Object v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull SeqView<E> source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.take((Iterator)this.source.iterator(), (int)this.n);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().limit(this.n);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return (Stream)this.source.stream().limit(this.n).parallel();
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public SeqView<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            if (this.n <= n) {
                return this;
            }
            return new Take<E>(this.source, n);
        }
    }

    public static class DropWhile<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;
        @NotNull
        private final Predicate<? super E> predicate;

        public DropWhile(@NotNull SeqView<E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.dropWhile((Iterator)this.source.iterator(), this.predicate);
        }

        @NotNull
        public Stream<E> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return StreamSupport.stream(this.spliterator(), true);
        }
    }

    public static class DropLast<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull SeqView<E> source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final Iterator<E> iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return Iterators.empty();
            }
            return Iterators.take((Iterator)this.source.iterator(), (int)(ss - this.n));
        }

        @Override
        public final E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            SeqView<E> source = this.source;
            int n = this.n;
            if (n <= 0) {
                return (E)this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return (E)this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;
        protected final int n;

        public Drop(@NotNull SeqView<E> source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return Iterators.drop((Iterator)this.source.iterator(), (int)this.n);
        }

        @NotNull
        public Stream<E> stream() {
            return this.source.stream().skip(this.n);
        }

        @NotNull
        public Stream<E> parallelStream() {
            return (Stream)this.source.stream().skip(this.n).parallel();
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public SeqView<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final SeqView<E> source;
        private final int index;
        private final E newValue;

        public Updated(@NotNull SeqView<E> source, int index, E newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<E> it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                @Override
                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                @Override
                public final E next() {
                    Object value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final E get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return (E)this.source.get(index);
        }

        @Override
        @Nullable
        public E getOrNull(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return (E)this.source.getOrNull(index);
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            if (index == this.index) {
                return Option.some(this.newValue);
            }
            return this.source.getOption(index);
        }
    }

    public static class Slice<E>
    extends AbstractSeqView<E> {
        @NotNull
        protected final SeqView<E> source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull SeqView<E> source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public Iterator<E> iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractIterator<E> {
            private int idx;
            private final Iterator<E> it;

            Itr() {
                Iterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final E next() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    Object next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<E, C extends Seq<E>>
    extends Of<E, C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((Seq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((Seq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((Seq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice<E>
    implements SeqView<E>,
    IndexedSeqLike<E> {
        protected final Object[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(Object[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return GenericArrays.iterator((Object[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return (E)this.array[index + this.beginIndex];
        }

        @Override
        @Nullable
        public final E getOrNull(int index) {
            return (E)(index < 0 || index >= this.size() ? null : this.array[index + this.beginIndex]);
        }

        @Override
        @NotNull
        public final Option<E> getOption(int index) {
            return index < 0 || index >= this.size() ? Option.none() : Option.some((Object)this.array[index + this.beginIndex]);
        }

        @Override
        @NotNull
        public SeqView<E> slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return SeqView.empty();
                }
                case 1: {
                    return SeqView.of(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice<E>(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public SeqView<E> sliceView(int beginIndex, int endIndex) {
            return this.slice(beginIndex, endIndex);
        }

        @Override
        @NotNull
        public SeqView<E> drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return SeqView.empty();
            }
            return new OfArraySlice<E>(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public SeqView<E> dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return SeqView.empty();
            }
            return new OfArraySlice<E>(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public SeqView<E> take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return SeqView.of(this.array[this.beginIndex]);
            }
            return new OfArraySlice<E>(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public SeqView<E> takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return SeqView.empty();
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return SeqView.of(this.array[this.beginIndex]);
            }
            return new OfArraySlice<E>(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<E, C extends SeqLike<E>>
    extends CollectionViews.Of<E, C>
    implements SeqView<E> {
        public Of(@NotNull C source) {
            super(source);
        }

        @Override
        @NotNull
        public SeqIterator<E> seqIterator() {
            return ((SeqLike)this.source).seqIterator().frozen();
        }

        @Override
        @NotNull
        public SeqIterator<E> seqIterator(int index) {
            return ((SeqLike)this.source).seqIterator(index).frozen();
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return ((SeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public E get(int index) {
            return ((SeqLike)this.source).get(index);
        }

        @Override
        @Nullable
        public E getOrNull(int index) {
            return ((SeqLike)this.source).getOrNull(index);
        }

        @Override
        @NotNull
        public Option<E> getOption(int index) {
            return ((SeqLike)this.source).getOption(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((SeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(Object value) {
            return ((SeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(Object value, int from) {
            return ((SeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull Predicate<? super E> predicate) {
            return ((SeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull Predicate<? super E> predicate, int from) {
            return ((SeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(Object value) {
            return ((SeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int end) {
            return ((SeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
            return ((SeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull Predicate<? super E> predicate, int end) {
            return ((SeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
            ((SeqLike)this.source).forEachIndexed(action);
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return ((SeqLike)this.source).reverseIterator();
        }
    }

    public static class Single<E>
    extends CollectionViews.Single<E>
    implements SeqView<E> {
        public Single(E value) {
            super(value);
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public SeqView<E> reversed() {
            return this;
        }

        @Override
        @NotNull
        public final Iterator<E> reverseIterator() {
            return Iterators.of((Object)this.value);
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return (E)this.value;
        }

        @Override
        @NotNull
        public SeqView<E> updated(int index, E newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single<E>(newValue);
        }

        @Override
        @NotNull
        public SeqView<E> filterNotNull() {
            return this.value == null ? SeqView.empty() : this;
        }
    }

    public static class Empty<E>
    extends CollectionViews.Empty<E>
    implements SeqView<E> {
        public static final Empty<?> INSTANCE = new Empty();

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public SeqView<E> reversed() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<E> reverseIterator() {
            return Iterators.empty();
        }

        @Override
        public E get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public SeqView<E> concat(@NotNull SeqLike<? extends E> other) {
            return other.view();
        }

        @Override
        @NotNull
        public SeqView<E> filter(@NotNull Predicate<? super E> predicate) {
            return this;
        }

        @Override
        @NotNull
        public SeqView<E> filterNot(@NotNull Predicate<? super E> predicate) {
            return this;
        }

        @Override
        @NotNull
        public @NotNull SeqView<@NotNull E> filterNotNull() {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> map(@NotNull Function<? super E, ? extends U> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapNotNull(@NotNull Function<? super E, ? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public <U> SeqView<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
            return this;
        }

        @Override
        @NotNull
        public SeqView<E> sorted(Comparator<? super E> comparator) {
            return this;
        }
    }
}

