/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.Collection;
import kala.collection.IndexedSeq;
import kala.collection.SeqLike;
import kala.collection.base.AnyTraversable;
import kala.collection.base.GenericArrays;
import kala.collection.base.ObjectArrays;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableArray;
import kala.collection.internal.CollectionHelper;
import kala.collection.mutable.AbstractMutableList;
import kala.collection.mutable.AbstractMutableListFactory;
import kala.collection.mutable.AbstractMutableListIterator;
import kala.collection.mutable.MutableListIterator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableArrayList<E>
extends AbstractMutableList<E>
implements IndexedSeq<E>,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory<?> FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final Object[] DEFAULT_EMPTY_ARRAY = new Object[0];
    Object @NotNull [] elements;
    int size;

    private MutableArrayList(Object @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? ObjectArrays.EMPTY : new Object[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableArrayList<E>> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableArrayList<E> create() {
        return new MutableArrayList<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayList<E> create(int initialCapacity) {
        return new MutableArrayList<E>(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableArrayList<E> of() {
        return new MutableArrayList<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayList<E> of(E value1) {
        Object[] arr = new Object[10];
        arr[0] = value1;
        return new MutableArrayList<E>(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableArrayList<E> of(E value1, E value2) {
        Object[] arr = new Object[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableArrayList<E>(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableArrayList<E> of(E value1, E value2, E value3) {
        Object[] arr = new Object[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableArrayList<E>(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableArrayList<E> of(E value1, E value2, E value3, E value4) {
        Object[] arr = new Object[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableArrayList<E>(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableArrayList<E> of(E value1, E value2, E value3, E value4, E value5) {
        Object[] arr = new Object[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableArrayList<E>(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayList<E> of(E ... values) {
        return MutableArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArrayList<E> from(E @NotNull [] values) {
        int length = values.length;
        if (length == 0) {
            return new MutableArrayList<E>();
        }
        Object[] newValues = new Object[length];
        System.arraycopy(values, 0, newValues, 0, length);
        return new MutableArrayList<E>(newValues, length);
    }

    @NotNull
    public static <E> MutableArrayList<E> from(@NotNull Iterable<? extends E> values) {
        MutableArrayList<? extends E> buffer = new MutableArrayList<E>();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static <E> MutableArrayList<E> from(@NotNull Iterator<? extends E> it) {
        MutableArrayList<E> buffer = new MutableArrayList<E>();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer;
    }

    @NotNull
    public static <E> MutableArrayList<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableArrayList.factory());
    }

    @NotNull
    public static <E> MutableArrayList<E> fill(int n, E value) {
        if (n <= 0) {
            return new MutableArrayList<E>();
        }
        Object[] arr = new Object[Integer.max(10, n)];
        if (value != null) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableArrayList<E>(arr, n);
    }

    @NotNull
    public static <E> MutableArrayList<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return new MutableArrayList<E>();
        }
        Object[] arr = new Object[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.get();
        }
        return new MutableArrayList<E>(arr, n);
    }

    @NotNull
    public static <E> MutableArrayList<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return new MutableArrayList<E>();
        }
        Object[] arr = new Object[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = init.apply(i);
        }
        return new MutableArrayList<E>(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        Object[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private Object[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new Object[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new Object[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    Object @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        Arrays.fill(this.elements, newSize, this.size, null);
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableArrayList";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableArrayList<U>> iterableFactory() {
        return MutableArrayList.factory();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return GenericArrays.iterator((Object[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public Iterator<E> iterator(int beginIndex) {
        return GenericArrays.iterator((Object[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableListIterator<E> seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    @NotNull
    public Spliterator<E> spliterator() {
        return Arrays.spliterator(this.elements, 0, this.size);
    }

    @Override
    @NotNull
    public MutableArrayList<E> clone() {
        Object[] elements = this.elements;
        int size = this.size;
        return new MutableArrayList<E>(elements.length == 0 ? elements : (Object[])elements.clone(), size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public E get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return (E)this.elements[index];
    }

    @Override
    public void set(int index, E newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(E value) {
        Object[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof SeqLike && ((SeqLike)((Object)values)).supportsFastRandomAccess()) {
            SeqLike seq = (SeqLike)((Object)values);
            int s = seq.size();
            if (s == 0) {
                return;
            }
            Object[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        Object[] cv = CollectionHelper.asArray(values);
        if (cv.length == 0) {
            return;
        }
        Object[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(E value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = AnyTraversable.knownSize(values);
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        for (E e : values) {
            this.append(e);
        }
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        Object[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, E value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, E value, Comparator<? super E> comparator) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value, comparator);
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        Arrays.sort(this.elements, 0, this.size, comparator);
    }

    @Override
    public void insert(int index, E value) {
        int size = this.size;
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == size) {
            this.append(value);
            return;
        }
        if (this.elements.length == size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        Collection other = CollectionHelper.asSizedCollection(values);
        int otherSize = other.size();
        Object[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        Iterator it = other.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.next();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, E @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        Object[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? ObjectArrays.EMPTY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        this.size = 0;
    }

    @Override
    public E removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        Object oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = null;
        this.size = newSize;
        return (E)oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        if (tailElementsCount < rangeLength) {
            Arrays.fill(this.elements, beginIndex + tailElementsCount, beginIndex + rangeLength, null);
        }
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        Arrays.fill(this.elements, n, this.elements.length, null);
        this.size = n;
    }

    @Override
    public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    @Override
    public Object @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        return Arrays.copyOf(this.elements, this.size, GenericArrays.arrayType(type));
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        int size = this.size;
        U[] arr = generator.apply(size);
        System.arraycopy(this.elements, 0, arr, 0, size);
        return arr;
    }

    @Override
    @NotNull
    public ImmutableArray<E> toImmutableArray() {
        return this.size == 0 ? ImmutableArray.empty() : ImmutableArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        Object[] elements = size == 0 ? ObjectArrays.EMPTY : new Object[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readObject();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory<E>
    extends AbstractMutableListFactory<E, MutableArrayList<E>> {
        private Factory() {
        }

        public MutableArrayList<E> newBuilder() {
            return new MutableArrayList();
        }

        public void sizeHint(@NotNull MutableArrayList<E> buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableArrayList<E> from(E @NotNull [] values) {
            return MutableArrayList.from(values);
        }

        public MutableArrayList<E> from(@NotNull Iterable<? extends E> values) {
            return MutableArrayList.from(values);
        }

        public MutableArrayList<E> from(@NotNull Iterator<? extends E> it) {
            return MutableArrayList.from(it);
        }

        public MutableArrayList<E> fill(int n, E value) {
            return MutableArrayList.fill(n, value);
        }

        public MutableArrayList<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return MutableArrayList.fill(n, supplier);
        }

        public MutableArrayList<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return MutableArrayList.fill(n, init);
        }
    }

    private static final class SeqItr<E>
    extends AbstractMutableListIterator<E> {
        private final MutableArrayList<E> seq;
        private int lastReturned = -1;

        SeqItr(MutableArrayList<E> seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public E next() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                Object res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return (E)res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public E previous() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                Object res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return (E)res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(E e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(E e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

