/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Iterator;
import java.util.stream.Stream;
import kala.collection.Collection;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.mutable.MutableAnyCollection;
import kala.collection.mutable.MutableCollectionEditor;
import kala.collection.mutable.MutableSeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableCollection<E>
extends Collection<E>,
MutableAnyCollection<E> {
    @NotNull
    public static <E> CollectionFactory<E, ?, MutableCollection<E>> factory() {
        return CollectionFactory.narrow(MutableSeq.factory());
    }

    @NotNull
    public static <E> MutableCollection<E> of() {
        return MutableSeq.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableCollection<E> of(E value1) {
        return MutableSeq.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableCollection<E> of(E value1, E value2) {
        return MutableSeq.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableCollection<E> of(E value1, E value2, E value3) {
        return MutableSeq.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableCollection<E> of(E value1, E value2, E value3, E value4) {
        return MutableSeq.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableCollection<E> of(E value1, E value2, E value3, E value4, E value5) {
        return MutableSeq.of(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> MutableCollection<E> of(E ... values) {
        return MutableCollection.from(values);
    }

    @NotNull
    public static <E> MutableCollection<E> from(E @NotNull [] values) {
        return MutableSeq.from(values);
    }

    @NotNull
    public static <E> MutableCollection<E> from(@NotNull Iterable<? extends E> values) {
        return MutableSeq.from(values);
    }

    @NotNull
    public static <E> MutableCollection<E> from(@NotNull Iterator<? extends E> it) {
        return MutableSeq.from(it);
    }

    @NotNull
    public static <E> MutableCollection<E> from(@NotNull Stream<? extends E> stream) {
        return MutableSeq.from(stream);
    }

    @NotNull
    public static <E, C extends MutableCollection<E>> MutableCollectionEditor<E, C> edit(@NotNull C collection) {
        return new MutableCollectionEditor(collection);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableCollection";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends MutableCollection<U>> iterableFactory() {
        return MutableCollection.factory();
    }

    @Override
    @NotNull
    default public java.util.Collection<E> asJava() {
        return new AsJavaConvert.MutableCollectionAsJava(this);
    }

    @NotNull
    default public MutableCollection<E> clone() {
        return (MutableCollection)this.iterableFactory().from((Iterable)((Object)this));
    }
}

