/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import kala.collection.mutable.MutableArrayDeque;
import kala.collection.mutable.MutableQueue;
import kala.control.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableDeque<E>
extends MutableQueue<E> {
    @NotNull
    public static <E> MutableDeque<E> create() {
        return new MutableArrayDeque();
    }

    @Override
    public boolean isEmpty();

    public void prepend(E var1);

    public void append(E var1);

    public E removeFirst();

    @Nullable
    default public E removeFirstOrNull() {
        return this.isNotEmpty() ? (E)this.removeFirst() : null;
    }

    @NotNull
    default public Option<E> removeFirstOption() {
        return this.isNotEmpty() ? Option.some(this.removeFirst()) : Option.none();
    }

    public E removeLast();

    @Nullable
    default public E removeLastOrNull() {
        return this.isNotEmpty() ? (E)this.removeLast() : null;
    }

    @NotNull
    default public Option<E> removeLastOption() {
        return this.isNotEmpty() ? Option.some(this.removeLast()) : Option.none();
    }

    public E first();

    @Nullable
    default public E firstOrNull() {
        return this.isNotEmpty() ? (E)this.first() : null;
    }

    @NotNull
    default public Option<E> firstOption() {
        return this.isNotEmpty() ? Option.some(this.first()) : Option.none();
    }

    public E last();

    @Nullable
    default public E lastOrNull() {
        return this.isNotEmpty() ? (E)this.last() : null;
    }

    @NotNull
    default public Option<E> lastOption() {
        return this.isNotEmpty() ? Option.some(this.last()) : Option.none();
    }

    @Override
    default public void enqueue(E value) {
        this.prepend(value);
    }

    @Override
    default public E dequeue() {
        return this.removeLast();
    }

    @Override
    @Nullable
    default public E dequeueOrNull() {
        return this.removeLastOrNull();
    }

    @Override
    @NotNull
    default public Option<E> dequeueOption() {
        return this.removeLastOption();
    }
}

