/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.base.AbstractIterator;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.AbstractMutableList;
import kala.collection.mutable.AbstractMutableListFactory;
import kala.collection.mutable.AbstractMutableListIterator;
import kala.collection.mutable.MutableDeque;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableListIterator;
import kala.collection.mutable.MutableStack;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
public final class MutableLinkedList<E>
extends AbstractMutableList<E>
implements MutableStack<E>,
MutableDeque<E>,
Serializable {
    private static final long serialVersionUID = 8463536184690478447L;
    private static final Factory<?> FACTORY = new Factory();
    private int len = 0;
    private Node<E> first = null;
    private Node<E> last = null;

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableLinkedList<E>> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableLinkedList<E> create() {
        return new MutableLinkedList<E>();
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableLinkedList<E> of() {
        return new MutableLinkedList<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> of(E value1) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.append(value1);
        return res;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> of(E value1, E value2) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.append(value1);
        res.append(value2);
        return res;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> of(E value1, E value2, E value3) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.append(value1);
        res.append(value2);
        res.append(value3);
        return res;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> of(E value1, E value2, E value3, E value4) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.append(value1);
        res.append(value2);
        res.append(value3);
        res.append(value4);
        return res;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.append(value1);
        res.append(value2);
        res.append(value3);
        res.append(value4);
        res.append(value5);
        return res;
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> of(E ... values) {
        return MutableLinkedList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> from(E @NotNull [] values) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.appendAll(values);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> from(@NotNull Iterable<? extends E> values) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        res.appendAll(values);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> from(@NotNull Iterator<? extends E> iterator) {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        while (iterator.hasNext()) {
            res.append(iterator.next());
        }
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedList<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableLinkedList.factory());
    }

    Node<E> getNode(int index) {
        Node<E> x;
        int len = this.len;
        if (index < len >> 1) {
            x = this.first;
            for (int i = 0; i < index; ++i) {
                x = x.next;
            }
        } else {
            x = this.last;
            for (int i = len - 1; i > index; --i) {
                x = x.prev;
            }
        }
        return x;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableLinkedList";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ? extends MutableList<U>> iterableFactory() {
        return MutableLinkedList.factory();
    }

    @NotNull
    public Iterator<E> iterator() {
        Node<E> first = this.first;
        return first == null ? Iterators.empty() : new Itr<E>(first);
    }

    @Override
    @NotNull
    public MutableListIterator<E> seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.len);
        return new SeqItr(index);
    }

    @Override
    @NotNull
    public MutableStack<E> asMutableStack() {
        return this;
    }

    @Override
    @NotNull
    public MutableLinkedList<E> clone() {
        MutableLinkedList<E> res = new MutableLinkedList<E>();
        if (this.len != 0) {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                res.append(e);
            }
        }
        return res;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.getNode((int)index).value;
    }

    @Override
    public void prepend(E value) {
        Node<E> first = this.first;
        Node<E> newNode = new Node<E>(null, first, value);
        this.first = newNode;
        if (first == null) {
            this.last = newNode;
        } else {
            first.prev = newNode;
        }
        ++this.len;
    }

    @Override
    public void append(E value) {
        Node<E> last = this.last;
        Node<E> newNode = new Node<E>(last, null, value);
        this.last = newNode;
        if (last == null) {
            this.first = newNode;
        } else {
            last.next = newNode;
        }
        ++this.len;
    }

    @Override
    public E removeFirst() {
        Node<E> first = this.first;
        if (first == null) {
            throw new NoSuchElementException();
        }
        Node next = first.next;
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.prev = null;
        }
        --this.len;
        return first.value;
    }

    @Override
    public E removeLast() {
        Node<E> last = this.last;
        if (last == null) {
            throw new NoSuchElementException();
        }
        Node prev = last.prev;
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            prev.next = null;
        }
        --this.len;
        return last.value;
    }

    @Override
    public void insert(int index, E value) {
        Conditions.checkPositionIndex((int)index, (int)this.len);
        if (index == this.len) {
            this.append(value);
        } else {
            this.insertBefore(this.getNode(index), value);
        }
    }

    void insertBefore(Node<E> node, E value) {
        Node prev = node.prev;
        Node newNode = new Node(prev, node, value);
        node.prev = newNode;
        if (prev == null) {
            this.first = newNode;
        } else {
            prev.next = newNode;
        }
        ++this.len;
    }

    @Override
    public E removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.len);
        Node<E> node = this.getNode(index);
        Object value = node.value;
        this.removeAt(node);
        return value;
    }

    void removeAt(@NotNull Node<E> node) {
        Node prev = node.prev;
        Node next = node.next;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            node.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            node.next = null;
        }
        node.value = null;
        --this.len;
    }

    @Override
    public boolean remove(Object value) {
        Node<E> node = this.first;
        if (value == null) {
            while (node != null) {
                if (null == node.value) {
                    this.removeAt(node);
                    return true;
                }
                node = node.next;
            }
        } else {
            while (node != null) {
                if (value.equals(node.value)) {
                    this.removeAt(node);
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.len = 0;
        this.first = null;
        this.last = null;
    }

    @Override
    public void set(int index, E newValue) {
        if (index < 0 || index >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        this.getNode((int)index).value = newValue;
    }

    @Override
    public E first() {
        Node<E> first = this.first;
        if (first == null) {
            throw new NoSuchElementException();
        }
        return first.value;
    }

    @Override
    public E last() {
        Node<E> last = this.last;
        if (last == null) {
            throw new NoSuchElementException();
        }
        return last.value;
    }

    public int size() {
        return this.len;
    }

    public int knownSize() {
        return this.len;
    }

    @Override
    public void push(E value) {
        this.prepend(value);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.first();
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
        Node<E> node = this.first;
        while (node != null) {
            node.value = operator.apply(node.value);
            node = node.next;
        }
    }

    @Override
    public void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
        Node<E> node = this.first;
        int idx = 0;
        while (node != null) {
            node.value = operator.apply(idx++, node.value);
            node = node.next;
        }
    }

    @Override
    public void reverse() {
        int size = this.len;
        if (size == 0) {
            return;
        }
        int limit = size / 2;
        Node<E> f = this.first;
        Node<E> l = this.last;
        for (int i = 0; i < limit; ++i) {
            Object tmp = f.value;
            f.value = l.value;
            l.value = tmp;
            f = f.next;
            l = l.prev;
        }
    }

    @Override
    @NotNull
    public Iterator<E> reverseIterator() {
        return this.last == null ? Iterators.empty() : new ReverseItr<E>(this.last);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.len);
        Node<E> node = this.first;
        for (int i = 0; i < this.len; ++i) {
            out.writeObject(node.value);
            node = node.next;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Node<Object> first;
        this.clear();
        int size = in.readInt();
        if (size == 0) {
            return;
        }
        Node<Object> last = first = new Node<Object>(null, null, in.readObject());
        for (int i = 1; i < size; ++i) {
            Node<Object> node = new Node<Object>(null, null, in.readObject());
            last.next = node;
            last = node;
        }
        this.len = size;
        this.first = first;
        this.last = last;
    }

    private static final class Node<E> {
        E value;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, Node<E> next, E value) {
            this.next = next;
            this.prev = prev;
            this.value = value;
        }
    }

    private static final class Factory<E>
    extends AbstractMutableListFactory<E, MutableLinkedList<E>> {
        private Factory() {
        }

        public MutableLinkedList<E> newBuilder() {
            return new MutableLinkedList();
        }
    }

    private static final class Itr<E>
    extends AbstractIterator<E> {
        private Node<E> node;

        Itr(Node<E> node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public E next() {
            Node<E> node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Object v = node.value;
            this.node = node.next;
            return v;
        }
    }

    private final class SeqItr
    extends AbstractMutableListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;

        SeqItr(int index) {
            super(index);
            this.next = index == MutableLinkedList.this.len ? null : MutableLinkedList.this.getNode(index);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < MutableLinkedList.this.len;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.cursor;
            return this.lastReturned.value;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? MutableLinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.cursor;
            return this.lastReturned.value;
        }

        @Override
        public void add(E e) {
            this.lastReturned = null;
            if (this.next == null) {
                MutableLinkedList.this.append(e);
            } else {
                MutableLinkedList.this.insertBefore(this.next, e);
            }
            ++this.cursor;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastReturnedNext = this.lastReturned;
            MutableLinkedList.this.removeAt(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastReturnedNext;
            } else {
                --this.cursor;
            }
            this.lastReturned = null;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.value = e;
        }
    }

    private static final class ReverseItr<E>
    extends AbstractIterator<E> {
        private Node<E> node;

        ReverseItr(Node<E> node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public E next() {
            Node<E> node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Object v = node.value;
            this.node = node.prev;
            return v;
        }
    }
}

