/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.RandomAccess;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.Seq;
import kala.collection.SeqIterator;
import kala.collection.base.ObjectArrays;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.SeqIterators;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.mutable.MutableAnySeq;
import kala.collection.mutable.MutableArray;
import kala.collection.mutable.MutableCollection;
import kala.collection.mutable.MutableSeqEditor;
import kala.collection.mutable.MutableSeqIterator;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableSeq<E>
extends MutableCollection<E>,
Seq<E>,
MutableAnySeq<E> {
    @NotNull
    public static <E> CollectionFactory<E, ?, MutableSeq<E>> factory() {
        return CollectionFactory.narrow(MutableArray.factory());
    }

    @NotNull
    public static <E> MutableSeq<E> of() {
        return MutableArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSeq<E> of(E value1) {
        return MutableArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableSeq<E> of(E value1, E value2) {
        return MutableArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableSeq<E> of(E value1, E value2, E value3) {
        return MutableArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableSeq<E> of(E value1, E value2, E value3, E value4) {
        return MutableArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableSeq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return MutableArray.of(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> MutableSeq<E> of(E ... values) {
        return MutableSeq.from(values);
    }

    @NotNull
    public static <E> MutableSeq<E> from(E @NotNull [] values) {
        return MutableArray.from(values);
    }

    @NotNull
    public static <E> MutableSeq<E> from(@NotNull Iterable<? extends E> values) {
        return MutableArray.from(values);
    }

    @NotNull
    public static <E> MutableSeq<E> from(@NotNull Iterator<? extends E> it) {
        return MutableArray.from(it);
    }

    @NotNull
    public static <E> MutableSeq<E> from(@NotNull Stream<? extends E> stream) {
        return MutableArray.from(stream);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSeq<E> wrapJava(@NotNull List<E> list) {
        Objects.requireNonNull(list);
        return list instanceof RandomAccess ? new FromJavaConvert.MutableIndexedSeqFromJava<E>(list) : new FromJavaConvert.MutableSeqFromJava<E>(list);
    }

    @NotNull
    public static <E, C extends MutableSeq<E>> MutableSeqEditor<E, C> edit(@NotNull C seq) {
        return new MutableSeqEditor(seq);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableSeq";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends MutableSeq<U>> iterableFactory() {
        return MutableSeq.factory();
    }

    @Override
    @NotNull
    default public MutableSeqIterator<E> seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableSeqIterator<E> seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new SeqIterators.DefaultMutableSeqIterator(this, index);
    }

    @Override
    @NotNull
    default public List<E> asJava() {
        return this.supportsFastRandomAccess() ? new AsJavaConvert.MutableIndexedSeqAsJava(this) : new AsJavaConvert.MutableSeqAsJava(this);
    }

    @Override
    @NotNull
    default public MutableSeq<E> clone() {
        return (MutableSeq)this.iterableFactory().from((Iterable)((Object)this));
    }

    @Contract(mutates="this")
    public void set(int var1, E var2);

    default public void swap(int index1, int index2) {
        Object old1 = this.get(index1);
        Object old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
        int size = this.size();
        if (this.supportsFastRandomAccess()) {
            for (int i = 0; i < size; ++i) {
                this.set(i, operator.apply(this.get(i)));
            }
        } else {
            SeqIterator it = this.seqIterator();
            while (it.hasNext()) {
                it.set(operator.apply(it.next()));
            }
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
        int size = this.size();
        if (this.supportsFastRandomAccess()) {
            for (int i = 0; i < size; ++i) {
                this.set(i, operator.apply(i, this.get(i)));
            }
        } else {
            int idx = 0;
            SeqIterator it = this.seqIterator();
            while (it.hasNext()) {
                it.set(operator.apply(idx++, it.next()));
            }
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        this.sort(null);
    }

    @Contract(mutates="this")
    default public void sort(Comparator<? super E> comparator) {
        Object[] values = this.toArray();
        if (values.length <= 1) {
            return;
        }
        Arrays.sort(values, comparator);
        if (this.supportsFastRandomAccess()) {
            for (int i = 0; i < values.length; ++i) {
                this.set(i, values[i]);
            }
        } else {
            SeqIterator it = this.seqIterator();
            for (Object value : values) {
                it.next();
                it.set(value);
            }
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            Object[] arr = this.toArray();
            ObjectArrays.shuffle((Object[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

