/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Objects;
import java.util.function.Predicate;
import kala.collection.ArraySeq;
import kala.collection.Collection;
import kala.collection.Set;
import kala.collection.base.Growable;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.CollectionHelper;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.mutable.MutableAnySet;
import kala.collection.mutable.MutableCollection;
import kala.collection.mutable.MutableHashSet;
import kala.collection.mutable.MutableSetEditor;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableSet<E>
extends MutableCollection<E>,
Set<E>,
Growable<E>,
MutableAnySet<E> {
    @Contract(pure=true)
    @NotNull
    public static <E> CollectionFactory<E, ?, MutableSet<E>> factory() {
        return CollectionFactory.narrow(MutableHashSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableSet<E> create() {
        return MutableHashSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableSet<E> of() {
        return MutableHashSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSet<E> of(E value1) {
        return MutableHashSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableSet<E> of(E value1, E value2) {
        return MutableHashSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableSet<E> of(E value1, E value2, E value3) {
        return MutableHashSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableSet<E> of(E value1, E value2, E value3, E value4) {
        return MutableHashSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableSet<E> of(E value1, E value2, E value3, E value4, E value5) {
        return MutableHashSet.of(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSet<E> of(E ... values) {
        return MutableSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSet<E> from(E @NotNull [] values) {
        return MutableHashSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSet<E> from(@NotNull Iterable<? extends E> values) {
        return MutableHashSet.from(values);
    }

    public static <E, C extends MutableSet<E>> MutableSetEditor<E, C> edit(@NotNull C set) {
        return new MutableSetEditor(set);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableSet";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends MutableSet<U>> iterableFactory() {
        return MutableSet.factory();
    }

    @Override
    default public @NotNull java.util.Set<E> asJava() {
        return new AsJavaConvert.MutableSetAsJava(this);
    }

    @Override
    @NotNull
    default public MutableSet<E> clone() {
        return (MutableSet)this.iterableFactory().from((Iterable)((Object)this));
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) E var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) E @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll((Iterable<? extends E>)((Object)ArraySeq.wrap(values)));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) Iterable<? extends E> values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        for (E value : values) {
            if (!this.add(value)) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(E value) {
        this.add(value);
    }

    default public void plusAssign(E @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull Iterable<? extends E> values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    public boolean remove(Object var1);

    @Contract(mutates="this")
    default public boolean removeAll(Object @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll((Iterable<?>)((Object)ArraySeq.wrap(values)));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull Iterable<?> values) {
        Objects.requireNonNull(values);
        boolean m = false;
        for (Object value : values) {
            if (!this.remove(value)) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] arr = this.toArray();
        int oldSize = arr.length;
        for (Object e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(E @NotNull [] values) {
        return this.retainAll((Iterable<? super E>)((Object)ArraySeq.wrap(values)));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull Iterable<? super E> values) {
        Objects.requireNonNull(values);
        if (this.isEmpty()) {
            return false;
        }
        Collection t = CollectionHelper.asCollection(values);
        if (t.isEmpty()) {
            return false;
        }
        Object[] arr = this.toArray();
        int oldSize = arr.length;
        for (Object value : arr) {
            if (t.contains(value)) continue;
            this.remove(value);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] arr = this.toArray();
        int oldSize = arr.length;
        for (Object e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull Predicate<? super E> predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull Predicate<? super E> predicate) {
        this.removeAll(predicate);
    }
}

