/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.IndexedSeq;
import kala.collection.base.GenericArrays;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.AbstractMutableList;
import kala.collection.mutable.AbstractMutableListFactory;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableSmartArrayList<E>
extends AbstractMutableList<E>
implements IndexedSeq<E>,
Serializable {
    private static final long serialVersionUID = 85150510977824651L;
    private static final int DEFAULT_CAPACITY = 16;
    private static final Factory<?> FACTORY = new Factory();
    private Object elem;
    private int size = 0;

    private MutableSmartArrayList(int size, Object[] elements) {
        this.size = size;
        this.elem = elements;
    }

    public MutableSmartArrayList() {
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableSmartArrayList<E>> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> create() {
        return new MutableSmartArrayList<E>();
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of() {
        return new MutableSmartArrayList<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of(E value1) {
        MutableSmartArrayList<E> buffer = new MutableSmartArrayList<E>();
        buffer.size = 1;
        buffer.elem = value1;
        return buffer;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of(E value1, E value2) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableSmartArrayList<E>(2, arr);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of(E value1, E value2, E value3) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableSmartArrayList<E>(3, arr);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of(E value1, E value2, E value3, E value4) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableSmartArrayList<E>(4, arr);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of(E value1, E value2, E value3, E value4, E value5) {
        Object[] arr = new Object[16];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableSmartArrayList<E>(5, arr);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> of(E ... values) {
        return MutableSmartArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSmartArrayList<E> from(E @NotNull [] values) {
        int length = values.length;
        switch (length) {
            case 0: {
                return new MutableSmartArrayList<E>();
            }
            case 1: {
                return MutableSmartArrayList.of(values[0]);
            }
        }
        return new MutableSmartArrayList<E>(length, Arrays.copyOf(values, Math.max(length, 16), Object[].class));
    }

    @NotNull
    public static <E> MutableSmartArrayList<E> from(@NotNull Iterable<? extends E> values) {
        MutableSmartArrayList<E> buffer = new MutableSmartArrayList<E>();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static <E> MutableSmartArrayList<E> from(@NotNull Iterator<? extends E> it) {
        MutableSmartArrayList<E> buffer = new MutableSmartArrayList<E>();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer;
    }

    @NotNull
    public static <E> MutableSmartArrayList<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableSmartArrayList.factory());
    }

    @NotNull
    public static <E> MutableSmartArrayList<E> fill(int n, E value) {
        if (n <= 0) {
            return new MutableSmartArrayList<E>();
        }
        if (n == 1) {
            return MutableSmartArrayList.of(value);
        }
        Object[] arr = new Object[Integer.max(16, n)];
        if (value != null) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableSmartArrayList<E>(n, arr);
    }

    @NotNull
    public static <E> MutableSmartArrayList<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return new MutableSmartArrayList<E>();
        }
        if (n == 1) {
            return MutableSmartArrayList.of(supplier.get());
        }
        Object[] arr = new Object[Integer.max(16, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.get();
        }
        return new MutableSmartArrayList<E>(n, arr);
    }

    @NotNull
    public static <E> MutableSmartArrayList<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return new MutableSmartArrayList<E>();
        }
        if (n == 1) {
            return MutableSmartArrayList.of(init.apply(0));
        }
        Object[] arr = new Object[Integer.max(16, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = init.apply(i);
        }
        return new MutableSmartArrayList<E>(n, arr);
    }

    private static Object[] growArray(int oldCapacity) {
        assert (oldCapacity < Integer.MAX_VALUE);
        return MutableSmartArrayList.growArray(oldCapacity, oldCapacity + 1);
    }

    private static Object[] growArray(int oldCapacity, int minCapacity) {
        if (oldCapacity == 0) {
            return new Object[Math.max(16, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new Object[newCapacity];
    }

    private static int growSize(int oldCapacity) {
        assert (oldCapacity < Integer.MAX_VALUE);
        return MutableSmartArrayList.growSize(oldCapacity, oldCapacity + 1);
    }

    private static int growSize(int oldCapacity, int minCapacity) {
        return oldCapacity == 0 ? Math.max(16, minCapacity) : Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
    }

    @Override
    @NotNull
    public String className() {
        return "MutableSmartArrayList";
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        int size = this.size;
        switch (size) {
            case 0: {
                return Iterators.empty();
            }
            case 1: {
                return Iterators.of((Object)this.elem);
            }
        }
        return GenericArrays.iterator((Object[])((Object[])this.elem), (int)0, (int)size);
    }

    @NotNull
    public Spliterator<E> spliterator() {
        int size = this.size;
        switch (size) {
            case 0: {
                return Spliterators.emptySpliterator();
            }
            case 1: {
                return Spliterators.spliteratorUnknownSize(Iterators.of((Object)this.elem), 0);
            }
        }
        return Spliterators.spliterator((Object[])this.elem, 0, size, 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public E get(int index) {
        int size = this.size;
        Conditions.checkElementIndex((int)index, (int)size);
        if (size == 1) {
            return (E)this.elem;
        }
        return (E)((Object[])this.elem)[index];
    }

    @Override
    public void set(int index, E newValue) {
        int size = this.size;
        Conditions.checkElementIndex((int)index, (int)size);
        if (size == 1) {
            this.elem = newValue;
        } else {
            ((Object[])this.elem)[index] = newValue;
        }
    }

    @Override
    public void insert(int index, E value) {
        int oldSize = this.size;
        Conditions.checkPositionIndex((int)index, (int)oldSize);
        if (oldSize == 0) {
            this.elem = value;
            this.size = 1;
        } else if (oldSize == 1) {
            Object[] arr = new Object[16];
            if (index == 0) {
                arr[0] = value;
                arr[1] = this.elem;
            } else {
                arr[0] = this.elem;
                arr[1] = value;
            }
            this.elem = arr;
            this.size = 2;
        } else {
            Object[] arr = (Object[])this.elem;
            if (arr.length == oldSize) {
                Object[] newArr = new Object[MutableSmartArrayList.growSize(oldSize)];
                System.arraycopy(arr, 0, newArr, 0, index);
                System.arraycopy(arr, index, newArr, index + 1, oldSize - index);
                newArr[index] = value;
                this.elem = newArr;
            } else {
                System.arraycopy(arr, index, arr, index + 1, oldSize - index);
                arr[index] = value;
            }
            this.size = oldSize + 1;
        }
    }

    @Override
    public E removeAt(int index) {
        Object res;
        int oldSize = this.size;
        Conditions.checkElementIndex((int)index, (int)oldSize);
        if (oldSize == 1) {
            res = this.elem;
            this.elem = null;
            this.size = 0;
        } else {
            Object[] arr = (Object[])this.elem;
            res = arr[index];
            System.arraycopy(arr, index + 1, arr, index, this.size - index);
            this.size = oldSize - 1;
        }
        return (E)res;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.elem = null;
    }

    @Override
    public void prepend(E value) {
        int oldSize = this.size;
        if (oldSize == 0) {
            this.elem = value;
            this.size = 1;
        } else if (oldSize == 1) {
            Object[] arr = new Object[16];
            arr[0] = value;
            arr[1] = this.elem;
            this.elem = arr;
            this.size = 2;
        } else {
            Object[] arr = (Object[])this.elem;
            if (arr.length == oldSize) {
                Object[] newArr = MutableSmartArrayList.growArray(oldSize);
                System.arraycopy(arr, 0, newArr, 1, oldSize);
                arr = newArr;
            } else {
                System.arraycopy(arr, 0, arr, 1, oldSize);
            }
            arr[0] = value;
            this.elem = arr;
            this.size = oldSize + 1;
        }
    }

    @Override
    public void append(E value) {
        int oldSize = this.size;
        if (oldSize == 0) {
            this.elem = value;
            this.size = 1;
        } else if (oldSize == 1) {
            Object[] arr = new Object[16];
            arr[0] = this.elem;
            arr[1] = value;
            this.elem = arr;
            this.size = 2;
        } else {
            Object[] arr = (Object[])this.elem;
            if (arr.length == oldSize) {
                arr = Arrays.copyOf(arr, MutableSmartArrayList.growSize(oldSize));
            }
            arr[oldSize] = value;
            this.elem = arr;
            this.size = oldSize + 1;
        }
    }

    private void appendThis() {
        int oldSize = this.size;
        switch (oldSize) {
            case 0: {
                return;
            }
            case 1: {
                Object[] arr = new Object[16];
                arr[0] = arr[1] = this.elem;
                this.elem = arr;
                this.size = 2;
                return;
            }
        }
        Object[] arr = (Object[])this.elem;
        int newSize = oldSize * 2;
        if (newSize < 0) {
            throw new AssertionError();
        }
        if (arr.length < newSize) {
            this.elem = arr = Arrays.copyOf(arr, MutableSmartArrayList.growSize(arr.length, newSize));
        }
        System.arraycopy(arr, 0, arr, oldSize, oldSize);
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        int size = this.size;
        if (size == 0 || size == 1) {
            return;
        }
        Arrays.sort((Object[])this.elem, 0, size, comparator);
    }

    @Override
    public void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.elem = operator.apply(this.elem);
                return;
            }
        }
        Object[] arr = (Object[])this.elem;
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = operator.apply(arr[i]);
        }
    }

    @Override
    public void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.elem = operator.apply(0, this.elem);
                return;
            }
        }
        Object[] arr = (Object[])this.elem;
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = operator.apply(i, arr[i]);
        }
    }

    @Override
    public Object @NotNull [] toArray() {
        int size = this.size;
        switch (size) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                return new Object[]{this.elem};
            }
        }
        return Arrays.copyOf((Object[])this.elem, size);
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        int size = this.size;
        Object[] arr = (Object[])Array.newInstance(type, size);
        switch (size) {
            case 0: {
                return arr;
            }
            case 1: {
                arr[0] = this.elem;
                return arr;
            }
        }
        System.arraycopy(this.elem, 0, arr, 0, size);
        return arr;
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        int size = this.size;
        U[] arr = generator.apply(size);
        switch (size) {
            case 0: {
                return arr;
            }
            case 1: {
                arr[0] = this.elem;
                return arr;
            }
        }
        System.arraycopy(this.elem, 0, arr, 0, size);
        return arr;
    }

    private static final class Factory<E>
    extends AbstractMutableListFactory<E, MutableSmartArrayList<E>> {
        private Factory() {
        }

        public MutableSmartArrayList<E> newBuilder() {
            return new MutableSmartArrayList();
        }
    }
}

