/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kala.collection.AnySeq;
import kala.collection.Collection;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.base.Iterators;
import kala.collection.base.OrderedTraversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.internal.view.SeqViews;
import kala.comparator.Comparators;
import kala.function.CheckedFunction;
import kala.function.CheckedIndexedFunction;
import kala.function.CheckedPredicate;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import kala.function.Predicates;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface Seq<E>
extends Collection<E>,
OrderedTraversable<E>,
SeqLike<E>,
AnySeq<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> Seq<E> narrow(Seq<? extends E> seq) {
        return seq;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, Seq<E>> factory() {
        return CollectionFactory.narrow(ImmutableSeq.factory());
    }

    @NotNull
    public static <E> Seq<E> empty() {
        return ImmutableSeq.empty();
    }

    @NotNull
    public static <E> Seq<E> of() {
        return ImmutableSeq.of();
    }

    @NotNull
    public static <E> Seq<E> of(E value1) {
        return ImmutableSeq.of(value1);
    }

    @NotNull
    public static <E> Seq<E> of(E value1, E value2) {
        return ImmutableSeq.of(value1, value2);
    }

    @NotNull
    public static <E> Seq<E> of(E value1, E value2, E value3) {
        return ImmutableSeq.of(value1, value2, value3);
    }

    @NotNull
    public static <E> Seq<E> of(E value1, E value2, E value3, E value4) {
        return ImmutableSeq.of(value1, value2, value3, value4);
    }

    @NotNull
    public static <E> Seq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return ImmutableSeq.of(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> Seq<E> of(E ... values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> Seq<E> from(E @NotNull [] values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> Seq<E> from(@NotNull Iterable<? extends E> values) {
        return ImmutableSeq.from(values);
    }

    @NotNull
    public static <E> Seq<E> from(@NotNull Iterator<? extends E> it) {
        return ImmutableSeq.from(it);
    }

    @NotNull
    public static <E> Seq<E> fill(int n, E value) {
        return ImmutableSeq.fill(n, value);
    }

    @NotNull
    public static <E> Seq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        return ImmutableSeq.fill(n, supplier);
    }

    @NotNull
    public static <E> Seq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        return ImmutableSeq.fill(n, init);
    }

    @NotNull
    public static <E> Seq<E> generateUntil(@NotNull Supplier<? extends E> supplier, @NotNull Predicate<? super E> predicate) {
        return ImmutableSeq.generateUntil(supplier, predicate);
    }

    @NotNull
    public static <E> Seq<E> generateUntilNull(@NotNull Supplier<? extends @Nullable E> supplier) {
        return ImmutableSeq.generateUntilNull(supplier);
    }

    @NotNull
    public static <E> Seq<E> wrapJava(@NotNull List<? extends E> source) {
        Objects.requireNonNull(source);
        if (source instanceof AsJavaConvert.SeqAsJava) {
            return ((AsJavaConvert.SeqAsJava)source).source;
        }
        return source instanceof RandomAccess ? new FromJavaConvert.IndexedSeqFromJava<E>(source) : new FromJavaConvert.SeqFromJava<E>(source);
    }

    public static int hashCode(@NotNull Seq<?> seq) {
        return Iterators.hash((Iterator)seq.iterator()) + -1140647423;
    }

    public static boolean equals(@NotNull Seq<?> seq1, @NotNull AnySeq<?> seq2) {
        if (seq1 == seq2) {
            return true;
        }
        if (!seq1.canEqual(seq2) || !seq2.canEqual(seq1)) {
            return false;
        }
        return seq1.sameElements((Iterable)seq2.asGeneric());
    }

    @Override
    @NotNull
    default public String className() {
        return "Seq";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends Seq<U>> iterableFactory() {
        return Seq.factory();
    }

    @Override
    @NotNull
    default public SeqView<E> view() {
        return this.knownSize() == 0 ? SeqView.empty() : new SeqViews.Of(this);
    }

    @Override
    @NotNull
    default public @UnmodifiableView List<E> asJava() {
        return this.supportsFastRandomAccess() ? new AsJavaConvert.IndexedSeqAsJava(this) : new AsJavaConvert.SeqAsJava(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
        return this.view().slice(beginIndex, endIndex).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> drop(int n) {
        return this.view().drop(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> dropLast(int n) {
        return this.view().dropLast(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        return this.view().dropWhile(predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> take(int n) {
        return this.view().take(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> takeLast(int n) {
        return this.view().takeLast(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
        return this.view().takeWhile(predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> updated(int index, E newValue) {
        return this.view().updated(index, newValue).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
        return this.view().concat(other).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
        return this.view().concat(other).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> prepended(E value) {
        return this.view().prepended(value).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> prependedAll(E @NotNull [] values) {
        return this.view().prependedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> prependedAll(@NotNull Iterable<? extends E> values) {
        return this.view().prependedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> appended(E value) {
        return this.view().appended(value).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> appendedAll(@NotNull Iterable<? extends E> values) {
        return this.view().appendedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> appendedAll(E @NotNull [] values) {
        return this.view().appendedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> sorted() {
        return this.sorted(Comparators.naturalOrder());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> sorted(Comparator<? super E> comparator) {
        return this.view().sorted(comparator).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> reversed() {
        return this.view().reversed().toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> filter(@NotNull Predicate<? super E> predicate) {
        return this.view().filter((Predicate)predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <Ex extends Throwable> ImmutableSeq<E> filterChecked(@NotNull CheckedPredicate<? super E, ? extends Ex> predicate) throws Ex {
        return this.filter((Predicate)predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> filterUnchecked(@NotNull CheckedPredicate<? super E, ?> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return this.view().filterNot((Predicate)predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <Ex extends Throwable> ImmutableSeq<E> filterNotChecked(@NotNull CheckedPredicate<? super E, ? extends Ex> predicate) throws Ex {
        return this.filterNot((Predicate)predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableSeq<E> filterNotUnchecked(@NotNull CheckedPredicate<? super E, ?> predicate) {
        return this.filterNot((Predicate)predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public @NotNull ImmutableSeq<@NotNull E> filterNotNull() {
        return this.filter(Predicates.isNotNull());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.view().filterIsInstance((Class)clazz).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        return this.view().map((Function)mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U, Ex extends Throwable> ImmutableSeq<U> mapChecked(@NotNull CheckedFunction<? super E, ? extends U, ? extends Ex> mapper) throws Ex {
        return this.map((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapUnchecked(@NotNull CheckedFunction<? super E, ? extends U, ?> mapper) {
        return this.map((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        return this.view().mapIndexed(mapper).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <U, Ex extends Throwable> ImmutableSeq<U> mapIndexedChecked(@NotNull CheckedIndexedFunction<? super E, ? extends U, ? extends Ex> mapper) throws Ex {
        return this.mapIndexed((IndexedFunction)mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapIndexedUnchecked(@NotNull CheckedIndexedFunction<? super E, ? extends U, ?> mapper) {
        return this.mapIndexed((IndexedFunction)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        return this.view().mapNotNull((Function)mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U, Ex extends Throwable> ImmutableSeq<U> mapNotNullChecked(@NotNull CheckedFunction<? super E, ? extends U, ? extends Ex> mapper) throws Ex {
        return this.mapNotNull((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapNotNullUnchecked(@NotNull CheckedFunction<? super E, ? extends U, ?> mapper) {
        return this.mapNotNull((Function)mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        return this.view().mapIndexedNotNull(mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        return this.view().mapMulti((BiConsumer)mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        return this.view().mapIndexedMulti(mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        return this.view().flatMap((Function)mapper).toImmutableSeq();
    }
}

