/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Comparator;
import java.util.Iterator;
import kala.collection.Set;
import kala.collection.base.OrderedTraversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.convert.AsJavaConvert;
import kala.comparator.Comparators;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface SortedSet<E>
extends Set<E>,
OrderedTraversable<E> {
    @NotNull
    public <U> CollectionFactory<U, ?, ? extends SortedSet<U>> iterableFactory(Comparator<? super U> var1);

    @Override
    @NotNull
    default public java.util.SortedSet<E> asJava() {
        return new AsJavaConvert.SortedSetAsJava(this);
    }

    default public Comparator<? super E> comparator() {
        return Comparators.naturalOrder();
    }

    @Contract(pure=true)
    default public E first() {
        return this.iterator().next();
    }

    @Contract(pure=true)
    default public E last() {
        Iterator iterator = this.iterator();
        Object res = iterator.next();
        while (iterator.hasNext()) {
            res = iterator.next();
        }
        return res;
    }

    default public E max() {
        return this.last();
    }

    default public E min() {
        return this.first();
    }
}

