/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableCopyOnWriteSeqBase;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableCopyOnWriteList<E>
extends MutableCopyOnWriteSeqBase<E, MutableList<E>>
implements MutableList<E> {
    MutableCopyOnWriteList(MutableList<E> source, boolean exclusive) {
        super(source, exclusive);
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableCopyOnWriteList<E> create() {
        return new MutableCopyOnWriteList(new MutableArrayList(), true);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableCopyOnWriteList<E> create(@NotNull CollectionFactory<E, ?, ? extends MutableList<E>> factory) {
        return new MutableCopyOnWriteList<E>((MutableList)factory.empty(), true);
    }

    @Override
    @NotNull
    public String className() {
        return "MutableCopyOnWriteList";
    }

    @Override
    @NotNull
    public MutableCopyOnWriteList<E> clone() {
        this.exclusive = false;
        return new MutableCopyOnWriteList<E>((MutableList)this.source, false);
    }

    @Override
    public void append(E value) {
        this.ensureExclusive();
        ((MutableList)this.source).append(value);
    }

    @Override
    public void prepend(E value) {
        this.ensureExclusive();
        ((MutableList)this.source).prepend(value);
    }

    @Override
    public void insert(int index, E value) {
        this.ensureExclusive();
        ((MutableList)this.source).insert(index, value);
    }

    @Override
    public E removeAt(int index) {
        this.ensureExclusive();
        return ((MutableList)this.source).removeAt(index);
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        this.ensureExclusive();
        ((MutableList)this.source).removeInRange(beginIndex, endIndex);
    }

    @Override
    public void clear() {
        if (this.exclusive) {
            ((MutableList)this.source).clear();
        } else {
            this.exclusive = true;
            this.source = (MutableSeq)((MutableList)this.source).iterableFactory().empty();
        }
    }
}

