/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kala.Conditions;
import kala.collection.AbstractSeq;
import kala.collection.IndexedSeq;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.base.GenericArrays;
import kala.collection.base.ObjectArrays;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.internal.CollectionHelper;
import kala.collection.internal.view.SeqViews;
import kala.collection.mutable.MutableArrayList;
import kala.control.Option;
import kala.function.CheckedPredicate;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class ArraySeq<E>
extends AbstractSeq<E>
implements Seq<E>,
IndexedSeq<E>,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final ArraySeq<?> EMPTY = new ArraySeq(GenericArrays.EMPTY_OBJECT_ARRAY);
    private static final Factory<?> FACTORY = new Factory();
    protected final Object @NotNull [] elements;

    protected ArraySeq(Object @NotNull [] elements) {
        this.elements = elements;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> ArraySeq<E> narrow(ArraySeq<? extends E> seq) {
        return seq;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ? extends ArraySeq<E>> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> ArraySeq<E> wrap(@NotNull E[] array) {
        Objects.requireNonNull(array);
        return new ArraySeq<E>(array);
    }

    @NotNull
    public static <E> ArraySeq<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ArraySeq<E> of() {
        return ArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1) {
        return new ArraySeq<E>(new Object[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2) {
        return new ArraySeq<E>(new Object[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2, E value3) {
        return new ArraySeq<E>(new Object[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2, E value3, E value4) {
        return new ArraySeq<E>(new Object[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ArraySeq<E>(new Object[]{value1, value2, value3, value4, value5});
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> ArraySeq<E> of(E ... values) {
        return ArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ArraySeq<E> from(E @NotNull [] values) {
        return values.length == 0 ? ArraySeq.empty() : new ArraySeq<E>((Object[])values.clone());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Traversable<? extends E> values) {
        if (values instanceof ImmutableArray) {
            return (ArraySeq)values;
        }
        if (values.knownSize() == 0) {
            return ArraySeq.empty();
        }
        Object[] arr = values.toArray();
        if (arr.length == 0) {
            return ArraySeq.empty();
        }
        return new ArraySeq<E>(arr);
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Collection<? extends E> values) {
        return values.size() == 0 ? ArraySeq.empty() : new ArraySeq<E>(values.toArray());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values instanceof Traversable) {
            return ArraySeq.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return ArraySeq.from((Collection)values);
        }
        return new ArraySeq<E>(MutableArrayList.from(values).toArray());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ArraySeq.empty();
        }
        return new ArraySeq<E>(MutableArrayList.from(it).toArray());
    }

    @NotNull
    public static <E> ArraySeq<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ArraySeq.factory());
    }

    @NotNull
    public static <E> ArraySeq<E> fill(int n, E value) {
        if (n <= 0) {
            return ArraySeq.empty();
        }
        Object[] ans = new Object[n];
        if (value != null) {
            Arrays.fill(ans, value);
        }
        return new ArraySeq<E>(ans);
    }

    @NotNull
    public static <E> ArraySeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return ArraySeq.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.get();
        }
        return new ArraySeq<E>(ans);
    }

    @NotNull
    public static <E> ArraySeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return ArraySeq.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = init.apply(i);
        }
        return new ArraySeq<E>(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "ArraySeq";
    }

    @Override
    @NotNull
    public final Iterator<E> iterator() {
        return GenericArrays.iterator((Object[])this.elements);
    }

    @Override
    @NotNull
    public Iterator<E> iterator(int beginIndex) {
        return GenericArrays.iterator((Object[])this.elements, (int)beginIndex);
    }

    @NotNull
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 0);
    }

    @NotNull
    public final Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NotNull
    public final Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final Iterator<E> reverseIterator() {
        return GenericArrays.reverseIterator((Object[])this.elements);
    }

    @Override
    public final E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prepended(E value) {
        Object[] newValues = new Object[this.elements.length + 1];
        newValues[0] = value;
        System.arraycopy(this.elements, 0, newValues, 1, this.elements.length);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prependedAll(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableArray.empty();
        }
        Object[] newValues = Arrays.copyOf(values, values.length + this.elements.length, Object[].class);
        System.arraycopy(this.elements, 0, newValues, values.length, this.elements.length);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prependedAll(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Object[] data = values instanceof ImmutableArray ? ((ImmutableArray)((Object)values)).elements : CollectionHelper.asArray(values);
        Object[] newValues = new Object[data.length + this.elements.length];
        System.arraycopy(data, 0, newValues, 0, data.length);
        System.arraycopy(this.elements, 0, newValues, data.length, this.elements.length);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appended(E value) {
        Object[] elements = this.elements;
        int size = elements.length;
        Object[] newValues = Arrays.copyOf(elements, size + 1);
        newValues[size] = value;
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appendedAll(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableArray.empty();
        }
        Object[] elements = this.elements;
        int size = elements.length;
        Object[] newValues = Arrays.copyOf(elements, values.length + size);
        System.arraycopy(values, 0, newValues, size, values.length);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appendedAll(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Object[] data = values instanceof ImmutableArray ? ((ImmutableArray)((Object)values)).elements : CollectionHelper.asArray(values);
        Object[] newValues = Arrays.copyOf(this.elements, this.elements.length + data.length);
        System.arraycopy(data, 0, newValues, this.elements.length, data.length);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> slice(int beginIndex, int endIndex) {
        Object[] elements = this.elements;
        int size = elements.length;
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return ImmutableArray.empty();
        }
        if (ns == size) {
            return this.toImmutableArray();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOfRange(elements, beginIndex, endIndex));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this.toImmutableArray();
        }
        Object[] elements = this.elements;
        int size = elements.length;
        if (n >= size) {
            return ImmutableArray.empty();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOfRange(elements, n, size));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this.toImmutableArray();
        }
        return this.take(Integer.max(0, this.size() - n));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        int count;
        Object[] elements = this.elements;
        int size = elements.length;
        for (count = 0; count < size && predicate.test(elements[count]); ++count) {
        }
        return this.drop(count);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int size = this.elements.length;
        if (n == 0) {
            return ImmutableSeq.empty();
        }
        if (n >= size) {
            return this.toImmutableArray();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(this.elements, n));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableArray.empty();
        }
        return this.drop(Integer.max(0, this.size() - n));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeWhile(@NotNull Predicate<? super E> predicate) {
        int count;
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        for (count = 0; count < size && predicate.test(elements[count]); ++count) {
        }
        return this.take(count);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> updated(int index, E newValue) {
        Object[] elements = this.elements;
        int size = elements.length;
        Conditions.checkElementIndex((int)index, (int)size);
        Object[] newValues = (Object[])elements.clone();
        newValues[index] = newValue;
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> concat(@NotNull SeqLike<? extends E> other) {
        return this.appendedAll((Iterable)((Object)other));
    }

    @Override
    @NotNull
    public ImmutableSeq<E> concat(@NotNull List<? extends E> other) {
        return this.appendedAll(other);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> filter(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : this.elements) {
            Object v = value;
            if (!predicate.test(v)) continue;
            tmp[c++] = v;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this.toImmutableArray();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <Ex extends Throwable> ImmutableSeq<E> filterChecked(@NotNull CheckedPredicate<? super E, ? extends Ex> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> filterUnchecked(@NotNull CheckedPredicate<? super E, ?> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> filterNot(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            Object v = value;
            if (predicate.test(v)) continue;
            tmp[c++] = v;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this.toImmutableArray();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public @NotNull ImmutableSeq<@NotNull E> filterNotNull() {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            Object v = value;
            if (v == null) continue;
            tmp[c++] = v;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this.toImmutableArray();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            Object v = value;
            if (!clazz.isInstance(v)) continue;
            tmp[c++] = v;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return this.toImmutableArray();
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] newValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            newValues[i] = mapper.apply(elements[i]);
        }
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] newValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            newValues[i] = mapper.apply(i, elements[i]);
        }
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (Object value : elements) {
            U u = mapper.apply(value);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return ImmutableArray.Unsafe.wrap(tmp);
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> @NotNull ImmutableSeq<@NotNull U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] tmp = new Object[size];
        int c = 0;
        for (int i = 0; i < size; ++i) {
            Object u = mapper.apply(i, elements[i]);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == 0) {
            return ImmutableArray.empty();
        }
        if (c == size) {
            return ImmutableArray.Unsafe.wrap(tmp);
        }
        return ImmutableArray.Unsafe.wrap(Arrays.copyOf(tmp, c));
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        MutableArrayList builder = new MutableArrayList();
        Consumer<Object> consumer = builder::append;
        for (Object element : this.elements) {
            mapper.accept(element, consumer);
        }
        return builder.toImmutableArray();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        MutableArrayList builder = new MutableArrayList();
        Consumer<Object> consumer = builder::append;
        for (int i = 0; i < this.elements.length; ++i) {
            mapper.accept(i, this.elements[i], consumer);
        }
        return builder.toImmutableArray();
    }

    @Override
    @NotNull
    public <U> ImmutableSeq<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        MutableArrayList<? extends U> builder = new MutableArrayList<U>();
        for (Object value : elements) {
            builder.appendAll(mapper.apply(value));
        }
        return builder.toImmutableArray();
    }

    @Override
    @NotNull
    public ImmutableSeq<E> sorted() {
        Object[] elements = this.elements;
        if (elements.length == 0 || elements.length == 1) {
            return this.toImmutableArray();
        }
        Object[] newValues = (Object[])elements.clone();
        Arrays.sort(newValues);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> sorted(Comparator<? super E> comparator) {
        Object[] elements = this.elements;
        if (elements.length == 0 || elements.length == 1) {
            return this.toImmutableArray();
        }
        Object[] newValues = (Object[])elements.clone();
        Arrays.sort(newValues, comparator);
        return ImmutableArray.Unsafe.wrap(newValues);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> reversed() {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return ImmutableArray.empty();
        }
        Object[] res = new Object[size];
        for (int i = 0; i < size; ++i) {
            res[i] = elements[size - i - 1];
        }
        return ImmutableArray.Unsafe.wrap(res);
    }

    @Override
    @NotNull
    public <U, R> ImmutableSeq<R> zip(@NotNull Iterable<? extends U> other, @NotNull BiFunction<? super E, ? super U, ? extends R> mapper) {
        int i;
        Iterator<U> it = other.iterator();
        if (!it.hasNext()) {
            return ImmutableArray.empty();
        }
        Object[] elements = this.elements;
        int size = elements.length;
        Object[] tmp = new Object[size];
        for (i = 0; it.hasNext() && i < size; ++i) {
            tmp[i] = mapper.apply(elements[i], it.next());
        }
        if (i < size) {
            tmp = Arrays.copyOf(tmp, i);
        }
        return ImmutableArray.Unsafe.wrap(tmp);
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, E value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, E value, Comparator<? super E> comparator) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value, comparator);
    }

    @Override
    public final E first() {
        try {
            return (E)this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    @Nullable
    public E firstOrNull() {
        return (E)(this.elements.length != 0 ? this.elements[0] : null);
    }

    @Override
    @NotNull
    public Option<E> firstOption() {
        return this.elements.length != 0 ? Option.some((Object)this.elements[0]) : Option.none();
    }

    @Override
    public final E last() {
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return (E)elements[size - 1];
    }

    @Override
    @Nullable
    public E lastOrNull() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[this.elements.length - 1];
    }

    @Override
    @NotNull
    public Option<E> lastOption() {
        return this.elements.length != 0 ? Option.some((Object)this.elements[this.elements.length - 1]) : Option.none();
    }

    @Override
    public final boolean contains(Object value) {
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return false;
        }
        if (value == null) {
            for (Object e : elements) {
                if (null != e) continue;
                return true;
            }
        } else {
            for (Object e : elements) {
                if (!value.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean containsAll(@NotNull Iterable<?> values) {
        for (Object v : values) {
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean anyMatch(@NotNull Predicate<? super E> predicate) {
        for (Object e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean allMatch(@NotNull Predicate<? super E> predicate) {
        for (Object e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean noneMatch(@NotNull Predicate<? super E> predicate) {
        for (Object e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(Object value) {
        return GenericArrays.indexOf((Object[])this.elements, (Object)value);
    }

    @Override
    public final int indexOf(Object value, int from) {
        return GenericArrays.indexOf((Object[])this.elements, (Object)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull Predicate<? super E> predicate) {
        return GenericArrays.indexWhere((Object[])this.elements, predicate);
    }

    @Override
    public final int indexWhere(@NotNull Predicate<? super E> predicate, int from) {
        return GenericArrays.indexWhere((Object[])this.elements, predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(Object value) {
        return GenericArrays.lastIndexOf((Object[])this.elements, (Object)value);
    }

    @Override
    public final int lastIndexOf(Object value, int end) {
        return GenericArrays.lastIndexOf((Object[])this.elements, (Object)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
        return GenericArrays.lastIndexWhere((Object[])this.elements, predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull Predicate<? super E> predicate, int end) {
        return GenericArrays.lastIndexWhere((Object[])this.elements, predicate, (int)end);
    }

    @Override
    @NotNull
    public SeqView<E> sliceView(int beginIndex, int endIndex) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        int ns = endIndex - beginIndex;
        switch (ns) {
            case 0: {
                return SeqView.empty();
            }
            case 1: {
                return SeqView.of(this.elements[beginIndex]);
            }
        }
        return new SeqViews.OfArraySlice(this.elements, beginIndex, endIndex);
    }

    @Override
    public final int count(@NotNull Predicate<? super E> predicate) {
        int c = 0;
        for (Object e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final E max() {
        return (E)ObjectArrays.max((Object[])this.elements);
    }

    @Override
    public final E max(@NotNull Comparator<? super E> comparator) {
        return (E)GenericArrays.max((Object[])this.elements, comparator);
    }

    @NotNull
    public final Option<E> maxOption() {
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return Option.none();
        }
        return Option.some((Object)ObjectArrays.max((Object[])elements));
    }

    @NotNull
    public final Option<E> maxOption(@NotNull Comparator<? super E> comparator) {
        if (this.elements.length == 0) {
            return Option.none();
        }
        return Option.some(this.max(comparator));
    }

    public final E min() {
        return (E)ObjectArrays.min((Object[])this.elements);
    }

    @Override
    public final E min(@NotNull Comparator<? super E> comparator) {
        return (E)GenericArrays.min((Object[])this.elements, comparator);
    }

    @NotNull
    public final Option<E> minOption() {
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return Option.none();
        }
        return Option.some((Object)ObjectArrays.min((Object[])elements));
    }

    @NotNull
    public final Option<E> minOption(@NotNull Comparator<? super E> comparator) {
        if (this.elements.length == 0) {
            return Option.none();
        }
        return Option.some(this.min(comparator));
    }

    public final E fold(E zero, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return (E)GenericArrays.fold((Object[])this.elements, zero, op);
    }

    @Override
    public final <U> U foldLeft(U zero, @NotNull BiFunction<? super U, ? super E, ? extends U> op) {
        return (U)GenericArrays.foldLeft((Object[])this.elements, zero, op);
    }

    @Override
    public final <U> U foldRight(U zero, @NotNull BiFunction<? super E, ? super U, ? extends U> op) {
        return (U)GenericArrays.foldRight((Object[])this.elements, zero, op);
    }

    @Override
    public final E reduceLeft(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        return (E)GenericArrays.reduceLeft((Object[])this.elements, op);
    }

    @Override
    public final E reduceRight(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        return (E)GenericArrays.reduceRight((Object[])this.elements, op);
    }

    @NotNull
    public final Option<E> reduceLeftOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.reduceLeftOption((Object[])this.elements, op);
    }

    @NotNull
    public final Option<E> reduceRightOption(@NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.reduceRightOption((Object[])this.elements, op);
    }

    @Override
    public final int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        Object[] elements = this.elements;
        int dl = dest.length;
        int size = elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(elements, srcPos, dest, destPos, n);
        return n;
    }

    public final <R, Builder> R collect(@NotNull Collector<? super E, Builder, ? extends R> collector) {
        if (collector instanceof CollectionFactory) {
            return this.collect((CollectionFactory)collector);
        }
        Object[] elements = this.elements;
        Builder builder = collector.supplier().get();
        if (elements.length == 0) {
            return collector.finisher().apply(builder);
        }
        BiConsumer<Builder, E> accumulator = collector.accumulator();
        for (Object o : elements) {
            accumulator.accept(builder, o);
        }
        return collector.finisher().apply(builder);
    }

    public final <R, Builder> R collect(@NotNull CollectionFactory<? super E, Builder, ? extends R> factory) {
        Object[] elements = this.elements;
        int length = elements.length;
        if (length == 0) {
            return (R)factory.empty();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, length);
        for (Object e : elements) {
            factory.addToBuilder(builder, e);
        }
        return (R)factory.build(builder);
    }

    @Override
    public final Object @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length, Object[].class);
    }

    @Override
    public final <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        return Arrays.copyOf(this.elements, this.elements.length, GenericArrays.arrayType(type));
    }

    @Override
    public final <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        Object[] elements = this.elements;
        int size = elements.length;
        U[] res = generator.apply(size);
        if (size != 0) {
            System.arraycopy(elements, 0, res, 0, size);
        }
        return res;
    }

    @Override
    public final void forEach(@NotNull Consumer<? super E> action) {
        for (Object e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
        Object[] elements = this.elements;
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            action.accept(i, elements[i]);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        for (Object o : this.elements) {
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @Override
    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        Object[] elements = this.elements;
        int size = elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        Object[] elements = this.elements;
        int size = elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(transform.apply(elements[0]));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(transform.apply(elements[i]));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableArrayList<E>, ArraySeq<E>> {
        private Factory() {
        }

        public ArraySeq<E> empty() {
            return ArraySeq.empty();
        }

        public ArraySeq<E> from(E @NotNull [] values) {
            return ArraySeq.from(values);
        }

        public ArraySeq<E> from(@NotNull Iterable<? extends E> values) {
            return ArraySeq.from(values);
        }

        public ArraySeq<E> from(@NotNull Iterator<? extends E> it) {
            return ArraySeq.from(it);
        }

        public ArraySeq<E> fill(int n, E value) {
            return ArraySeq.fill(n, value);
        }

        public ArraySeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ArraySeq.fill(n, supplier);
        }

        public ArraySeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ArraySeq.fill(n, init);
        }

        public MutableArrayList<E> newBuilder() {
            return new MutableArrayList();
        }

        public void addToBuilder(@NotNull MutableArrayList<E> buffer, E value) {
            buffer.append(value);
        }

        public MutableArrayList<E> mergeBuilder(@NotNull MutableArrayList<E> builder1, @NotNull MutableArrayList<E> builder2) {
            builder1.appendAll((Iterable<E>)((Object)builder2));
            return builder1;
        }

        public void sizeHint(@NotNull MutableArrayList<E> buffer, int size) {
            buffer.sizeHint(size);
        }

        public ArraySeq<E> build(@NotNull MutableArrayList<E> buffer) {
            return new ArraySeq(buffer.toArray());
        }
    }
}

