/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import kala.Equatable;
import kala.collection.MapLike;
import kala.collection.base.MapIterator;
import kala.collection.factory.MapFactory;
import kala.collection.immutable.ImmutableMap;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.convert.FromJavaConvert;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public interface Map<K, V>
extends MapLike<K, V>,
Equatable {
    public static final int HASH_MAGIC = 124549981;

    public static int hashCode(@NotNull Map<?, ?> map) {
        return map.iterator().hash() + 124549981;
    }

    public static boolean equals(@NotNull Map<?, ?> map1, @NotNull Map<?, ?> map2) {
        if (!map1.canEqual(map2) || !map2.canEqual(map1)) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        MapIterator it = map1.iterator();
        try {
            while (it.hasNext()) {
                if (map2.contains(it.nextKey(), it.getValue())) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public static <K, V> MapFactory<K, V, ?, Map<K, V>> factory() {
        return ImmutableMap.factory();
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, Map<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(Map.factory(), keyMapper, valueMapper);
    }

    @NotNull
    public static <K, V> Map<K, V> empty() {
        return ImmutableMap.empty();
    }

    @NotNull
    public static <K, V> Map<K, V> of() {
        return Map.empty();
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1) {
        return ImmutableMap.of(k1, v1);
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, v1, k2, v2);
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3);
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    @NotNull
    public static <K, V> Map<K, V> of(Object ... values) {
        return ImmutableMap.of(values);
    }

    @NotNull
    public static <K, V> Map<K, V> ofEntries() {
        return Map.empty();
    }

    @NotNull
    public static <K, V> Map<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        return ImmutableMap.ofEntries(entry1);
    }

    @NotNull
    public static <K, V> Map<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        return ImmutableMap.ofEntries(entry1, entry2);
    }

    @NotNull
    public static <K, V> Map<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        return ImmutableMap.ofEntries(entry1, entry2, entry3);
    }

    @NotNull
    public static <K, V> Map<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        return ImmutableMap.ofEntries(entry1, entry2, entry3, entry4);
    }

    @NotNull
    public static <K, V> Map<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        return ImmutableMap.ofEntries(entry1, entry2, entry3, entry4, entry5);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        return ImmutableMap.ofEntries(entries);
    }

    @NotNull
    public static <K, V> Map<K, V> from(@NotNull java.util.Map<? extends K, ? extends V> values) {
        return ImmutableMap.from(values);
    }

    @NotNull
    public static <K, V> Map<K, V> from(@NotNull MapLike<? extends K, ? extends V> values) {
        return ImmutableMap.from(values);
    }

    @NotNull
    public static <K, V> Map<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        return ImmutableMap.from(values);
    }

    @NotNull
    public static <K, V> Map<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        return ImmutableMap.from(values);
    }

    public static <K, V> Map<K, V> wrapJava(@NotNull @UnmodifiableView java.util.Map<K, V> map) {
        Objects.requireNonNull(map);
        if (map instanceof AsJavaConvert.MapAsJava) {
            return (Map)((Object)map);
        }
        return new FromJavaConvert.MapFromJava<K, V>(map);
    }

    @Override
    @NotNull
    default public String className() {
        return "Map";
    }

    @NotNull
    default public <NK, NV> MapFactory<NK, NV, ?, ? extends Map<NK, NV>> mapFactory() {
        return Map.factory();
    }

    default public @NotNull @UnmodifiableView java.util.Map<K, V> asJava() {
        return new AsJavaConvert.MapAsJava(this);
    }

    default public boolean canEqual(Object other) {
        return other instanceof Map;
    }
}

