/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import kala.collection.CollectionView;
import kala.collection.MapView;
import kala.collection.SetView;
import kala.collection.base.Growable;
import kala.collection.base.MapIterator;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableLinkedSeq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableVector;
import kala.collection.internal.view.MapViews;
import kala.control.Option;
import kala.function.CheckedBiConsumer;
import kala.internal.MapBase;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MapLike<K, V>
extends MapBase<K, V> {
    @NotNull
    default public String className() {
        return "MapLike";
    }

    @NotNull
    default public MapView<K, V> view() {
        return new MapViews.Of(this);
    }

    @NotNull
    default public SetView<K> keysView() {
        return new MapViews.Keys(this);
    }

    @NotNull
    default public CollectionView<V> valuesView() {
        return new MapViews.Values(this);
    }

    @NotNull
    public MapIterator<K, V> iterator();

    default public boolean isEmpty() {
        int ks = this.knownSize();
        if (ks < 0) {
            return !this.iterator().hasNext();
        }
        return ks == 0;
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public int size() {
        int ks = this.knownSize();
        if (ks >= 0) {
            return ks;
        }
        int c = 0;
        MapIterator<K, V> it = this.iterator();
        while (it.hasNext()) {
            it.nextKey();
            ++c;
        }
        return c;
    }

    default public int knownSize() {
        return -1;
    }

    default public V get(K key) {
        return (V)this.getOption(key).get();
    }

    @Nullable
    default public V getOrNull(K key) {
        return (V)this.getOption(key).getOrNull();
    }

    @NotNull
    default public Option<V> getOption(K key) {
        MapIterator<K, V> it = this.iterator();
        if (key == null) {
            while (it.hasNext()) {
                if (null != it.nextKey()) continue;
                return Option.some((Object)it.getValue());
            }
        } else {
            while (it.hasNext()) {
                if (!key.equals(it.nextKey())) continue;
                return Option.some((Object)it.getValue());
            }
        }
        return Option.none();
    }

    default public V getOrDefault(K key, V defaultValue) {
        return (V)this.getOption(key).getOrDefault(defaultValue);
    }

    default public V getOrElse(K key, @NotNull Supplier<? extends V> supplier) {
        return (V)this.getOption(key).getOrElse(supplier);
    }

    default public <Ex extends Throwable> V getOrThrowException(K key, @NotNull Ex exception) throws Ex {
        return (V)this.getOption(key).getOrThrowException(exception);
    }

    default public <Ex extends Throwable> V getOrThrow(K key, @NotNull Supplier<? extends Ex> supplier) throws Ex {
        return (V)this.getOption(key).getOrThrow(supplier);
    }

    default public boolean contains(Tuple2<? extends K, ?> value) {
        return value != null && this.contains(value._1, value._2);
    }

    default public boolean contains(K key, Object value) {
        return this.getOption(key).contains(value);
    }

    default public boolean containsKey(K key) {
        if (this.knownSize() == 0) {
            return false;
        }
        return this.iterator().containsKey(key);
    }

    default public boolean containsValue(Object value) {
        if (this.knownSize() == 0) {
            return false;
        }
        return this.iterator().containsValue(value);
    }

    default public boolean anyMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        if (this.knownSize() == 0) {
            return false;
        }
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        if (this.knownSize() == 0) {
            return true;
        }
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        if (this.knownSize() == 0) {
            return true;
        }
        return this.iterator().noneMatch(predicate);
    }

    @NotNull
    default public <R, G extends Growable<? super R>> G mapTo(@NotNull G destination, @NotNull BiFunction<? super K, ? super V, ? extends R> mapper) {
        this.forEach((k, v) -> destination.plusAssign(mapper.apply((Object)k, (Object)v)));
        return destination;
    }

    @NotNull
    default public MapView.WithDefault<K, V> withDefault(@NotNull Function<? super K, ? extends V> defaultFunction) {
        Objects.requireNonNull(defaultFunction);
        return new MapViews.WithDefaultImpl<K, V, MapLike>(this, defaultFunction);
    }

    @NotNull
    default public ImmutableMap<K, V> toImmutableMap() {
        return ImmutableMap.from(this);
    }

    @NotNull
    default public ImmutableSeq<Tuple2<K, V>> toImmutableSeq() {
        return ImmutableSeq.from(this.iterator());
    }

    @NotNull
    default public ImmutableArray<Tuple2<K, V>> toImmutableArray() {
        return ImmutableArray.from(this.toArray());
    }

    @NotNull
    default public ImmutableLinkedSeq<Tuple2<K, V>> toImmutableLinkedSeq() {
        return ImmutableLinkedSeq.from(this.iterator());
    }

    @NotNull
    default public ImmutableVector<Tuple2<K, V>> toImmutableVector() {
        return ImmutableVector.from(this.iterator());
    }

    @NotNull
    default public Tuple2<K, V>[] toArray() {
        int size = this.size();
        Tuple2[] res = new Tuple2[size];
        MapIterator<K, V> it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.next();
        }
        return res;
    }

    default public void forEach(@NotNull BiConsumer<? super K, ? super V> consumer) {
        MapIterator<K, V> it = this.iterator();
        while (it.hasNext()) {
            consumer.accept(it.nextKey(), it.getValue());
        }
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedBiConsumer<? super K, ? super V, ? extends Ex> consumer) throws Ex {
        this.forEach((BiConsumer<? super K, ? super V>)consumer);
    }

    default public void forEachUnchecked(@NotNull CheckedBiConsumer<? super K, ? super V, ?> consumer) {
        this.forEach((BiConsumer<? super K, ? super V>)consumer);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer) {
        return this.joinTo(buffer, ", ");
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator) {
        return this.joinTo(buffer, separator, "", "");
    }

    @Contract(value="_, _, _, _ -> param1", mutates="param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        if (this.knownSize() == 0) {
            try {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (A)this.iterator().joinTo(buffer, separator, prefix, postfix);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(buffer, ", ", transform);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(buffer, separator, "", "", transform);
    }

    @Contract(value="_, _, _, _, _ -> param1", mutates="param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        if (this.knownSize() == 0) {
            try {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (A)this.iterator().joinTo(buffer, separator, prefix, postfix, transform);
    }

    @NotNull
    default public String joinToString() {
        return this.joinTo(new StringBuilder()).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator) {
        return this.joinTo(new StringBuilder(), separator).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    default public String joinToString(@NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), transform).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix, transform).toString();
    }
}

