/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.AbstractCollection;
import kala.collection.base.AnyTraversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableCollection;
import kala.tuple.Tuple;
import kala.tuple.Tuple3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableCollection<E>
extends AbstractCollection<E>
implements ImmutableCollection<E> {
    static <E, T, Builder> T filter(@NotNull ImmutableCollection<? extends E> collection, @NotNull Predicate<? super E> predicate, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!predicate.test(e)) continue;
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T filterNot(@NotNull ImmutableCollection<? extends E> collection, @NotNull Predicate<? super E> predicate, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (predicate.test(e)) continue;
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T map(@NotNull ImmutableCollection<? extends E> collection, @NotNull Function<? super E, ? extends U> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            factory.addToBuilder(builder, mapper.apply(e));
        }
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T mapNotNull(@NotNull ImmutableCollection<? extends E> collection, @NotNull Function<? super E, ? extends U> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            U u = mapper.apply(e);
            if (u == null) continue;
            factory.addToBuilder(builder, u);
        }
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T mapMulti(@NotNull ImmutableCollection<? extends E> collection, @NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        Consumer<Object> consumer = u -> factory.addToBuilder(builder, u);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            mapper.accept(e, consumer);
        }
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T flatMap(@NotNull ImmutableCollection<? extends E> collection, @NotNull Function<? super E, ? extends Iterable<? extends U>> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterable<U> us = mapper.apply(e);
            factory.sizeHint(builder, us);
            for (U u : us) {
                factory.addToBuilder(builder, u);
            }
        }
        return (T)factory.build(builder);
    }

    static <E, U, R, T, Builder> T zip(@NotNull ImmutableCollection<? extends E> collection, @NotNull Iterable<? extends U> other, @NotNull BiFunction<? super E, ? super U, ? extends R> mapper, @NotNull CollectionFactory<? super R, Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(mapper);
        if (AnyTraversable.knownSize(collection) == 0 || AnyTraversable.knownSize(other) == 0) {
            return (T)factory.empty();
        }
        Object builder = factory.newBuilder();
        Iterator it1 = collection.iterator();
        Iterator<U> it2 = other.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            factory.addToBuilder(builder, mapper.apply(it1.next(), it2.next()));
        }
        return (T)factory.build(builder);
    }

    static <E, U, V, T, Builder> T zip3(@NotNull ImmutableCollection<? extends E> collection, @NotNull Iterable<? extends U> other1, @NotNull Iterable<? extends V> other2, @NotNull CollectionFactory<? super Tuple3<E, U, V>, Builder, ? extends T> factory) {
        Objects.requireNonNull(other1);
        Objects.requireNonNull(other2);
        if (AnyTraversable.knownSize(collection) == 0 || AnyTraversable.knownSize(other1) == 0 || AnyTraversable.knownSize(other2) == 0) {
            return (T)factory.empty();
        }
        Object builder = factory.newBuilder();
        Iterator it1 = collection.iterator();
        Iterator<U> it2 = other1.iterator();
        Iterator<V> it3 = other2.iterator();
        while (it1.hasNext() && it2.hasNext() && it3.hasNext()) {
            factory.addToBuilder(builder, (Object)Tuple.of(it1.next(), it2.next(), it3.next()));
        }
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T distinct(@NotNull ImmutableCollection<? extends E> collection, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        if (AnyTraversable.knownSize(collection) == 0) {
            return (T)factory.empty();
        }
        Object builder = factory.newBuilder();
        HashSet set = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!set.add(e)) continue;
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }
}

