/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kala.Conditions;
import kala.collection.AbstractSeq;
import kala.collection.SeqLike;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSeq;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
public abstract class AbstractImmutableSeq<E>
extends AbstractSeq<E>
implements ImmutableSeq<E> {
    static <E, T, Builder> T updated(@NotNull ImmutableSeq<? extends E> seq, int index, E newValue, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        Iterator iterator = seq.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T slice(@NotNull ImmutableSeq<? extends E> seq, int beginIndex, int endIndex, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            Iterator it = seq.iterator(beginIndex);
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.next());
            }
        }
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T drop(@NotNull ImmutableSeq<? extends E> seq, int n, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        Iterator it = Iterators.drop((Iterator)seq.iterator(), (int)n);
        while (it.hasNext()) {
            Object e = it.next();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T dropLast(@NotNull ImmutableSeq<? extends E> seq, int n, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            Iterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.next());
            }
        }
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T dropWhile(@NotNull ImmutableSeq<? extends E> seq, @NotNull Predicate<? super E> predicate, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, Iterators.dropWhile((Iterator)seq.iterator(), predicate));
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T take(@NotNull ImmutableSeq<? extends E> seq, int n, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        Iterator iterator = seq.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (++count > n) break;
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T takeLast(@NotNull ImmutableSeq<? extends E> seq, int n, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            Iterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.next();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.next());
            }
        }
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T takeWhile(@NotNull ImmutableSeq<? extends E> seq, @NotNull Predicate<? super E> predicate, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object e;
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        Iterator iterator = seq.iterator();
        while (iterator.hasNext() && predicate.test(e = iterator.next())) {
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T concat(@NotNull ImmutableSeq<? extends E> seq, @NotNull SeqLike<? extends E> other, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq);
        factory.addAllToBuilder(builder, seq);
        factory.sizeHint(builder, other);
        factory.addAllToBuilder(builder, other);
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T extends ImmutableSeq<? extends E>, Builder> T concat(@NotNull ImmutableSeq<? extends E> seq, @NotNull List<? extends E> other, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq);
        factory.addAllToBuilder(builder, seq);
        factory.sizeHint(builder, other);
        factory.addAllToBuilder(builder, other);
        return (T)((ImmutableSeq)factory.build(builder));
    }

    static <E, T, Builder> T prepended(@NotNull ImmutableSeq<? extends E> seq, E element, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, seq);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T prependedAll(@NotNull ImmutableSeq<? extends E> seq, E @NotNull [] values, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (E e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, seq);
        factory.addAllToBuilder(builder, seq);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T prependedAll(@NotNull ImmutableSeq<? extends E> seq, @NotNull Iterable<? extends E> values, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, seq);
        factory.addAllToBuilder(builder, seq);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T appended(@NotNull ImmutableSeq<? extends E> seq, E element, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq, 1);
        factory.addAllToBuilder(builder, seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T appendedAll(@NotNull ImmutableSeq<? extends E> seq, E @NotNull [] values, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq, values.length);
        factory.addAllToBuilder(builder, seq);
        for (E e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T appendedAll(@NotNull ImmutableSeq<? extends E> seq, @NotNull Iterable<? extends E> values, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq);
        factory.addAllToBuilder(builder, seq);
        factory.sizeHint(builder, values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T sorted(@NotNull ImmutableSeq<? extends E> seq, @NotNull Comparator<? super E> comparator, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object[] arr = seq.toArray();
        Arrays.sort(arr, comparator);
        return (T)factory.from(arr);
    }

    static <E, T, Builder> T reversed(@NotNull ImmutableSeq<? extends E> seq, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T mapIndexed(@NotNull ImmutableSeq<? extends E> Seq6, @NotNull IndexedFunction<? super E, ? extends U> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, Seq6);
        int idx = 0;
        Iterator iterator = Seq6.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            factory.addToBuilder(builder, mapper.apply(idx++, e));
        }
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T mapIndexedNotNull(@NotNull ImmutableSeq<? extends E> Seq6, @NotNull IndexedFunction<? super E, ? extends U> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, Seq6);
        int idx = 0;
        Iterator iterator = Seq6.iterator();
        while (iterator.hasNext()) {
            Object u;
            Object e = iterator.next();
            if ((u = mapper.apply(idx++, e)) == null) continue;
            factory.addToBuilder(builder, u);
        }
        return (T)factory.build(builder);
    }

    static <E, U, T, Builder> T mapIndexedMulti(@NotNull ImmutableSeq<? extends E> Seq6, @NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper, @NotNull CollectionFactory<? super U, Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        Consumer<Object> consumer = u -> factory.addToBuilder(builder, u);
        int idx = 0;
        Iterator iterator = Seq6.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            mapper.accept(idx++, e, consumer);
        }
        return (T)factory.build(builder);
    }
}

