/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Iterator;
import kala.collection.AbstractSet;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableHashSet;
import kala.collection.immutable.ImmutableSet;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
public abstract class AbstractImmutableSet<E>
extends AbstractSet<E>
implements ImmutableSet<E> {
    static <E, T, Builder> T added(@NotNull ImmutableSet<? extends E> set, E value, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, set, 1);
        factory.addAllToBuilder(builder, set);
        factory.addToBuilder(builder, value);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T addedAll(@NotNull ImmutableSet<? extends E> set, @NotNull Iterable<? extends E> values, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, set);
        factory.addAllToBuilder(builder, set);
        factory.sizeHint(builder, values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T removed(@NotNull ImmutableSet<? extends E> set, E value, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, set, -1);
        if (value == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (null == e) continue;
                factory.addToBuilder(builder, e);
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (value.equals(e)) continue;
                factory.addToBuilder(builder, e);
            }
        }
        return (T)factory.build(builder);
    }

    static <E, T, Builder> T removedAll(@NotNull ImmutableSet<? extends E> set, @NotNull Iterable<? extends E> values, @NotNull CollectionFactory<? super E, Builder, ? extends T> factory) {
        ImmutableHashSet<E> s = ImmutableHashSet.from(values);
        Object builder = factory.newBuilder();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (s.contains(e)) continue;
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }
}

