/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kala.collection.MapLike;
import kala.collection.base.MapIterator;
import kala.collection.factory.MapFactory;
import kala.collection.immutable.AbstractImmutableMap;
import kala.collection.mutable.MutableHashMap;
import kala.control.Option;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableHashMap<K, V>
extends AbstractImmutableMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 4088221143962926192L;
    private static final ImmutableHashMap<?, ?> EMPTY = new ImmutableHashMap(new MutableHashMap());
    private static final Factory<?, ?> FACTORY = new Factory();
    final MutableHashMap<K, V> source;

    private ImmutableHashMap(MutableHashMap<K, V> source) {
        this.source = source;
    }

    @NotNull
    public static <K, V> MapFactory<K, V, ?, ImmutableHashMap<K, V>> factory() {
        return FACTORY;
    }

    @NotNull
    static <T, K, V> Collector<T, ?, ImmutableHashMap<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(ImmutableHashMap.factory(), keyMapper, valueMapper);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> empty() {
        return EMPTY;
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of() {
        return ImmutableHashMap.empty();
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of(K k1, V v1) {
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.set(k1, v1);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.set(k1, v1);
        impl.set(k2, v2);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.set(k1, v1);
        impl.set(k2, v2);
        impl.set(k3, v3);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.set(k1, v1);
        impl.set(k2, v2);
        impl.set(k3, v3);
        impl.set(k4, v4);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.set(k1, v1);
        impl.set(k2, v2);
        impl.set(k3, v3);
        impl.set(k4, v4);
        impl.set(k5, v5);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> of(Object ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (values.length == 0) {
            return ImmutableHashMap.empty();
        }
        MutableHashMap<Object, Object> impl = new MutableHashMap<Object, Object>();
        for (int i = 0; i < values.length; i += 2) {
            impl.set(values[i], values[i + 1]);
        }
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries() {
        return ImmutableHashMap.empty();
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        MutableHashMap impl = new MutableHashMap();
        impl.set(entry1);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        MutableHashMap impl = new MutableHashMap();
        impl.set(entry1);
        impl.set(entry2);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        MutableHashMap impl = new MutableHashMap();
        impl.set(entry1);
        impl.set(entry2);
        impl.set(entry3);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        MutableHashMap impl = new MutableHashMap();
        impl.set(entry1);
        impl.set(entry2);
        impl.set(entry3);
        impl.set(entry4);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        MutableHashMap impl = new MutableHashMap();
        impl.set(entry1);
        impl.set(entry2);
        impl.set(entry3);
        impl.set(entry4);
        impl.set(entry5);
        return new ImmutableHashMap(impl);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> ImmutableHashMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        MutableHashMap impl = new MutableHashMap();
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            impl.set(entry);
        }
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> from(@NotNull Map<? extends K, ? extends V> values) {
        if (values.isEmpty()) {
            return ImmutableHashMap.empty();
        }
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.putAll(values);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> from(@NotNull MapLike<? extends K, ? extends V> values) {
        if (values.isEmpty()) {
            return ImmutableHashMap.empty();
        }
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        impl.putAll(values);
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableHashMap.empty();
        }
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        for (Map.Entry<K, V> entry : values) {
            impl.set(entry.getKey(), entry.getValue());
        }
        return new ImmutableHashMap(impl);
    }

    @NotNull
    public static <K, V> ImmutableHashMap<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        Iterator<Map.Entry<K, V>> it = values.iterator();
        if (!it.hasNext()) {
            return ImmutableHashMap.empty();
        }
        MutableHashMap<K, V> impl = new MutableHashMap<K, V>();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            impl.set(entry.getKey(), entry.getValue());
        }
        return new ImmutableHashMap(impl);
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableHashMap";
    }

    @Override
    @NotNull
    public MapIterator<K, V> iterator() {
        return this.source.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public int knownSize() {
        return this.source.knownSize();
    }

    @Override
    public V get(K key) {
        return this.source.get(key);
    }

    @Override
    @Nullable
    public V getOrNull(K key) {
        return this.source.getOrNull(key);
    }

    @Override
    @NotNull
    public Option<V> getOption(K key) {
        return this.source.getOption(key);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        return this.source.getOrDefault(key, defaultValue);
    }

    @Override
    public V getOrElse(K key, @NotNull Supplier<? extends V> supplier) {
        return this.source.getOrElse(key, supplier);
    }

    @Override
    public <Ex extends Throwable> V getOrThrow(K key, @NotNull Supplier<? extends Ex> supplier) throws Ex {
        return this.source.getOrThrow(key, supplier);
    }

    @Override
    public <Ex extends Throwable> V getOrThrowException(K key, @NotNull Ex exception) throws Ex {
        return this.source.getOrThrowException(key, exception);
    }

    @Override
    public boolean contains(K key, Object value) {
        return this.source.contains(key, value);
    }

    @Override
    public boolean containsKey(K key) {
        return this.source.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.source.containsValue(value);
    }

    @Override
    public boolean anyMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        return this.source.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        return this.source.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        return this.source.noneMatch(predicate);
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super K, ? super V> consumer) {
        this.source.forEach(consumer);
    }

    @Override
    @NotNull
    public ImmutableHashMap<K, V> putted(K key, V value) {
        if (this.source.contains(key, value)) {
            return this;
        }
        Object nm = this.source.clone();
        ((MutableHashMap)nm).put(key, value);
        return new ImmutableHashMap<K, V>(nm);
    }

    @Override
    @NotNull
    public ImmutableHashMap<K, V> removed(K key) {
        if (!this.source.containsKey(key)) {
            return this;
        }
        Object nm = this.source.clone();
        ((MutableHashMap)nm).remove(key);
        return nm.isEmpty() ? ImmutableHashMap.empty() : new ImmutableHashMap<K, V>(nm);
    }

    private static final class Factory<K, V>
    implements MapFactory<K, V, Builder<K, V>, ImmutableHashMap<K, V>> {
        private Factory() {
        }

        public Builder<K, V> newBuilder() {
            return new Builder();
        }

        public ImmutableHashMap<K, V> build(Builder<K, V> builder) {
            return builder.build();
        }

        public void addToBuilder(Builder<K, V> builder, K key, V value) {
            builder.add(key, value);
        }

        public Builder<K, V> mergeBuilder(Builder<K, V> builder1, Builder<K, V> builder2) {
            return builder1.merge(builder2);
        }

        public void sizeHint(@NotNull Builder<K, V> builder, int size) {
            builder.sizeHint(size);
        }
    }

    static final class Builder<K, V> {
        MutableHashMap<K, V> source = new MutableHashMap();
        boolean aliased = false;

        Builder() {
        }

        private void ensureUnaliased() {
            if (this.aliased) {
                this.source = this.source.clone();
            }
        }

        void add(K key, V value) {
            this.ensureUnaliased();
            this.source.set(key, value);
        }

        Builder<K, V> merge(Builder<K, V> other) {
            this.ensureUnaliased();
            this.source.putAll(other.source);
            return this;
        }

        void sizeHint(int size) {
            this.ensureUnaliased();
            this.source.sizeHint(size);
        }

        ImmutableHashMap<K, V> build() {
            if (this.source.isEmpty()) {
                return ImmutableHashMap.empty();
            }
            this.aliased = true;
            return new ImmutableHashMap(this.source);
        }
    }
}

