/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import kala.collection.Map;
import kala.collection.MapLike;
import kala.collection.factory.MapFactory;
import kala.collection.immutable.AbstractImmutableMap;
import kala.collection.immutable.ImmutableHashMap;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public interface ImmutableMap<K, V>
extends Map<K, V> {
    @NotNull
    public static <K, V> MapFactory<K, V, ?, ImmutableMap<K, V>> factory() {
        return ImmutableHashMap.factory();
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(ImmutableMap.factory(), keyMapper, valueMapper);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> empty() {
        return ImmutableHashMap.empty();
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of() {
        return ImmutableMap.empty();
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        return ImmutableHashMap.of(k1, v1);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableHashMap.of(k1, v1, k2, v2);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableHashMap.of(k1, v1, k2, v2, k3, v3);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableHashMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableHashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> of(Object ... values) {
        return ImmutableHashMap.of(values);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries() {
        return ImmutableMap.empty();
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        return ImmutableHashMap.ofEntries(entry1);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        return ImmutableHashMap.ofEntries(entry1, entry2);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        return ImmutableHashMap.ofEntries(entry1, entry2, entry3);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        return ImmutableHashMap.ofEntries(entry1, entry2, entry3, entry4);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        return ImmutableHashMap.ofEntries(entry1, entry2, entry3, entry4, entry5);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> ImmutableMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        return ImmutableHashMap.ofEntries(entries);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> from(@NotNull java.util.Map<? extends K, ? extends V> values) {
        return ImmutableHashMap.from(values);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> from(@NotNull MapLike<? extends K, ? extends V> values) {
        return ImmutableHashMap.from(values);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        return ImmutableHashMap.from(values);
    }

    @NotNull
    public static <K, V> ImmutableMap<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        return ImmutableHashMap.from(values);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableMap";
    }

    @Override
    @NotNull
    default public <NK, NV> MapFactory<NK, NV, ?, ? extends ImmutableMap<NK, NV>> mapFactory() {
        return ImmutableMap.factory();
    }

    @NotNull
    default public ImmutableMap<K, V> putted(K key, V value) {
        return AbstractImmutableMap.putted(this, key, value, this.mapFactory());
    }

    @NotNull
    default public ImmutableMap<K, V> removed(K key) {
        return AbstractImmutableMap.removed(this, key, this.mapFactory());
    }

    @Override
    @NotNull
    default public ImmutableMap<K, V> toImmutableMap() {
        return this;
    }
}

