/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kala.collection.SortedSet;
import kala.collection.base.GenericArrays;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableSortedSet;
import kala.collection.mutable.MutableTreeSet;
import kala.internal.ComparableUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableSortedArraySet<E>
extends AbstractImmutableSortedSet<E>
implements Serializable {
    private static final long serialVersionUID = 418132517516968465L;
    private static final Factory<? extends Comparable<?>> DEFAULT_FACTORY = new Factory(null);
    @Nullable
    final Comparator<? super E> comparator;
    final Object[] elements;

    ImmutableSortedArraySet(Object[] elements) {
        this(null, elements);
    }

    ImmutableSortedArraySet(@Nullable Comparator<? super E> comparator, Object[] elements) {
        this.comparator = comparator;
        this.elements = elements;
    }

    @NotNull
    public static <E extends Comparable<? super E>> CollectionFactory<E, ?, ImmutableSortedArraySet<E>> factory() {
        return DEFAULT_FACTORY;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableSortedArraySet<E>> factory(Comparator<? super E> comparator) {
        return comparator == null ? DEFAULT_FACTORY : new Factory<E>(comparator);
    }

    @Contract
    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> empty() {
        return DEFAULT_FACTORY.empty();
    }

    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> of() {
        return ImmutableSortedArraySet.empty();
    }

    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> of(@NotNull E value1) {
        Objects.requireNonNull(value1);
        return new ImmutableSortedArraySet<E>(new Object[]{value1});
    }

    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> of(@NotNull E value1, @NotNull E value2) {
        int c = value1.compareTo(Objects.requireNonNull(value2));
        if (c < 0) {
            return new ImmutableSortedArraySet<E>(new Object[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedArraySet<E>(new Object[]{value2, value1});
        }
        return new ImmutableSortedArraySet<E>(new Object[]{value1});
    }

    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> of(@NotNull E value1, @NotNull E value2, @NotNull E value3) {
        MutableTreeSet s = new MutableTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedArraySet<E>(s.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> of(@NotNull E value1, @NotNull E value2, @NotNull E value3, @NotNull E value4) {
        MutableTreeSet s = new MutableTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedArraySet<E>(s.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> @NotNull ImmutableSortedArraySet<@NotNull E> of(@NotNull E value1, @NotNull E value2, @NotNull E value3, @NotNull E value4, @NotNull E value5) {
        MutableTreeSet s = new MutableTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedArraySet<E>(s.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> ImmutableSortedArraySet<E> of(E ... values) {
        return ImmutableSortedArraySet.from(values);
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> empty(Comparator<? super E> comparator) {
        return comparator == null ? ImmutableSortedArraySet.empty() : new ImmutableSortedArraySet<E>(comparator, GenericArrays.EMPTY_OBJECT_ARRAY);
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator) {
        return ImmutableSortedArraySet.empty(comparator);
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator, E value1) {
        if (comparator == null) {
            if (!(value1 instanceof Comparable)) {
                if (value1 == null) {
                    throw new NullPointerException();
                }
                Comparable.class.cast(value1);
            }
        } else {
            comparator.compare(value1, value1);
        }
        return new ImmutableSortedArraySet<E>(comparator, new Object[]{value1});
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator, E value1, E value2) {
        int c = comparator == null ? ComparableUtils.compare(value1, value2) : comparator.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedArraySet<E>(comparator, new Object[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedArraySet<E>(comparator, new Object[]{value2, value1});
        }
        return new ImmutableSortedArraySet<E>(comparator, new Object[]{value1});
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator, E value1, E value2, E value3) {
        MutableTreeSet<? super E> s = new MutableTreeSet<E>(comparator);
        s.add((E)value1);
        s.add((E)value2);
        s.add((E)value3);
        return s.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet<E>(comparator, s.toArray());
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator, E value1, E value2, E value3, E value4) {
        MutableTreeSet<? super E> s = new MutableTreeSet<E>(comparator);
        s.add((E)value1);
        s.add((E)value2);
        s.add((E)value3);
        s.add((E)value4);
        return s.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet<E>(comparator, s.toArray());
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator, E value1, E value2, E value3, E value4, E value5) {
        MutableTreeSet<? super E> s = new MutableTreeSet<E>(comparator);
        s.add((E)value1);
        s.add((E)value2);
        s.add((E)value3);
        s.add((E)value4);
        s.add((E)value5);
        return s.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet<E>(comparator, s.toArray());
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> of(Comparator<? super E> comparator, E ... values) {
        return ImmutableSortedArraySet.from(comparator, values);
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> from(@NotNull SortedSet<? extends E> values) {
        Comparator<? extends E> comparator = values.comparator();
        return values.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet<E>(comparator, values.toArray());
    }

    @NotNull
    public static <E> ImmutableSortedArraySet<E> from(@NotNull java.util.SortedSet<? extends E> values) {
        Comparator<? extends E> comparator = values.comparator();
        return values.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet<E>(comparator, values.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> ImmutableSortedArraySet<E> from(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedArraySet.empty();
        }
        MutableTreeSet s = new MutableTreeSet();
        s.addAll(values);
        return new ImmutableSortedArraySet<E>(s.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> ImmutableSortedArraySet<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values instanceof SortedSet) {
            SortedSet vs = (SortedSet)((Object)values);
            Comparator comparator = vs.comparator();
            return vs.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet(comparator, vs.toArray());
        }
        if (values instanceof java.util.SortedSet) {
            java.util.SortedSet vs = (java.util.SortedSet)values;
            Comparator comparator = vs.comparator();
            return vs.isEmpty() ? ImmutableSortedArraySet.empty(comparator) : new ImmutableSortedArraySet(comparator, vs.toArray());
        }
        Iterator<E> it = values.iterator();
        if (!it.hasNext()) {
            return ImmutableSortedArraySet.empty();
        }
        MutableTreeSet s = new MutableTreeSet();
        while (it.hasNext()) {
            s.add((Comparable)it.next());
        }
        return new ImmutableSortedArraySet<E>(s.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> ImmutableSortedArraySet<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableSortedArraySet.empty();
        }
        MutableTreeSet s = new MutableTreeSet();
        while (it.hasNext()) {
            s.add((Comparable)it.next());
        }
        return new ImmutableSortedArraySet<E>(s.toArray());
    }

    @NotNull
    public static <E extends Comparable<? super E>> ImmutableSortedArraySet<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableSortedArraySet.factory());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> ImmutableSortedArraySet<E> from(Comparator<? super E> comparator, E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedArraySet.empty(comparator);
        }
        MutableTreeSet<? super E> s = new MutableTreeSet<E>(comparator);
        s.addAll(values);
        return new ImmutableSortedArraySet<E>(comparator, s.toArray());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> ImmutableSortedArraySet<E> from(Comparator<? super E> comparator, @NotNull Iterable<? extends E> values) {
        Iterator<E> it = values.iterator();
        if (!it.hasNext()) {
            return ImmutableSortedArraySet.empty(comparator);
        }
        MutableTreeSet<? super E> s = new MutableTreeSet<E>(comparator);
        while (it.hasNext()) {
            s.add((E)it.next());
        }
        return new ImmutableSortedArraySet<E>(comparator, s.toArray());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> ImmutableSortedArraySet<E> from(Comparator<? super E> comparator, @NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableSortedArraySet.empty(comparator);
        }
        MutableTreeSet<? super E> s = new MutableTreeSet<E>(comparator);
        while (it.hasNext()) {
            s.add((E)it.next());
        }
        return new ImmutableSortedArraySet<E>(comparator, s.toArray());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> ImmutableSortedArraySet<E> from(Comparator<? super E> comparator, @NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableSortedArraySet.factory(comparator));
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedArraySet";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableSortedArraySet<U>> iterableFactory() {
        return DEFAULT_FACTORY;
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableSortedArraySet<U>> iterableFactory(Comparator<? super U> comparator) {
        return ImmutableSortedArraySet.factory(comparator);
    }

    @NotNull
    public Iterator<E> iterator() {
        return GenericArrays.iterator((Object[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedArraySet<E> added(E value) {
        int size = this.elements.length;
        if (size == 0) {
            if (this.comparator == null) {
                Objects.requireNonNull(value);
                Comparable.class.cast(value);
            } else {
                this.comparator.compare(value, value);
            }
            return new ImmutableSortedArraySet<E>(this.comparator, new Object[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value, this.comparator);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        Object[] newElements = new Object[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedArraySet<E>(this.comparator, newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedArraySet<E>(this.comparator, newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedArraySet<E>(this.comparator, newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedArraySet<E> addedAll(@NotNull Iterable<? extends E> values) {
        Iterator<E> it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        Object[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedArraySet.from(this.comparator, values);
        }
        MutableTreeSet<? super E> builder = new MutableTreeSet<E>(this.comparator);
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedArraySet<E>(this.comparator, builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedArraySet<E> addedAll(E @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added((Object)values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedArraySet.from(this.comparator, values);
        }
        MutableTreeSet<? super E> builder = new MutableTreeSet<E>(this.comparator);
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedArraySet<E>(this.comparator, builder.toArray());
    }

    @Override
    public E first() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[0];
    }

    @Override
    public E last() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)GenericArrays.joinTo((Object[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull Consumer<? super E> action) {
        for (Object e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableTreeSet<E>, ImmutableSortedArraySet<E>> {
        final Comparator<? super E> comparator;
        final ImmutableSortedArraySet<E> empty;

        Factory(Comparator<? super E> comparator) {
            this.comparator = comparator;
            this.empty = new ImmutableSortedArraySet<E>(comparator, GenericArrays.EMPTY_OBJECT_ARRAY);
        }

        public MutableTreeSet<E> newBuilder() {
            return new MutableTreeSet<E>(this.comparator);
        }

        public ImmutableSortedArraySet<E> build(@NotNull MutableTreeSet<E> builder) {
            return builder.isEmpty() ? this.empty : new ImmutableSortedArraySet<E>(this.comparator, builder.toArray());
        }

        public ImmutableSortedArraySet<E> empty() {
            return this.empty;
        }

        public void addToBuilder(@NotNull MutableTreeSet<E> builder, E value) {
            builder.add(value);
        }

        public MutableTreeSet<E> mergeBuilder(@NotNull MutableTreeSet<E> builder1, @NotNull MutableTreeSet<E> builder2) {
            builder1.addAll((Iterable<E>)((Object)builder2));
            return builder1;
        }
    }
}

