/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal;

import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import kala.collection.ArraySeq;
import kala.collection.Collection;
import kala.collection.Seq;
import kala.collection.base.Traversable;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.internal.convert.FromJavaConvert;
import kala.collection.mutable.MutableArray;
import kala.collection.mutable.MutableArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CollectionHelper {
    public static Object[] copyToArray(@NotNull Iterable<?> it) {
        if (it instanceof Traversable) {
            return ((Traversable)it).toArray();
        }
        if (it instanceof java.util.Collection) {
            return ((java.util.Collection)it).toArray();
        }
        MutableArrayList buffer = new MutableArrayList();
        for (Object o : it) {
            buffer.append(o);
        }
        return buffer.toArray();
    }

    public static Object[] asArray(@NotNull Iterable<?> it) {
        if (it instanceof MutableArray) {
            return ((MutableArray)((Object)it)).getArray();
        }
        if (it instanceof Traversable) {
            return ((Traversable)it).toArray();
        }
        if (it instanceof java.util.Collection) {
            return ((java.util.Collection)it).toArray();
        }
        MutableArrayList buffer = new MutableArrayList();
        for (Object o : it) {
            buffer.append(o);
        }
        return buffer.toArray();
    }

    public static <E> Seq<E> asIndexedSeq(Object collection) {
        if (collection instanceof Seq && ((Seq)collection).supportsFastRandomAccess()) {
            return (Seq)collection;
        }
        if (collection instanceof List && collection instanceof RandomAccess) {
            return new FromJavaConvert.IndexedSeqFromJava((List)collection);
        }
        if (collection instanceof Traversable) {
            return ArraySeq.wrap(((Traversable)collection).toArray(Object[]::new));
        }
        if (collection instanceof Object[]) {
            return ArraySeq.wrap((Object[])collection);
        }
        if (collection instanceof java.util.Collection) {
            return ArraySeq.wrap(((java.util.Collection)collection).toArray());
        }
        if (collection instanceof Iterable) {
            return MutableArrayList.from((Iterable)collection);
        }
        if (collection instanceof Iterator) {
            return MutableArrayList.from((Iterator)collection);
        }
        throw new IllegalArgumentException();
    }

    public static <E> Collection<E> asSizedCollection(Object obj) {
        if (obj instanceof Seq && ((Seq)obj).supportsFastRandomAccess()) {
            return (Seq)obj;
        }
        if (obj instanceof List) {
            return Seq.wrapJava((List)obj);
        }
        if (obj instanceof Traversable) {
            return ArraySeq.wrap(((Traversable)obj).toArray(Object[]::new));
        }
        if (obj instanceof Object[]) {
            return ArraySeq.wrap((Object[])obj);
        }
        if (obj instanceof java.util.Collection) {
            return ArraySeq.wrap(((java.util.Collection)obj).toArray());
        }
        if (obj instanceof Iterable) {
            return MutableArrayList.from((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return MutableArrayList.from((Iterator)obj);
        }
        throw new IllegalArgumentException();
    }

    public static <E> Collection<E> asCollection(Object collection) {
        if (collection instanceof Collection) {
            return (Collection)collection;
        }
        if (collection instanceof java.util.Collection) {
            return new FromJavaConvert.CollectionFromJava((java.util.Collection)collection);
        }
        if (collection instanceof Iterator) {
            Iterator iterator = (Iterator)collection;
            if (!iterator.hasNext()) {
                return ImmutableSeq.empty();
            }
            MutableArrayList buffer = new MutableArrayList();
            while (iterator.hasNext()) {
                buffer.append(iterator.next());
            }
            return buffer;
        }
        if (collection instanceof Iterable) {
            MutableArrayList buffer = new MutableArrayList();
            buffer.appendAll((Iterable)collection);
            return buffer;
        }
        return null;
    }

    public static <E> Seq<E> asSeq(Object collection) {
        if (collection instanceof Seq) {
            return (Seq)collection;
        }
        if (collection instanceof List) {
            return collection instanceof RandomAccess ? new FromJavaConvert.IndexedSeqFromJava((List)collection) : new FromJavaConvert.SeqFromJava((List)collection);
        }
        if (collection instanceof Object[]) {
            return ArraySeq.wrap((Object[])collection);
        }
        if (collection instanceof java.util.Collection) {
            return ArraySeq.wrap(((java.util.Collection)collection).toArray());
        }
        if (collection instanceof Iterable) {
            return ImmutableArray.from((Iterable)collection);
        }
        if (collection instanceof Iterator) {
            return ImmutableArray.from((Iterator)collection);
        }
        throw new IllegalArgumentException();
    }
}

