/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.hash;

import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class HashNode<K, N extends HashNode<K, N>> {
    public final K key;
    public final int hash;
    public N next;

    public HashNode(K key, int hash) {
        this.key = key;
        this.hash = hash;
    }

    public HashNode(K key, int hash, N next) {
        this.key = key;
        this.hash = hash;
        this.next = next;
    }

    private N self() {
        return (N)this;
    }

    public final N findNode(K k, int h) {
        N node = this.self();
        int nodeHash;
        while (h != (nodeHash = ((HashNode)node).hash) || !Objects.equals(k, ((HashNode)node).key)) {
            N nextNode = ((HashNode)node).next;
            if (nextNode == null || nodeHash > h) {
                return null;
            }
            node = nextNode;
        }
        return node;
    }

    public abstract N deepClone();

    public void forEachKey(@NotNull Consumer<? super K> consumer) {
        N node = this.self();
        while (node != null) {
            consumer.accept(((HashNode)node).key);
            node = ((HashNode)node).next;
        }
    }
}

