/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.hash;

public final class HashUtils {
    public static final int sizeMapBucketBitSize = 5;
    public static final int sizeMapBucketSize = 32;
    public static final int defaultLoadFactor = 750;
    public static final int loadFactorDenum = 1000;

    private HashUtils() {
    }

    public static int tableSizeFor(int capacity) {
        return Integer.min(Integer.highestOneBit(Integer.max(capacity - 1, 4)) * 2, 0x40000000);
    }

    public static int improveHash(int originalHash) {
        return originalHash ^ originalHash >>> 16;
    }

    public static int unimproveHash(int improvedHash) {
        return HashUtils.improveHash(improvedHash);
    }

    public static int computeHash(Object o) {
        return o == null ? 0 : HashUtils.improveHash(o.hashCode());
    }
}

