/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.view;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import kala.collection.AbstractCollectionView;
import kala.collection.AbstractMapView;
import kala.collection.AbstractSetView;
import kala.collection.CollectionView;
import kala.collection.MapLike;
import kala.collection.MapView;
import kala.collection.base.Iterators;
import kala.collection.base.MapIterator;
import kala.control.Option;
import kala.function.CheckedBiConsumer;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapViews {

    public static class MapValues<K, V, OldV>
    extends AbstractMapView<K, V> {
        @NotNull
        protected final MapLike<K, OldV> source;
        @NotNull
        protected final BiFunction<? super K, ? super OldV, ? extends V> mapper;

        public MapValues(@NotNull MapLike<K, OldV> source, @NotNull BiFunction<? super K, ? super OldV, ? extends V> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        @NotNull
        public final MapIterator<K, V> iterator() {
            return this.source.iterator().mapValues(this.mapper);
        }

        @Override
        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public final int size() {
            return this.source.size();
        }

        @Override
        public final int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Values<V>
    extends AbstractCollectionView<V> {
        @NotNull
        protected final MapLike<?, ? extends V> source;

        public Values(@NotNull MapLike<?, ? extends V> source) {
            this.source = source;
        }

        @Override
        @NotNull
        public String className() {
            return "MapLike.ValuesView";
        }

        @NotNull
        public Iterator<V> iterator() {
            return Iterators.narrow((Iterator)this.source.iterator().asValuesIterator());
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Keys<K>
    extends AbstractSetView<K> {
        @NotNull
        protected final MapLike<? extends K, ?> source;

        public Keys(@NotNull MapLike<? extends K, ?> source) {
            this.source = source;
        }

        @Override
        @NotNull
        public String className() {
            return "MapLike.KeysView";
        }

        @NotNull
        public Iterator<K> iterator() {
            return Iterators.narrow((Iterator)this.source.iterator().asKeysIterator());
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Mapped<E, K, V>
    extends AbstractCollectionView<E> {
        @NotNull
        protected final MapLike<K, V> source;
        @NotNull
        protected final BiFunction<? super K, ? super V, ? extends E> mapper;

        public Mapped(@NotNull MapLike<K, V> source, @NotNull BiFunction<? super K, ? super V, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().map(this.mapper);
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class WithDefaultImpl<K, V, M extends MapLike<K, V>>
    extends Of<K, V, M>
    implements MapView.WithDefault<K, V> {
        @NotNull
        protected final Function<? super K, ? extends V> defaultFunction;

        public WithDefaultImpl(@NotNull M source, @NotNull Function<? super K, ? extends V> defaultFunction) {
            super(source);
            this.defaultFunction = defaultFunction;
        }

        @Override
        @NotNull
        public final Function<? super K, ? extends V> getDefaultFunction() {
            return this.defaultFunction;
        }

        @Override
        public V get(K key) {
            Option opt = this.source.getOption(key);
            return (V)(opt.isEmpty() ? this.defaultFunction.apply(key) : opt.get());
        }

        @Override
        public V getOrNull(K key) {
            return this.get(key);
        }

        @Override
        @NotNull
        public Option<V> getOption(K key) {
            Option opt = this.source.getOption(key);
            return opt.isEmpty() ? Option.some(this.defaultFunction.apply(key)) : opt;
        }

        @Override
        @NotNull
        public MapView.WithDefault<K, V> withDefault(@NotNull Function<? super K, ? extends V> defaultFunction) {
            Objects.requireNonNull(defaultFunction);
            return new WithDefaultImpl<K, V, MapLike>(this.source, defaultFunction);
        }
    }

    public static class Of<K, V, M extends MapLike<K, V>>
    extends AbstractMapView<K, V> {
        @NotNull
        protected final M source;

        public Of(@NotNull M source) {
            this.source = source;
        }

        @Override
        @NotNull
        public MapIterator<K, V> iterator() {
            return this.source.iterator();
        }

        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public V get(K key) {
            return this.source.get(key);
        }

        @Override
        @Nullable
        public V getOrNull(K key) {
            return this.source.getOrNull(key);
        }

        @Override
        @NotNull
        public Option<V> getOption(K key) {
            return this.source.getOption(key);
        }

        @Override
        public V getOrDefault(K key, V defaultValue) {
            return this.source.getOrDefault(key, defaultValue);
        }

        @Override
        public V getOrElse(K key, @NotNull Supplier<? extends V> supplier) {
            return this.source.getOrElse(key, supplier);
        }

        @Override
        public <Ex extends Throwable> V getOrThrowException(K key, @NotNull Ex exception) throws Ex {
            return this.source.getOrThrowException(key, exception);
        }

        @Override
        public <Ex extends Throwable> V getOrThrow(K key, @NotNull Supplier<? extends Ex> supplier) throws Ex {
            return this.source.getOrThrow(key, supplier);
        }

        @Override
        public boolean containsKey(K key) {
            return this.source.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.source.containsValue(value);
        }

        @Override
        public boolean anyMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
            return this.source.anyMatch(predicate);
        }

        @Override
        public boolean allMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
            return this.source.allMatch(predicate);
        }

        @Override
        public boolean noneMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
            return this.source.noneMatch(predicate);
        }

        @Override
        @NotNull
        public Tuple2<K, V>[] toArray() {
            return this.source.toArray();
        }

        @Override
        public void forEach(@NotNull BiConsumer<? super K, ? super V> consumer) {
            this.source.forEach(consumer);
        }

        @Override
        public <Ex extends Throwable> void forEachChecked(@NotNull CheckedBiConsumer<? super K, ? super V, ? extends Ex> consumer) throws Ex {
            this.source.forEachChecked(consumer);
        }

        @Override
        public void forEachUnchecked(@NotNull CheckedBiConsumer<? super K, ? super V, ?> consumer) {
            this.source.forEachUnchecked(consumer);
        }

        @Override
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer) {
            return this.source.joinTo(buffer);
        }

        @Override
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator) {
            return this.source.joinTo(buffer, separator);
        }

        @Override
        @Contract(value="_, _, _, _ -> param1", mutates="param1")
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
            return this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @Override
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
            return this.source.joinTo(buffer, transform);
        }

        @Override
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
            return this.source.joinTo(buffer, separator, transform);
        }

        @Override
        @Contract(value="_, _, _, _, _ -> param1", mutates="param1")
        @NotNull
        public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
            return this.source.joinTo(buffer, separator, prefix, postfix, transform);
        }

        @Override
        @NotNull
        public String joinToString() {
            return this.source.joinToString();
        }

        @Override
        @NotNull
        public String joinToString(CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @Override
        @NotNull
        public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
            return this.source.joinToString(transform);
        }

        @Override
        @NotNull
        public String joinToString(CharSequence separator, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
            return this.source.joinToString(separator, transform);
        }

        @Override
        @NotNull
        public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
            return this.source.joinToString(separator, prefix, postfix, transform);
        }
    }

    public static class Empty<K, V>
    extends AbstractMapView<K, V> {
        public static final Empty<?, ?> INSTANCE = new Empty();

        @Override
        @NotNull
        public final MapIterator<K, V> iterator() {
            return MapIterator.empty();
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public final <U> CollectionView<U> map(@NotNull BiFunction<? super K, ? super V, ? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public final <NV> MapView<K, NV> mapValues(@NotNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
            return MapView.empty();
        }

        @Override
        public String toString() {
            return this.className() + "{}";
        }
    }
}

