/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.Serializable;
import kala.collection.base.OrderedTraversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.AbstractMutableListSet;
import kala.collection.mutable.AbstractMutableSetFactory;
import kala.collection.mutable.MutableArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableArraySet<E>
extends AbstractMutableListSet<E, MutableArrayList<E>>
implements OrderedTraversable<E>,
Serializable {
    private static final long serialVersionUID = 3355455494869072611L;
    private static final Factory<?> FACTORY = new Factory();

    public MutableArraySet() {
        super(new MutableArrayList());
    }

    @Contract(pure=true)
    @NotNull
    public static <E> CollectionFactory<E, ?, MutableArraySet<E>> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableArraySet<E> create() {
        return new MutableArraySet<E>();
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableArraySet<E> of() {
        return new MutableArraySet<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArraySet<E> of(E value1) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.add((Object)value1);
        return res;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableArraySet<E> of(E value1, E value2) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        return res;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableArraySet<E> of(E value1, E value2, E value3) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        res.add((Object)value3);
        return res;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableArraySet<E> of(E value1, E value2, E value3, E value4) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        res.add((Object)value3);
        res.add((Object)value4);
        return res;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableArraySet<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        res.add((Object)value3);
        res.add((Object)value4);
        res.add((Object)value5);
        return res;
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArraySet<E> of(E ... values) {
        return MutableArraySet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArraySet<E> from(E @NotNull [] values) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.addAll(values);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArraySet<E> from(@NotNull Iterable<? extends E> values) {
        MutableArraySet<E> res = new MutableArraySet<E>();
        res.addAll(values);
        return res;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableArraySet";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableArraySet<U>> iterableFactory() {
        return MutableArraySet.factory();
    }

    private static final class Factory<E>
    extends AbstractMutableSetFactory<E, MutableArraySet<E>> {
        private Factory() {
        }

        public MutableArraySet<E> newBuilder() {
            return new MutableArraySet();
        }
    }
}

