/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import kala.collection.mutable.AbstractMutableSeq;
import kala.collection.mutable.MutableSeq;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.NotNull;

class MutableCopyOnWriteSeqBase<E, S extends MutableSeq<E>>
extends AbstractMutableSeq<E> {
    S source;
    boolean exclusive = true;

    MutableCopyOnWriteSeqBase(S source, boolean exclusive) {
        this.source = source;
        this.exclusive = exclusive;
    }

    void ensureExclusive() {
        if (!this.exclusive) {
            this.source = this.source.clone();
            this.exclusive = true;
        }
    }

    @NotNull
    public Iterator<E> iterator() {
        return this.source.iterator();
    }

    @Override
    @NotNull
    public Iterator<E> iterator(int beginIndex) {
        return this.source.iterator(beginIndex);
    }

    public Spliterator<E> spliterator() {
        return this.source.spliterator();
    }

    @NotNull
    public Stream<E> stream() {
        return this.source.stream();
    }

    @NotNull
    public Stream<E> parallelStream() {
        return this.source.parallelStream();
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public int size() {
        return this.source.size();
    }

    public int knownSize() {
        return this.source.knownSize();
    }

    @Override
    public void set(int index, E newValue) {
        this.ensureExclusive();
        this.source.set(index, newValue);
    }

    @Override
    public void swap(int index1, int index2) {
        this.ensureExclusive();
        this.source.swap(index1, index2);
    }

    @Override
    public void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
        this.ensureExclusive();
        this.source.replaceAll(operator);
    }

    @Override
    public void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
        this.ensureExclusive();
        this.source.replaceAllIndexed(operator);
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        this.ensureExclusive();
        this.source.sort(comparator);
    }

    @Override
    public void reverse() {
        this.ensureExclusive();
        this.source.reverse();
    }

    @Override
    public void shuffle(@NotNull Random random) {
        this.ensureExclusive();
        this.source.shuffle(random);
    }
}

