/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kala.collection.Map;
import kala.collection.MapLike;
import kala.collection.base.AbstractIterator;
import kala.collection.base.AbstractMapIterator;
import kala.collection.base.MapIterator;
import kala.collection.factory.MapFactory;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.hash.HashBase;
import kala.collection.internal.hash.HashNode;
import kala.collection.internal.hash.HashUtils;
import kala.collection.mutable.AbstractMutableMapFactory;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableMapEditor;
import kala.control.Option;
import kala.function.Hasher;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
public final class MutableHashMap<K, V>
extends HashBase<K, Node<K, V>>
implements MutableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4445503260710443405L;
    private static final Factory<?, ?> FACTORY = new Factory();
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;

    public MutableHashMap() {
        this(16, 0.75);
    }

    public MutableHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public MutableHashMap(int initialCapacity, double loadFactor) {
        this(Hasher.optimizedHasher(), initialCapacity, loadFactor);
    }

    public MutableHashMap(Hasher<? super K> hasher) {
        this(hasher, 16, 0.75);
    }

    public MutableHashMap(Hasher<? super K> hasher, int initialCapacity) {
        this(hasher, initialCapacity, 0.75);
    }

    public MutableHashMap(Hasher<? super K> hasher, int initialCapacity, double loadFactor) {
        super(hasher, initialCapacity, loadFactor);
    }

    private MutableHashMap(@NotNull MutableHashMap<K, V> old) {
        super(old);
    }

    @NotNull
    public static <K, V> MapFactory<K, V, ?, MutableHashMap<K, V>> factory() {
        return FACTORY;
    }

    @NotNull
    static <T, K, V> Collector<T, ?, MutableHashMap<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(MutableHashMap.factory(), keyMapper, valueMapper);
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> create() {
        return new MutableHashMap<K, V>();
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of() {
        return new MutableHashMap<K, V>();
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of(K k1, V v1) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        m.set(k1, v1);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        m.set(k5, v5);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> of(Object ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        MutableHashMap<Object, Object> res = new MutableHashMap<Object, Object>();
        for (int i = 0; i < values.length; i += 2) {
            res.set(values[i], values[i + 1]);
        }
        return res;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries() {
        return new MutableHashMap<K, V>();
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        MutableHashMap<K, V> res = new MutableHashMap<K, V>();
        res.set(entry1);
        return res;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        MutableHashMap<K, V> res = new MutableHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        return res;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        MutableHashMap<K, V> res = new MutableHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        return res;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        MutableHashMap<K, V> res = new MutableHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        return res;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        MutableHashMap<K, V> res = new MutableHashMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        res.set(entry5);
        return res;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> MutableHashMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        MutableHashMap<K, V> res = new MutableHashMap<K, V>();
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            res.set(entry);
        }
        return res;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> from(@NotNull java.util.Map<? extends K, ? extends V> values) {
        MutableHashMap<? extends K, ? extends V> m = new MutableHashMap<K, V>();
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> from(@NotNull MapLike<? extends K, ? extends V> values) {
        MutableHashMap<? extends K, ? extends V> m = new MutableHashMap<K, V>();
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        for (Map.Entry<K, V> entry : values) {
            m.set(entry.getKey(), entry.getValue());
        }
        return m;
    }

    @NotNull
    public static <K, V> MutableHashMap<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        MutableHashMap<K, V> m = new MutableHashMap<K, V>();
        for (Map.Entry<K, V> value : values) {
            m.set(value.getKey(), value.getValue());
        }
        return m;
    }

    protected Node<K, V>[] createNodeArray(int length) {
        return new Node[length];
    }

    @Override
    protected void growTable(int newLen) {
        if (newLen < 0) {
            throw new IllegalStateException("The new HashMap table size " + newLen + " exceeds maximum");
        }
        Node[] oldTable = (Node[])this.table;
        this.threshold = this.newThreshold(newLen);
        if (this.contentSize == 0) {
            this.table = this.createNodeArray(newLen);
        } else {
            Node[] newTable = Arrays.copyOf(oldTable, newLen);
            this.table = newTable;
            Node preLow = new Node(null, 0, null, null);
            Node preHigh = new Node(null, 0, null, null);
            for (int oldLen = oldTable.length; oldLen < newLen; oldLen *= 2) {
                for (int i = 0; i < oldLen; ++i) {
                    Node old = newTable[i];
                    if (old == null) continue;
                    preLow.next = null;
                    preHigh.next = null;
                    Node lastLow = preLow;
                    Node lastHigh = preHigh;
                    Node n = old;
                    while (n != null) {
                        Node next = (Node)n.next;
                        if ((n.hash & oldLen) == 0) {
                            lastLow.next = n;
                            lastLow = n;
                        } else {
                            lastHigh.next = n;
                            lastHigh = n;
                        }
                        n = next;
                    }
                    lastLow.next = null;
                    if (old != preLow.next) {
                        newTable[i] = (Node)preLow.next;
                    }
                    if (preHigh.next == null) continue;
                    newTable[i + oldLen] = (Node)preHigh.next;
                    lastHigh.next = null;
                }
            }
        }
    }

    private void set0(K key, V value, int hash) {
        if (this.contentSize >= this.threshold - 1) {
            this.growTable(((Node[])this.table).length * 2);
        }
        int idx = this.index(hash);
        this.set0(key, value, hash, idx);
    }

    private void set0(K key, V value, int hash, int idx) {
        Node[] table = (Node[])this.table;
        Node old = table[idx];
        if (old == null) {
            table[idx] = new Node<K, V>(key, hash, value);
        } else {
            Node prev = null;
            Node n = old;
            while (n != null && n.hash <= hash) {
                if (n.hash == hash && this.hasher.test(key, n.key)) {
                    n.value = value;
                    return;
                }
                prev = n;
                n = (Node)n.next;
            }
            if (prev == null) {
                table[idx] = new Node<K, V>(key, hash, value, old);
            } else {
                prev.next = new Node<K, V>(key, hash, value, (Node)prev.next);
            }
        }
        ++this.contentSize;
    }

    private Option<V> put0(K key, V value, int hash) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(((Node[])this.table).length * 2);
        }
        int idx = this.index(hash);
        return this.put0(key, value, hash, idx);
    }

    private Option<V> put0(K key, V value, int hash, int idx) {
        Node[] table = (Node[])this.table;
        Node old = table[idx];
        if (old == null) {
            table[idx] = new Node<K, V>(key, hash, value);
        } else {
            Node prev = null;
            Node n = old;
            while (n != null && n.hash <= hash) {
                if (n.hash == hash && this.hasher.test(key, n.key)) {
                    Object oldValue = n.value;
                    n.value = value;
                    return Option.some(oldValue);
                }
                prev = n;
                n = (Node)n.next;
            }
            if (prev == null) {
                table[idx] = new Node<K, V>(key, hash, value, old);
            } else {
                prev.next = new Node<K, V>(key, hash, value, (Node)prev.next);
            }
        }
        ++this.contentSize;
        return Option.none();
    }

    @Override
    @NotNull
    public String className() {
        return "MutableHashMap";
    }

    @Override
    @NotNull
    public <NK, NV> MapFactory<NK, NV, ?, MutableHashMap<NK, NV>> mapFactory() {
        return MutableHashMap.factory();
    }

    @Override
    @NotNull
    public MapIterator<K, V> iterator() {
        return new Itr((Node[])this.table);
    }

    @NotNull
    NodeItr<K, V> nodeIterator() {
        return new NodeItr((Node[])this.table);
    }

    @Override
    @NotNull
    public MutableMapEditor<K, V, MutableHashMap<K, V>> edit() {
        return new MutableMapEditor(this);
    }

    @Override
    @NotNull
    public java.util.Map<K, V> asJava() {
        return new AsJava(this);
    }

    @NotNull
    MutableHashMap<K, V> shallowClone() {
        try {
            return (MutableHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public MutableHashMap<K, V> clone() {
        return new MutableHashMap<K, V>(this);
    }

    @Override
    public V get(K key) {
        Node node = (Node)this.findNode(key);
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.value;
    }

    @Override
    @Nullable
    public V getOrNull(K key) {
        Node node = (Node)this.findNode(key);
        return node == null ? null : (V)node.value;
    }

    @Override
    @NotNull
    public Option<V> getOption(K key) {
        Node node = (Node)this.findNode(key);
        return node == null ? Option.none() : Option.some(node.value);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        Node node = (Node)this.findNode(key);
        return node == null ? defaultValue : node.value;
    }

    @Override
    public V getOrElse(K key, @NotNull Supplier<? extends V> supplier) {
        Node node = (Node)this.findNode(key);
        return node == null ? supplier.get() : node.value;
    }

    @Override
    public V getOrPut(K key, @NotNull Supplier<? extends V> defaultValue) {
        Node node = (Node)this.findNode(key);
        if (node == null) {
            V value = defaultValue.get();
            this.set(key, value);
            return value;
        }
        return node.value;
    }

    @Override
    public <Ex extends Throwable> V getOrThrow(K key, @NotNull Supplier<? extends Ex> supplier) throws Ex {
        Node node = (Node)this.findNode(key);
        if (node == null) {
            throw (Throwable)supplier.get();
        }
        return node.value;
    }

    @Override
    public <Ex extends Throwable> V getOrThrowException(K key, @NotNull Ex exception) throws Ex {
        Node node = (Node)this.findNode(key);
        if (node == null) {
            throw exception;
        }
        return node.value;
    }

    @Override
    public void set(K key, V value) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(((Node[])this.table).length * 2);
        }
        int hash = HashUtils.computeHash(key);
        int idx = this.index(hash);
        this.set0(key, value, hash, idx);
    }

    @Override
    @NotNull
    public Option<V> put(K key, V value) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(((Node[])this.table).length * 2);
        }
        int hash = HashUtils.computeHash(key);
        int idx = this.index(hash);
        return this.put0(key, value, hash, idx);
    }

    @Override
    public void putAll(@NotNull java.util.Map<? extends K, ? extends V> m) {
        Objects.requireNonNull(m);
        if (m instanceof AsJavaConvert.MapAsJava) {
            this.putAll((MapLike<? extends K, ? extends V>)((AsJavaConvert.MapAsJava)m).source);
            return;
        }
        m.forEach(this::set);
    }

    @Override
    public void putAll(@NotNull MapLike<? extends K, ? extends V> m) {
        Objects.requireNonNull(m);
        if (m == this) {
            return;
        }
        this.sizeHint(m.knownSize());
        if (m instanceof MutableHashMap) {
            MutableHashMap hashMap = (MutableHashMap)m;
            NodeItr<K, V> itr = hashMap.nodeIterator();
            while (itr.hasNext()) {
                Object next = itr.next();
                this.set0(((Node)next).key, ((Node)next).value, ((Node)next).hash);
            }
        } else {
            m.forEach(this::set);
        }
    }

    @Override
    public void putAll(@NotNull MutableHashMap<? extends K, ? extends V> m) {
        Objects.requireNonNull(m);
        if (m == this) {
            return;
        }
        NodeItr<K, V> itr = m.nodeIterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            this.set0(((Node)next).key, ((Node)next).value, ((Node)next).hash);
        }
    }

    @Override
    @NotNull
    public Option<V> remove(K key) {
        Node node = (Node)this.removeNode(key);
        return node == null ? Option.none() : Option.some(node.value);
    }

    @Override
    @NotNull
    public Option<V> replace(K key, V value) {
        Node node = (Node)this.findNode(key);
        if (node == null) {
            return Option.none();
        }
        Object oldValue = node.value;
        node.value = value;
        return Option.some(oldValue);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Node node = (Node)this.findNode(key);
        if (node == null || !Objects.equals(node.value, oldValue)) {
            return false;
        }
        node.value = newValue;
        return true;
    }

    @Override
    public void replaceAll(@NotNull BiFunction<? super K, ? super V, ? extends V> function) {
        Node[] nodeArray = (Node[])this.table;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node fn;
            Node node = fn = nodeArray[i];
            while (node != null) {
                node.value = function.apply(node.key, node.value);
                node = (Node)node.next;
            }
        }
    }

    @Override
    public boolean contains(K key, Object value) {
        Node node = (Node)this.findNode(key);
        return node != null && Objects.equals(node.value, value);
    }

    @Override
    public boolean containsKey(K key) {
        return this.findNode(key) != null;
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super K, ? super V> consumer) {
        Node[] nodeArray = (Node[])this.table;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node fn;
            Node node = fn = nodeArray[i];
            while (node != null) {
                consumer.accept(node.key, node.value);
                node = (Node)node.next;
            }
        }
    }

    public int hashCode() {
        return Map.hashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Map && Map.equals(this, (Map)obj);
    }

    public String toString() {
        return this.className() + '{' + this.joinToString() + '}';
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        double loadFactor = in.readDouble();
        Hasher hasher = (Hasher)in.readObject();
        if (size < 0) {
            throw new InvalidObjectException("Illegal initial capacity: " + size);
        }
        if (loadFactor <= 0.0 || Double.isNaN(loadFactor)) {
            throw new InvalidObjectException("Illegal load factor: " + loadFactor);
        }
        Objects.requireNonNull(hasher);
        this.hasher = hasher;
        this.contentSize = 0;
        this.loadFactor = loadFactor;
        this.table = this.createNodeArray(HashUtils.tableSizeFor(size));
        this.threshold = this.newThreshold(((Node[])this.table).length);
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.set(key, value);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.contentSize);
        out.writeDouble(this.loadFactor);
        out.writeObject(this.hasher);
        this.forEachUnchecked((k, v) -> {
            out.writeObject(k);
            out.writeObject(v);
        });
    }

    private static final class Factory<K, V>
    extends AbstractMutableMapFactory<K, V, MutableHashMap<K, V>> {
        private Factory() {
        }

        public MutableHashMap<K, V> newBuilder() {
            return new MutableHashMap();
        }
    }

    protected static final class Node<K, V>
    extends HashNode<K, Node<K, V>>
    implements Map.Entry<K, V> {
        public V value;

        public Node(K key, int hash, V value) {
            super(key, hash);
            this.value = value;
        }

        public Node(K key, int hash, V value, Node<K, V> next) {
            super(key, hash);
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public void forEach(@NotNull BiConsumer<? super K, ? super V> consumer) {
            Node node = this;
            while (node != null) {
                consumer.accept(node.key, node.value);
                node = (Node)node.next;
            }
        }

        public String toString() {
            return "Node[key=" + this.key + ", value=" + this.value + ", hash=" + this.hash + "]";
        }

        @Override
        public Node<K, V> deepClone() {
            Node<Object, V> nextNode;
            Node<Object, V> head;
            Node<Object, V> node = head = new Node<Object, V>(this.key, this.hash, this.value, (Node)this.next);
            while ((nextNode = (Node<Object, V>)node.next) != null) {
                node.next = nextNode = new Node<Object, V>(nextNode.key, nextNode.hash, nextNode.value, (Node)nextNode.next);
                node = nextNode;
            }
            return head;
        }
    }

    private static final class Itr<K, V>
    extends AbstractMapIterator<K, V> {
        private int i = 0;
        private Node<K, V> node = null;
        private final Node<K, V>[] table;
        private final int len;
        private V value;

        public Itr(Node<K, V>[] table) {
            this.table = table;
            this.len = table.length;
        }

        public boolean hasNext() {
            if (this.node != null) {
                return true;
            }
            while (this.i < this.len) {
                Node<K, V> n = this.table[this.i];
                ++this.i;
                if (n == null) continue;
                this.node = n;
                return true;
            }
            return false;
        }

        public K nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object key = this.node.key;
            this.value = this.node.value;
            this.node = (Node)this.node.next;
            return (K)key;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static final class NodeItr<K, V>
    extends AbstractIterator<Node<K, V>> {
        private int i = 0;
        private Node<K, V> node = null;
        private final Node<K, V>[] table;

        public NodeItr(Node<K, V>[] table) {
            this.table = table;
        }

        public boolean hasNext() {
            if (this.node != null) {
                return true;
            }
            while (this.i < this.table.length) {
                Node<K, V> n;
                if ((n = this.table[this.i++]) == null) continue;
                this.node = n;
                return true;
            }
            return false;
        }

        public Node<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node<K, V> oldNode = this.node;
            this.node = (Node)oldNode.next;
            return oldNode;
        }
    }

    private static final class AsJava<K, V>
    extends AsJavaConvert.MutableMapAsJava<K, V, MutableHashMap<K, V>> {
        public AsJava(@NotNull MutableHashMap<K, V> source) {
            super(source);
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet((MutableHashMap)this.source);
        }

        static final class EntrySet<K, V>
        extends AsJavaConvert.MapAsJava.EntrySet<K, V, MutableHashMap<K, V>> {
            EntrySet(MutableHashMap<K, V> source) {
                super(source);
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return ((MutableHashMap)this.source).nodeIterator();
            }
        }
    }
}

