/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.Serializable;
import kala.collection.base.OrderedTraversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.AbstractMutableListSet;
import kala.collection.mutable.AbstractMutableSetFactory;
import kala.collection.mutable.MutableLinkedList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableLinkedSet<E>
extends AbstractMutableListSet<E, MutableLinkedList<E>>
implements OrderedTraversable<E>,
Serializable {
    private static final long serialVersionUID = 6438198495902720936L;
    private static final Factory<?> FACTORY = new Factory();

    public MutableLinkedSet() {
        super(new MutableLinkedList());
    }

    @Contract(pure=true)
    @NotNull
    public static <E> CollectionFactory<E, ?, MutableLinkedSet<E>> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableLinkedSet<E> create() {
        return new MutableLinkedSet<E>();
    }

    @Contract(value="-> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of() {
        return new MutableLinkedSet<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of(E value1) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.add((Object)value1);
        return res;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of(E value1, E value2) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        return res;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of(E value1, E value2, E value3) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        res.add((Object)value3);
        return res;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of(E value1, E value2, E value3, E value4) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        res.add((Object)value3);
        res.add((Object)value4);
        return res;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.add((Object)value1);
        res.add((Object)value2);
        res.add((Object)value3);
        res.add((Object)value4);
        res.add((Object)value5);
        return res;
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> of(E ... values) {
        return MutableLinkedSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> from(E @NotNull [] values) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.addAll(values);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableLinkedSet<E> from(@NotNull Iterable<? extends E> values) {
        MutableLinkedSet<E> res = new MutableLinkedSet<E>();
        res.addAll(values);
        return res;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableLinkedSet";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableLinkedSet<U>> iterableFactory() {
        return MutableLinkedSet.factory();
    }

    private static final class Factory<E>
    extends AbstractMutableSetFactory<E, MutableLinkedSet<E>> {
        private Factory() {
        }

        public MutableLinkedSet<E> newBuilder() {
            return new MutableLinkedSet();
        }
    }
}

