/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Map;
import java.util.function.BiFunction;
import kala.collection.MapLike;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MutableMapEditor<K, V, M extends MutableMap<K, V>> {
    @NotNull
    protected final M source;

    public MutableMapEditor(@NotNull M source) {
        this.source = source;
    }

    @NotNull
    public final M done() {
        return this.source;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> set(K key, V value) {
        this.source.set(key, value);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> put(K key, V value) {
        this.source.put(key, value);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> put(@NotNull Tuple2<? extends K, ? extends V> kv) {
        this.source.put(kv);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> putIfAbsent(K key, V value) {
        this.source.putIfAbsent(key, value);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.source.putAll(m);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> putAll(@NotNull MapLike<? extends K, ? extends V> m) {
        this.source.putAll(m);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> replace(K key, V value) {
        this.source.replace(key, value);
        return this;
    }

    @Contract(value="_, _, _ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> replace(K key, V oldValue, V newValue) {
        this.source.replace(key, oldValue, newValue);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableMapEditor<K, V, M> replaceAll(@NotNull BiFunction<? super K, ? super V, ? extends V> function) {
        this.source.replaceAll(function);
        return this;
    }
}

