/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableLinkedSeq;
import kala.collection.mutable.AbstractMutableListFactory;
import kala.collection.mutable.FreezableMutableSeq;
import kala.collection.mutable.MutableStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
public final class MutableSinglyLinkedList<E>
extends ImmutableLinkedSeq.Builder<E>
implements MutableStack<E>,
FreezableMutableSeq<E>,
Serializable {
    private static final long serialVersionUID = 4403781063629141093L;
    private static final Factory<?> FACTORY = new Factory();

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableSinglyLinkedList<E>> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> create() {
        return new MutableSinglyLinkedList<E>();
    }

    @Contract(value=" -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of() {
        return new MutableSinglyLinkedList<E>();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of(E value1) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.append(value1);
        return buffer;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of(E value1, E value2) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.append(value1);
        buffer.append(value2);
        return buffer;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of(E value1, E value2, E value3) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.append(value1);
        buffer.append(value2);
        buffer.append(value3);
        return buffer;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of(E value1, E value2, E value3, E value4) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.append(value1);
        buffer.append(value2);
        buffer.append(value3);
        buffer.append(value4);
        return buffer;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.append(value1);
        buffer.append(value2);
        buffer.append(value3);
        buffer.append(value4);
        buffer.append(value5);
        return buffer;
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> of(E ... values) {
        return MutableSinglyLinkedList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> from(E @NotNull [] values) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.appendAll(values);
        return buffer;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> from(@NotNull Iterable<? extends E> values) {
        MutableSinglyLinkedList<E> buffer = new MutableSinglyLinkedList<E>();
        buffer.appendAll(values);
        return buffer;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> from(@NotNull Iterator<? extends E> it) {
        MutableSinglyLinkedList<E> res = new MutableSinglyLinkedList<E>();
        while (it.hasNext()) {
            res.append(it.next());
        }
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableSinglyLinkedList<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableSinglyLinkedList.factory());
    }

    @NotNull
    public static <E> MutableSinglyLinkedList<E> fill(int n, E value) {
        MutableSinglyLinkedList<E> res = new MutableSinglyLinkedList<E>();
        while (n-- > 0) {
            res.append(value);
        }
        return res;
    }

    @NotNull
    public static <E> MutableSinglyLinkedList<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        MutableSinglyLinkedList<E> res = new MutableSinglyLinkedList<E>();
        while (n-- > 0) {
            res.append(supplier.get());
        }
        return res;
    }

    @NotNull
    public static <E> MutableSinglyLinkedList<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        MutableSinglyLinkedList<E> res = new MutableSinglyLinkedList<E>();
        for (int i = 0; i < n; ++i) {
            res.append(init.apply(i));
        }
        return res;
    }

    @NotNull
    public static <E> MutableSinglyLinkedList<E> generateUntil(@NotNull Supplier<? extends E> supplier, @NotNull Predicate<? super E> predicate) {
        E value;
        MutableSinglyLinkedList<E> res = new MutableSinglyLinkedList<E>();
        while (!predicate.test(value = supplier.get())) {
            res.append(value);
        }
        return res;
    }

    @NotNull
    public static <E> MutableSinglyLinkedList<E> generateUntilNull(@NotNull Supplier<? extends @Nullable E> supplier) {
        E value;
        MutableSinglyLinkedList<E> res = new MutableSinglyLinkedList<E>();
        while ((value = supplier.get()) != null) {
            res.append(value);
        }
        return res;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableSinglyLinkedList";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableSinglyLinkedList<U>> iterableFactory() {
        return MutableSinglyLinkedList.factory();
    }

    @Override
    @NotNull
    public MutableSinglyLinkedList<E> clone() {
        MutableSinglyLinkedList res = new MutableSinglyLinkedList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            res.append(e);
        }
        return res;
    }

    @Override
    public void push(E value) {
        this.prepend(value);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.first();
    }

    @Override
    @NotNull
    public ImmutableLinkedSeq<E> freeze() {
        return this.toImmutableLinkedSeq();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.append(in.readObject());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            out.writeObject(e);
        }
    }

    private static final class Factory<E>
    extends AbstractMutableListFactory<E, MutableSinglyLinkedList<E>> {
        private Factory() {
        }

        public MutableSinglyLinkedList<E> newBuilder() {
            return new MutableSinglyLinkedList();
        }

        public MutableSinglyLinkedList<E> from(E @NotNull [] values) {
            return MutableSinglyLinkedList.from(values);
        }

        public MutableSinglyLinkedList<E> from(@NotNull Iterable<? extends E> values) {
            return MutableSinglyLinkedList.from(values);
        }

        public MutableSinglyLinkedList<E> from(@NotNull Iterator<? extends E> it) {
            return MutableSinglyLinkedList.from(it);
        }

        public MutableSinglyLinkedList<E> fill(int n, E value) {
            return MutableSinglyLinkedList.fill(n, value);
        }

        public MutableSinglyLinkedList<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return MutableSinglyLinkedList.fill(n, supplier);
        }

        public MutableSinglyLinkedList<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return MutableSinglyLinkedList.fill(n, init);
        }
    }
}

