/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import kala.collection.AnySet;
import kala.collection.Set;
import kala.collection.SortedSet;
import kala.collection.base.AbstractIterator;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.internal.tree.RedBlackTree;
import kala.collection.mutable.AbstractMutableSetFactory;
import kala.collection.mutable.MutableSortedSet;
import kala.internal.ComparableUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MutableTreeSet<E>
extends RedBlackTree<E, Node<E>>
implements MutableSortedSet<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory<? extends Comparable<?>> DEFAULT_FACTORY = new Factory(null);

    public MutableTreeSet() {
        this((Comparator<E>)null);
    }

    public MutableTreeSet(Comparator<? super E> comparator) {
        super(comparator);
    }

    @NotNull
    public static <E extends Comparable<? super E>> CollectionFactory<E, ?, MutableTreeSet<E>> factory() {
        return DEFAULT_FACTORY;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableTreeSet<E>> factory(Comparator<? super E> comparator) {
        return comparator == null ? DEFAULT_FACTORY : new Factory<E>(comparator);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> create() {
        return new MutableTreeSet<E>();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> create(Comparator<? super E> comparator) {
        return new MutableTreeSet<E>(comparator);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of() {
        return new MutableTreeSet<E>();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(E value1) {
        MutableTreeSet<E> s = new MutableTreeSet<E>();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(E value1, E value2) {
        MutableTreeSet<E> s = new MutableTreeSet<E>();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(E value1, E value2, E value3) {
        MutableTreeSet<E> s = new MutableTreeSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(E value1, E value2, E value3, E value4) {
        MutableTreeSet<E> s = new MutableTreeSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableTreeSet<E> s = new MutableTreeSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(E ... values) {
        return MutableTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> of(Comparator<? super E> comparator) {
        return new MutableTreeSet<E>(comparator);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(Comparator<? super E> comparator, E value1) {
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.add(value1);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(Comparator<? super E> comparator, E value1, E value2) {
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(Comparator<? super E> comparator, E value1, E value2, E value3) {
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(Comparator<? super E> comparator, E value1, E value2, E value3, E value4) {
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> of(Comparator<? super E> comparator, E value1, E value2, E value3, E value4, E value5) {
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> of(Comparator<? super E> comparator, E ... values) {
        return MutableTreeSet.from(comparator, values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> from(E @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableTreeSet<E> s = new MutableTreeSet<E>();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> from(@NotNull SortedSet<? extends E> values) {
        Comparator<? extends E> comparator = values.comparator();
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.addAll((Iterable<E>)((Object)values));
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> from(@NotNull java.util.SortedSet<? extends E> values) {
        Comparator<? extends E> comparator = values.comparator();
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Comparator comparator = null;
        if (values instanceof SortedSet) {
            comparator = ((SortedSet)((Object)values)).comparator();
        } else if (values instanceof java.util.SortedSet) {
            comparator = ((java.util.SortedSet)values).comparator();
        }
        MutableTreeSet<? extends E> s = new MutableTreeSet<E>(comparator);
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> from(@NotNull Iterator<? extends E> it) {
        MutableTreeSet<Comparable> s = new MutableTreeSet<Comparable>();
        while (it.hasNext()) {
            s.add((Comparable)it.next());
        }
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <E extends Comparable<? super E>> MutableTreeSet<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableTreeSet.factory());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> from(Comparator<? super E> comparator, E @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        s.addAll(values);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> from(Comparator<? super E> comparator, @NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        MutableTreeSet<? extends E> s = new MutableTreeSet<E>(comparator);
        s.addAll(values);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> from(Comparator<? super E> comparator, @NotNull Iterator<? extends E> it) {
        MutableTreeSet<E> s = new MutableTreeSet<E>(comparator);
        while (it.hasNext()) {
            s.add(it.next());
        }
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E> MutableTreeSet<E> from(Comparator<? super E> comparator, @NotNull Stream<? extends E> stream) {
        return stream.collect(MutableTreeSet.factory(comparator));
    }

    @Override
    @NotNull
    public String className() {
        return "MutableTreeSet";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableTreeSet<U>> iterableFactory() {
        return DEFAULT_FACTORY;
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, MutableTreeSet<U>> iterableFactory(Comparator<? super U> comparator) {
        return MutableTreeSet.factory(comparator);
    }

    @NotNull
    public Iterator<E> iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? Iterators.empty() : new Itr(firstNode);
    }

    @Override
    @NotNull
    public MutableTreeSet<E> clone() {
        return MutableTreeSet.from(this.comparator, this);
    }

    @Override
    public boolean add(E value) {
        int c;
        Node parent;
        Comparator comparator = this.comparator;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node<E>(value, null);
            this.size = 1;
            return true;
        }
        if (comparator == null) {
            do {
                parent = node;
                c = ComparableUtils.compare(value, node.getValue());
                if (c < 0) {
                    node = (Node)node.left;
                    continue;
                }
                if (c > 0) {
                    node = (Node)node.right;
                    continue;
                }
                return false;
            } while (node != null);
        } else {
            do {
                parent = node;
                c = comparator.compare(value, node.getValue());
                if (c < 0) {
                    node = (Node)node.left;
                    continue;
                }
                if (c > 0) {
                    node = (Node)node.right;
                    continue;
                }
                return false;
            } while (node != null);
        }
        Node<E> n = new Node<E>(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(Object value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(Object value) {
        return this.getNode(value) != null;
    }

    @Override
    public E first() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    @Override
    public E last() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        int size = this.size;
        U[] res = generator.apply(size);
        if (size == 0) {
            return res;
        }
        Iterator<E> it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.next();
        }
        return res;
    }

    public int hashCode() {
        return Set.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && Set.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull Consumer<? super E> action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readObject());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            out.writeObject(e);
        }
    }

    private static final class Factory<E>
    extends AbstractMutableSetFactory<E, MutableTreeSet<E>> {
        @Nullable
        private final Comparator<? super E> comparator;

        Factory(@Nullable Comparator<? super E> comparator) {
            this.comparator = comparator;
        }

        public MutableTreeSet<E> newBuilder() {
            return new MutableTreeSet<E>(this.comparator);
        }
    }

    static final class Node<E>
    extends RedBlackTree.Node<E, Node<E>> {
        Node(E value, Node<E> parent) {
            super(value, parent);
        }

        void setValue(E newValue) {
            this.key = newValue;
        }

        E getValue() {
            return (E)this.key;
        }

        public String toString() {
            return String.format("MutableTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", this.key, this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr<E>
    extends AbstractIterator<E> {
        private Node<E> node;

        Itr(Node<E> node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public E next() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

