/*
 * Decompiled with CFR 0.152.
 */
package kala.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.Conditions;
import kala.collection.AnySeqView;
import kala.collection.ArraySeq;
import kala.collection.CollectionView;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableArray;
import kala.collection.internal.CollectionHelper;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.view.SeqViews;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import kala.function.Predicates;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SeqView<E>
extends CollectionView<E>,
SeqLike<E>,
AnySeqView<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> SeqView<E> narrow(SeqView<? extends E> view) {
        return view;
    }

    @NotNull
    public static <E> SeqView<E> empty() {
        return SeqViews.Empty.INSTANCE;
    }

    @NotNull
    public static <E> SeqView<E> of(E value) {
        return new SeqViews.Single<E>(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "SeqView";
    }

    @Override
    @NotNull
    default public SeqView<E> view() {
        return this;
    }

    @Override
    @NotNull
    default public SeqView<E> slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return SeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new SeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @NotNull
    default public SeqView<E> sliceView(int beginIndex, int endIndex) {
        return this.slice(beginIndex, endIndex);
    }

    @Override
    @NotNull
    default public SeqView<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return SeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return SeqView.empty();
        }
        return new SeqViews.Drop(this, n);
    }

    @Override
    @NotNull
    default public SeqView<E> dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return SeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return SeqView.empty();
        }
        return new SeqViews.DropLast(this, n);
    }

    @Override
    @NotNull
    default public SeqView<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new SeqViews.DropWhile<E>(this, predicate);
    }

    @Override
    @NotNull
    default public SeqView<E> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return SeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return SeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new SeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public SeqView<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return SeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return SeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new SeqViews.TakeLast(this, n);
    }

    @Override
    @NotNull
    default public SeqView<E> takeWhile(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new SeqViews.TakeWhile<E>(this, predicate);
    }

    @Override
    @NotNull
    default public SeqView<E> updated(int index, E newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new SeqViews.Updated<E>(this, index, newValue);
    }

    @Override
    @NotNull
    default public SeqView<E> concat(@NotNull SeqLike<? extends E> other) {
        Objects.requireNonNull(other);
        return new SeqViews.Concat<E>(this, SeqView.narrow(other.view()));
    }

    @Override
    @NotNull
    default public SeqView<E> concat(@NotNull List<? extends E> other) {
        Objects.requireNonNull(other);
        if (other instanceof AsJavaConvert.SeqAsJava) {
            return this.concat((SeqLike)((AsJavaConvert.SeqAsJava)other).source);
        }
        return this.concat((SeqLike)((Object)Seq.wrapJava(other).view()));
    }

    @Override
    @NotNull
    default public SeqView<E> appended(E value) {
        return new SeqViews.Appended<E>(this, value);
    }

    @Override
    @NotNull
    default public SeqView<E> appendedAll(@NotNull Iterable<? extends E> postfix) {
        Objects.requireNonNull(postfix);
        return new SeqViews.Concat(this, CollectionHelper.asSeq(postfix));
    }

    @Override
    @NotNull
    default public SeqView<E> appendedAll(E @NotNull [] postfix) {
        Objects.requireNonNull(postfix);
        return new SeqViews.Concat<E>(this, ArraySeq.wrap(postfix));
    }

    @Override
    @NotNull
    default public SeqView<E> prepended(E value) {
        return new SeqViews.Prepended<E>(this, value);
    }

    @Override
    @NotNull
    default public SeqView<E> prependedAll(@NotNull Iterable<? extends E> prefix) {
        Objects.requireNonNull(prefix);
        return new SeqViews.Concat(CollectionHelper.asSeq(prefix), this);
    }

    @Override
    @NotNull
    default public SeqView<E> prependedAll(E @NotNull [] prefix) {
        Objects.requireNonNull(prefix);
        return new SeqViews.Concat<E>(ArraySeq.wrap(prefix), this);
    }

    @Override
    @NotNull
    default public SeqView<E> sorted() {
        return this.sorted((Comparator)null);
    }

    @Override
    @NotNull
    default public SeqView<E> sorted(Comparator<? super E> comparator) {
        return new SeqViews.Sorted<E>(this, comparator);
    }

    @Override
    @NotNull
    default public SeqView<E> reversed() {
        return new SeqViews.Reversed(this);
    }

    @Override
    @NotNull
    default public SeqView<E> filter(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new SeqViews.Filter<E>(this, predicate);
    }

    @Override
    @NotNull
    default public SeqView<E> filterNot(@NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        return new SeqViews.FilterNot<E>(this, predicate);
    }

    @Override
    @NotNull
    default public SeqView<E> filterNotNull() {
        return new SeqViews.FilterNotNull(this);
    }

    @Override
    @NotNull
    default public <U> @NotNull SeqView<@NotNull U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(Predicates.instanceOf(clazz));
    }

    @Override
    @NotNull
    default public <U> SeqView<U> map(@NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.Mapped<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> mapIndexed(@NotNull IndexedFunction<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.MapIndexed<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> mapNotNull(@NotNull Function<? super E, ? extends @Nullable U> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.MapNotNull<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> mapIndexedNotNull(@NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.MapIndexedNotNull<U, E>(this, mapper);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> mapMulti(@NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.MapMulti(this, mapper);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> mapIndexedMulti(@NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.MapIndexedMulti(this, mapper);
    }

    @Override
    @NotNull
    default public <U> SeqView<U> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return new SeqViews.FlatMapped(this, mapper);
    }

    @NotNull
    default public Tuple2<? extends SeqView<E>, ? extends SeqView<E>> span(@NotNull Predicate<? super E> predicate) {
        return Tuple.of((Object)this.takeWhile((Predicate)predicate), (Object)this.dropWhile((Predicate)predicate));
    }

    @Override
    @NotNull
    default public SeqView<E> distinct() {
        LinkedHashSet set = new LinkedHashSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            set.add(e);
        }
        return ImmutableArray.Unsafe.wrap(set.toArray()).view();
    }
}

