/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import kala.collection.AbstractMap;
import kala.collection.factory.MapFactory;
import kala.collection.immutable.ImmutableMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableMap<K, V>
extends AbstractMap<K, V>
implements ImmutableMap<K, V> {
    static <K, V, T extends ImmutableMap<K, ? extends V>, Builder> T putted(@NotNull ImmutableMap<K, ? extends V> map, K key, V value, MapFactory<K, V, Builder, ? extends T> factory) {
        if (map.contains(key, value)) {
            return (T)map;
        }
        Object builder = factory.newBuilder();
        int ks = map.knownSize();
        if (ks >= 0) {
            factory.sizeHint(builder, ks + 1);
        }
        map.forEach((k, v) -> factory.addToBuilder(builder, k, v));
        factory.addToBuilder(builder, key, value);
        return (T)((ImmutableMap)factory.build(builder));
    }

    static <K, V, T extends ImmutableMap<K, ? extends V>, Builder> T removed(@NotNull ImmutableMap<K, ? extends V> map, K key, MapFactory<K, V, Builder, ? extends T> factory) {
        if (!map.containsKey(key)) {
            return (T)map;
        }
        Object builder = factory.newBuilder();
        int ks = map.knownSize();
        if (ks > 0) {
            factory.sizeHint(builder, ks - 1);
        }
        if (key == null) {
            map.forEach((k, v) -> {
                if (null != k) {
                    factory.addToBuilder(builder, k, v);
                }
            });
        } else {
            map.forEach((k, v) -> {
                if (!key.equals(k)) {
                    factory.addToBuilder(builder, k, v);
                }
            });
        }
        return (T)((ImmutableMap)factory.build(builder));
    }
}

