/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.collection.ArraySeq;
import kala.collection.base.GenericArrays;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableArrayList;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableArray<E>
extends ArraySeq<E>
implements ImmutableSeq<E>,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableArray<?> EMPTY = new ImmutableArray(GenericArrays.EMPTY_OBJECT_ARRAY);
    private static final Factory<?> FACTORY = new Factory();

    private ImmutableArray(Object[] array) {
        super(array);
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableArray<E> narrow(ImmutableArray<? extends E> array) {
        return array;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableArray<E>> factory() {
        return FACTORY;
    }

    @NotNull
    public static <E> ImmutableArray<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableArray<E> of() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1) {
        return new ImmutableArray<E>(new Object[]{value1});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2) {
        return new ImmutableArray<E>(new Object[]{value1, value2});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2, E value3) {
        return new ImmutableArray<E>(new Object[]{value1, value2, value3});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2, E value3, E value4) {
        return new ImmutableArray<E>(new Object[]{value1, value2, value3, value4});
    }

    @NotNull
    public static <E> ImmutableArray<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ImmutableArray<E>(new Object[]{value1, value2, value3, value4, value5});
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <E> ImmutableArray<E> of(E ... values) {
        return ImmutableArray.from(values);
    }

    @NotNull
    public static <E> ImmutableArray<E> from(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>((Object[])values.clone());
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Traversable<? extends E> values) {
        if (values instanceof ImmutableArray) {
            return (ImmutableArray)values;
        }
        if (values.knownSize() == 0) {
            return ImmutableArray.empty();
        }
        Object[] arr = values.toArray();
        if (arr.length == 0) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>(arr);
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Collection<? extends E> values) {
        if (values.size() == 0) {
            return ImmutableArray.empty();
        }
        return new ImmutableArray<E>(values.toArray());
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values instanceof ImmutableArray) {
            return (ImmutableArray)((Object)values);
        }
        if (values instanceof Traversable) {
            return ImmutableArray.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return ImmutableArray.from((Collection)values);
        }
        return MutableArrayList.from(values).toImmutableArray();
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableArray.empty();
        }
        MutableArrayList<E> buffer = new MutableArrayList<E>();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer.toImmutableArray();
    }

    @NotNull
    public static <E> ImmutableArray<E> from(@NotNull Stream<? extends E> stream) {
        Object[] arr = stream.toArray();
        return arr.length == 0 ? ImmutableArray.empty() : new ImmutableArray<E>(arr);
    }

    @NotNull
    public static <E> ImmutableArray<E> fill(int n, E value) {
        if (n <= 0) {
            return ImmutableArray.empty();
        }
        Object[] ans = new Object[n];
        if (value != null) {
            Arrays.fill(ans, value);
        }
        return new ImmutableArray<E>(ans);
    }

    @NotNull
    public static <E> ImmutableArray<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return ImmutableArray.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.get();
        }
        return new ImmutableArray<E>(ans);
    }

    @NotNull
    public static <E> ImmutableArray<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return ImmutableArray.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = init.apply(i);
        }
        return new ImmutableArray<E>(ans);
    }

    @NotNull
    public static <E> ImmutableArray<E> generateUntil(@NotNull Supplier<? extends E> supplier, @NotNull Predicate<? super E> predicate) {
        E value;
        MutableArrayList<E> builder = new MutableArrayList<E>();
        while (!predicate.test(value = supplier.get())) {
            builder.append(value);
        }
        return builder.toImmutableArray();
    }

    @NotNull
    public static <E> ImmutableArray<E> generateUntilNull(@NotNull Supplier<? extends @Nullable E> supplier) {
        E value;
        MutableArrayList<E> builder = new MutableArrayList<E>();
        while ((value = supplier.get()) != null) {
            builder.append(value);
        }
        return builder.toImmutableArray();
    }

    Object @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableArray";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableArray<U>> iterableFactory() {
        return ImmutableArray.factory();
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1024);
    }

    @NotNull
    public @NotNull Tuple2<@NotNull ImmutableSeq<E>, @NotNull ImmutableSeq<E>> span(@NotNull Predicate<? super E> predicate) {
        int idx;
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return new Tuple2(ImmutableArray.empty(), ImmutableArray.empty());
        }
        for (idx = 0; idx < size && predicate.test(elements[idx]); ++idx) {
        }
        if (idx == 0) {
            return new Tuple2(ImmutableArray.empty(), (Object)this);
        }
        if (idx == size) {
            return new Tuple2((Object)this, ImmutableArray.empty());
        }
        return new Tuple2(new ImmutableArray<E>(Arrays.copyOfRange(elements, 0, idx)), new ImmutableArray<E>(Arrays.copyOfRange(elements, idx, size)));
    }

    @Override
    @NotNull
    public ImmutableArray<E> toImmutableArray() {
        return this;
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableArrayList<E>, ImmutableArray<E>> {
        Factory() {
        }

        public ImmutableArray<E> empty() {
            return ImmutableArray.empty();
        }

        public ImmutableArray<E> from(E @NotNull [] values) {
            return ImmutableArray.from(values);
        }

        public ImmutableArray<E> from(@NotNull Iterable<? extends E> values) {
            return ImmutableArray.from(values);
        }

        public ImmutableArray<E> from(@NotNull Iterator<? extends E> it) {
            return ImmutableArray.from(it);
        }

        public ImmutableArray<E> fill(int n, E value) {
            return ImmutableArray.fill(n, value);
        }

        public ImmutableArray<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return ImmutableArray.fill(n, supplier);
        }

        public ImmutableArray<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return ImmutableArray.fill(n, init);
        }

        public MutableArrayList<E> newBuilder() {
            return new MutableArrayList();
        }

        public void addToBuilder(@NotNull MutableArrayList<E> buffer, E value) {
            buffer.append(value);
        }

        public void sizeHint(@NotNull MutableArrayList<E> buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableArrayList<E> mergeBuilder(@NotNull MutableArrayList<E> buffer1, @NotNull MutableArrayList<E> buffer2) {
            buffer1.appendAll((Iterable<E>)((Object)buffer2));
            return buffer1;
        }

        public ImmutableArray<E> build(@NotNull MutableArrayList<E> buffer) {
            return buffer.toImmutableArray();
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static <E> ImmutableArray<E> wrap(Object @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableArray(array);
        }
    }
}

