/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import kala.collection.base.ObjectArrays;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableSet;
import kala.collection.immutable.ImmutableSet;
import kala.collection.mutable.MutableArraySet;
import org.jetbrains.annotations.NotNull;

public final class ImmutableArraySet<E>
extends AbstractImmutableSet<E>
implements Serializable {
    private static final long serialVersionUID = -7762205380003045169L;
    private static final Factory<?> FACTORY = new Factory();
    private static final ImmutableArraySet<?> EMPTY = new ImmutableArraySet(ObjectArrays.EMPTY);
    private final Object[] elements;

    private ImmutableArraySet(Object[] elements) {
        this.elements = elements;
    }

    public static <E> CollectionFactory<E, ?, ? extends ImmutableArraySet<E>> factory() {
        return FACTORY;
    }

    @NotNull
    public static <E> ImmutableArraySet<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of() {
        return ImmutableArraySet.empty();
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of(E value1) {
        return new ImmutableArraySet<E>(new Object[]{value1});
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of(E value1, E value2) {
        if (Objects.equals(value1, value2)) {
            return ImmutableArraySet.of(value1);
        }
        return new ImmutableArraySet<E>(new Object[]{value1, value2});
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of(E value1, E value2, E value3) {
        MutableArraySet builder = new MutableArraySet();
        builder.add((Object)value1);
        builder.add((Object)value2);
        builder.add((Object)value3);
        return new ImmutableArraySet<E>(builder.toArray());
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of(E value1, E value2, E value3, E value4) {
        MutableArraySet builder = new MutableArraySet();
        builder.add((Object)value1);
        builder.add((Object)value2);
        builder.add((Object)value3);
        builder.add((Object)value4);
        return new ImmutableArraySet<E>(builder.toArray());
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of(E value1, E value2, E value3, E value4, E value5) {
        MutableArraySet builder = new MutableArraySet();
        builder.add((Object)value1);
        builder.add((Object)value2);
        builder.add((Object)value3);
        builder.add((Object)value4);
        builder.add((Object)value5);
        return new ImmutableArraySet<E>(builder.toArray());
    }

    @NotNull
    public static <E> ImmutableArraySet<E> of(E ... values) {
        return ImmutableArraySet.from(values);
    }

    @NotNull
    public static <E> ImmutableArraySet<E> from(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableArraySet.empty();
        }
        MutableArraySet builder = new MutableArraySet();
        for (E value : values) {
            builder.add((Object)value);
        }
        return new ImmutableArraySet<E>(builder.toArray());
    }

    @NotNull
    public static <E> ImmutableArraySet<E> from(@NotNull Iterable<? extends E> values) {
        return ImmutableArraySet.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableArraySet<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableArraySet.empty();
        }
        MutableArraySet builder = new MutableArraySet();
        while (it.hasNext()) {
            builder.add((Object)it.next());
        }
        return new ImmutableArraySet<E>(builder.toArray());
    }

    @NotNull
    public static <E> ImmutableArraySet<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableArraySet.factory());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableArraySet";
    }

    @NotNull
    public Iterator<E> iterator() {
        return ObjectArrays.iterator((Object[])this.elements);
    }

    @Override
    @NotNull
    public ImmutableSet<E> added(E value) {
        if (this.contains(value)) {
            return this;
        }
        Object[] newElements = Arrays.copyOf(this.elements, this.elements.length + 1);
        newElements[newElements.length - 1] = value;
        return new ImmutableArraySet<E>(newElements);
    }

    @Override
    @NotNull
    public ImmutableSet<E> removed(E value) {
        int idx = ObjectArrays.indexOf((Object[])this.elements, value);
        if (idx < 0) {
            return this;
        }
        if (this.elements.length == 1) {
            return ImmutableArraySet.empty();
        }
        Object[] newElements = new Object[this.elements.length - 1];
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx + 1, newElements, idx, this.elements.length - idx - 1);
        return new ImmutableArraySet<E>(newElements);
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableArraySet<E>, ImmutableArraySet<E>> {
        private Factory() {
        }

        public MutableArraySet<E> newBuilder() {
            return new MutableArraySet();
        }

        public void addToBuilder(@NotNull MutableArraySet<E> builder, E value) {
            builder.add((Object)value);
        }

        public MutableArraySet<E> mergeBuilder(@NotNull MutableArraySet<E> builder1, @NotNull MutableArraySet<E> builder2) {
            builder1.addAll((Iterable)((Object)builder2));
            return builder1;
        }

        public ImmutableArraySet<E> build(MutableArraySet<E> builder) {
            if (builder.isEmpty()) {
                return (ImmutableArraySet)this.empty();
            }
            return new ImmutableArraySet(builder.toArray());
        }
    }
}

