/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.ImmutableSet;
import kala.collection.internal.convert.FromJavaConvert;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ImmutableHashSet<E>
extends FromJavaConvert.SetFromJava<E>
implements ImmutableSet<E>,
Serializable {
    private static final long serialVersionUID = 9051623197618851317L;
    private static final Factory<?> FACTORY = new Factory();
    private static final ImmutableHashSet<?> EMPTY = new ImmutableHashSet();

    ImmutableHashSet(HashSet<E> source) {
        super(source);
    }

    public ImmutableHashSet() {
        this(new HashSet());
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableHashSet<E> narrow(ImmutableHashSet<? extends E> set) {
        return set;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableHashSet<E>> factory() {
        return FACTORY;
    }

    @NotNull
    public static <E> ImmutableHashSet<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of() {
        return ImmutableHashSet.empty();
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of(E value1) {
        HashSet<E> s = new HashSet<E>();
        s.add(value1);
        return new ImmutableHashSet(s);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of(E value1, E value2) {
        HashSet<E> s = new HashSet<E>();
        s.add(value1);
        s.add(value2);
        return new ImmutableHashSet(s);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of(E value1, E value2, E value3) {
        HashSet<E> s = new HashSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableHashSet(s);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of(E value1, E value2, E value3, E value4) {
        HashSet<E> s = new HashSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableHashSet(s);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of(E value1, E value2, E value3, E value4, E value5) {
        HashSet<E> s = new HashSet<E>();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableHashSet(s);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> of(E ... values) {
        return ImmutableHashSet.from(values);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> from(E @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableHashSet.empty();
        }
        HashSet set = new HashSet();
        Collections.addAll(set, values);
        return new ImmutableHashSet(set);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> from(@NotNull Iterable<? extends E> values) {
        Iterator<E> it = values.iterator();
        if (!it.hasNext()) {
            return ImmutableHashSet.empty();
        }
        HashSet<E> set = new HashSet<E>();
        while (it.hasNext()) {
            set.add(it.next());
        }
        return new ImmutableHashSet(set);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return ImmutableHashSet.empty();
        }
        HashSet<E> set = new HashSet<E>();
        while (it.hasNext()) {
            set.add(it.next());
        }
        return new ImmutableHashSet(set);
    }

    @NotNull
    public static <E> ImmutableHashSet<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableHashSet.factory());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableHashSet";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableHashSet<U>> iterableFactory() {
        return ImmutableHashSet.factory();
    }

    private Object writeReplace() {
        return new SerializationWrapper(this);
    }

    private static final class Factory<E>
    implements CollectionFactory<E, Builder<E>, ImmutableHashSet<E>> {
        private Factory() {
        }

        public Builder<E> newBuilder() {
            return new Builder();
        }

        public ImmutableHashSet<E> build(Builder<E> builder) {
            return builder.build();
        }

        public void addToBuilder(@NotNull Builder<E> builder, E value) {
            builder.add(value);
        }

        public Builder<E> mergeBuilder(@NotNull Builder<E> builder1, @NotNull Builder<E> builder2) {
            return builder1.merge(builder2);
        }
    }

    private static final class SerializationWrapper<E>
    implements Externalizable {
        private ImmutableHashSet<E> value;

        public SerializationWrapper() {
        }

        SerializationWrapper(ImmutableHashSet<E> value) {
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value.size());
            Iterator iterator = this.value.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                out.writeObject(e);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            assert (this.value == null);
            HashSet<Object> set = new HashSet<Object>();
            int len = in.readInt();
            for (int i = 0; i < len; ++i) {
                set.add(in.readObject());
            }
            this.value = set.isEmpty() ? ImmutableHashSet.empty() : new ImmutableHashSet(set);
        }

        private Object readResolve() {
            return this.value;
        }
    }

    private static final class Builder<E> {
        private boolean aliased = false;
        private HashSet<E> set = new HashSet();

        private Builder() {
        }

        private void ensureUnaliased() {
            if (this.aliased) {
                this.set = new HashSet<E>(this.set);
                this.aliased = false;
            }
        }

        void add(E value) {
            this.ensureUnaliased();
            this.set.add(value);
        }

        Builder<E> merge(Builder<E> other) {
            this.ensureUnaliased();
            this.set.addAll(other.set);
            return this;
        }

        ImmutableHashSet<E> build() {
            this.aliased = true;
            return new ImmutableHashSet<E>(this.set);
        }
    }
}

